/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.addressbook.AbstractAddressBookWordSelectData;
import com.aimluck.eip.addressbook.AddressBookGroupResultData;
import com.aimluck.eip.addressbook.AddressBookWordSelectData;
import com.aimluck.eip.addressbook.util.AddressBookUtils;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookCorpWordSelectData
extends AbstractAddressBookWordSelectData<TurbineUser, TurbineUser> {
    private List<AddressBookGroupResultData> groupList;
    private List<ALEipGroup> myGroupList = null;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookWordSelectData.class.getName());

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    protected ResultList<TurbineUser> selectList(RunData rundata, Context context) {
        ResultList list;
        try {
            SelectQuery<TurbineUser> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            list = query.getResultList();
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookCorpWordSelectData.selectList", (Throwable)ex);
            return null;
        }
        return list;
    }

    protected TurbineUser selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultData(TurbineUser obj) {
        try {
            return AddressBookUtils.getCorpResultData(obj, this.getStrLength());
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookCorpWordSelectData.getResultData", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(TurbineUser obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("corp_group", "turbineUserGroupRole.turbineGroup.GROUP_NAME");
        map.putValue("name_kana", "lastNameKana");
        return map;
    }

    private SelectQuery<TurbineUser> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = null;
        String word = this.searchWord.getValue();
        String transWord = ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.searchWord.getValue()));
        query = Database.query(TurbineUser.class);
        Expression exp_exclude_my_group = ExpressionFactory.matchExp((String)"turbineUserGroupRole.turbineGroup.ownerId", (Object)1);
        Expression exp01 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
        query.setQualifier(exp01);
        Expression exp02 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)1);
        Expression exp03 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)2);
        Expression exp04 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)3);
        query.andQualifier(exp02.andExp(exp03).andExp(exp04));
        Expression exp11 = ExpressionFactory.likeExp((String)"firstName", (Object)("%" + word + "%"));
        Expression exp12 = ExpressionFactory.likeExp((String)"lastName", (Object)("%" + word + "%"));
        Expression exp13 = ExpressionFactory.likeExp((String)"firstNameKana", (Object)("%" + word + "%"));
        Expression exp14 = ExpressionFactory.likeExp((String)"lastNameKana", (Object)("%" + word + "%"));
        Expression exp15 = ExpressionFactory.likeExp((String)"email", (Object)("%" + word + "%"));
        Expression exp16 = ExpressionFactory.likeExp((String)"turbineUserGroupRole.turbineGroup.groupAliasName", (Object)("%" + word + "%"));
        exp16 = exp16.andExp(exp_exclude_my_group);
        Expression exp21 = ExpressionFactory.likeExp((String)"outTelephone", (Object)("%" + word + "%"));
        Expression exp22 = ExpressionFactory.likeExp((String)"inTelephone", (Object)("%" + word + "%"));
        Expression exp23 = ExpressionFactory.likeExp((String)"cellularPhone", (Object)("%" + word + "%"));
        Expression exp31 = ExpressionFactory.likeExp((String)"firstName", (Object)("%" + transWord + "%"));
        Expression exp32 = ExpressionFactory.likeExp((String)"lastName", (Object)("%" + transWord + "%"));
        Expression exp33 = ExpressionFactory.likeExp((String)"firstNameKana", (Object)("%" + transWord + "%"));
        Expression exp34 = ExpressionFactory.likeExp((String)"lastNameKana", (Object)("%" + transWord + "%"));
        Expression exp35 = ExpressionFactory.likeExp((String)"turbineUserGroupRole.turbineGroup.groupAliasName", (Object)("%" + transWord + "%"));
        exp35 = exp35.andExp(exp_exclude_my_group);
        if (word != null && !"".equals(word)) {
            query.andQualifier(exp11.orExp(exp12).orExp(exp13).orExp(exp14).orExp(exp15).orExp(exp16).orExp(exp21).orExp(exp22).orExp(exp23).orExp(exp31).orExp(exp32).orExp(exp33).orExp(exp34).orExp(exp35));
        }
        query.distinct();
        return query;
    }

    @Override
    public void loadGroups(RunData rundata, Context context) {
        this.groupList = AddressBookUtils.getMyGroups(rundata);
        try {
            List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
            this.myGroupList = new ArrayList<ALEipGroup>();
            int length = myGroups.size();
            for (int i = 0; i < length; ++i) {
                this.myGroupList.add((ALEipGroup)myGroups.get(i));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookCorpWordSelectData.loadGroups", (Throwable)ex);
        }
    }

    @Override
    public List<AddressBookGroupResultData> getGroupList() {
        return this.groupList;
    }

    @Override
    public List<ALEipGroup> getMyGroupList() {
        return this.myGroupList;
    }

    public String getAclPortletFeature() {
        return "addressbook_address_inside";
    }

    @Override
    public String getTemplateFilePath() {
        return "portlets/html/ja/ajax-addressbook-corplist.vm";
    }
}

