/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.eip.addressbook.AddressBookFilterdSelectData;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.cayenne.om.portlet.EipTAddressbookGroupMap;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookGroupMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookGroupMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            SelectQuery query = Database.query(EipMAddressGroup.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.inDbExp((String)"GROUP_ID", values);
            query.andQualifier(exp2);
            List groups = query.fetchList();
            int grouplistsize = groups.size();
            for (int i = 0; i < grouplistsize; ++i) {
                EipMAddressGroup group = (EipMAddressGroup)groups.get(i);
                Integer entityId = group.getGroupId();
                String groupName = group.getGroupName();
                Database.delete((Persistent)group);
                Database.commit();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 162, groupName);
            }
            SelectQuery mapquery = Database.query(EipTAddressbookGroupMap.class);
            Expression mapexp = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)ALEipUtils.getUserId((RunData)rundata));
            mapquery.setQualifier(mapexp);
            List maps = mapquery.fetchList();
            Database.deleteAll((List)maps);
            Database.commit();
            String filtername = AddressBookFilterdSelectData.class.getName() + "filter";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)filtername);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AddressBookGroupMultiDelete.action", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return "addressbook_company_group";
    }
}

