/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.msgboard;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategoryMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.msgboard.MsgboardCategoryResultData;
import com.aimluck.eip.msgboard.util.MsgboardUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MsgboardCategorySelectData
extends ALAbstractSelectData<EipTMsgboardCategoryMap, EipTMsgboardCategory>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardCategorySelectData.class.getName());
    private List<MsgboardCategoryResultData> categoryList;
    private int categorySum;
    private int uid;
    private List<ALEipUser> members;
    private boolean authority_detail;
    private boolean authority_edit;
    private boolean authority_delete;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"category_name");
            logger.debug((Object)"[MsgboardCategorySelectData] Init Parameter. : category_name");
        }
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.authority_detail = MsgboardUtils.checkPermission(rundata, context, 2, "msgboard_category_other");
        this.authority_edit = MsgboardUtils.checkPermission(rundata, context, 8, "msgboard_category_other");
        this.authority_delete = MsgboardUtils.checkPermission(rundata, context, 16, "msgboard_category_other");
        super.init(action, rundata, context);
    }

    public void loadCategoryList(RunData rundata) {
        this.categoryList = MsgboardUtils.loadCategoryList(rundata);
    }

    protected ResultList<EipTMsgboardCategoryMap> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipTMsgboardCategoryMap> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.categorySum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"msgboard", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTMsgboardCategoryMap> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTMsgboardCategoryMap.class);
        Expression exp1 = ExpressionFactory.noMatchDbExp((String)"eipTMsgboardCategory.turbineUser.USER_ID", (Object)0);
        query.setQualifier(exp1);
        int loginUserId = ALEipUtils.getUserId((RunData)rundata);
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        boolean hasAclviewOther = aclhandler.hasAuthority(loginUserId, "msgboard_category_other", 1);
        Expression exp01 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)"T");
        Expression exp02 = ExpressionFactory.matchExp((String)"status", (Object)"O");
        Expression exp03 = ExpressionFactory.matchExp((String)"status", (Object)"A");
        Expression exp11 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)"F");
        Expression exp12 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
        if (!hasAclviewOther) {
            query.andQualifier(exp01.andExp(exp02.orExp(exp03)).orExp(exp11.andExp(exp12)));
        } else {
            query.andQualifier(exp01.andExp(exp02.orExp(exp03)).orExp(exp11.andExp(exp02.orExp(exp03))));
        }
        query.distinct(true);
        return query;
    }

    protected EipTMsgboardCategory selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return MsgboardUtils.getEipTMsgboardCategory(rundata, context, false);
    }

    protected Object getResultData(EipTMsgboardCategoryMap record) throws ALPageNotFoundException, ALDBErrorException {
        MsgboardCategoryResultData rd = new MsgboardCategoryResultData();
        rd.initField();
        try {
            EipTMsgboardCategory category = record.getEipTMsgboardCategory();
            rd.setCategoryId(category.getCategoryId().intValue());
            rd.setCategoryName(ALCommonUtils.compressString((String)category.getCategoryName(), (int)this.getStrLength()));
            rd.setNote(category.getNote());
            rd.setOwnerId(category.getTurbineUser().getUserId().longValue());
            rd.setPublicFlag("T".equals(category.getPublicFlag()));
            rd.setOwnerName(ALEipUtils.getUserFullName((int)category.getTurbineUser().getUserId()));
            rd.setLoginUserId(this.uid);
        }
        catch (Exception e) {
            logger.error((Object)"[MsgboardCategorySelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return rd;
    }

    protected Object getResultDataDetail(EipTMsgboardCategory record) throws ALPageNotFoundException, ALDBErrorException {
        MsgboardCategoryResultData rd = new MsgboardCategoryResultData();
        rd.initField();
        try {
            String loginUserStatus = null;
            boolean public_flag = "T".equals(record.getPublicFlag());
            SelectQuery mapquery = Database.query(EipTMsgboardCategoryMap.class);
            Expression mapexp = ExpressionFactory.matchDbExp((String)"CATEGORY_ID", (Object)record.getCategoryId());
            mapquery.setQualifier(mapexp);
            List list = mapquery.fetchList();
            ArrayList<Integer> users = new ArrayList<Integer>();
            int size = list.size();
            if (size == 1) {
                EipTMsgboardCategoryMap map = (EipTMsgboardCategoryMap)list.get(0);
                users.add(map.getUserId());
                loginUserStatus = map.getStatus();
            } else {
                for (int i = 0; i < size; ++i) {
                    EipTMsgboardCategoryMap map = (EipTMsgboardCategoryMap)list.get(i);
                    users.add(map.getUserId());
                    if (this.uid != map.getUserId()) continue;
                    loginUserStatus = map.getStatus();
                }
            }
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.inDbExp((String)"USER_ID", users);
            Expression nonDisabledexp = ExpressionFactory.noMatchExp((String)"disabled", (Object)"T");
            query.setQualifier(exp.andExp(nonDisabledexp));
            this.members = ALEipUtils.getUsersFromSelectQuery((SelectQuery)query);
            rd.setCategoryId(record.getCategoryId().intValue());
            rd.setCategoryName(record.getCategoryName());
            rd.setNote(record.getNote());
            rd.setOwnerId(record.getTurbineUser().getUserId().intValue());
            rd.setOwnerName(ALEipUtils.getUserFullName((int)record.getTurbineUser().getUserId()));
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            rd.setLoginUserId(this.uid);
            if (public_flag) {
                if ("A".equals(loginUserStatus)) {
                    rd.setAccessFlag(0);
                } else {
                    rd.setAccessFlag(1);
                }
            } else if ("A".equals(loginUserStatus)) {
                rd.setAccessFlag(3);
            } else {
                rd.setAccessFlag(2);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[MsgboardCategorySelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return rd;
    }

    public boolean doViewDetail(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 2);
            action.setMode("detail");
            EipTMsgboardCategory obj = this.selectDetail(rundata, context);
            if (obj != null) {
                this.data = this.getResultDataDetail(obj);
                boolean public_flag = "T".equals(obj.getPublicFlag());
                boolean isMember = false;
                SelectQuery mapquery = Database.query(EipTMsgboardCategoryMap.class);
                Expression mapexp = ExpressionFactory.matchDbExp((String)"CATEGORY_ID", (Object)obj.getCategoryId());
                mapquery.setQualifier(mapexp);
                List list = mapquery.fetchList();
                ArrayList<Integer> users = new ArrayList<Integer>();
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    EipTMsgboardCategoryMap map = (EipTMsgboardCategoryMap)list.get(i);
                    users.add(map.getUserId());
                    if (this.uid != map.getUserId()) continue;
                    isMember = true;
                }
                if (!(public_flag || isMember || this.authority_detail)) {
                    throw new ALPermissionException();
                }
            }
            action.setResultData((Object)this);
            action.putData(rundata, context);
            return this.data != null;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public List<MsgboardCategoryResultData> getCategoryList() {
        return this.categoryList;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("category_name", "eipTMsgboardCategory.categoryName");
        map.putValue("create_user", "eipTMsgboardCategory.turbineUser.lastNameKana");
        return map;
    }

    public int getCategorySum() {
        return this.categorySum;
    }

    public int getUserId() {
        return this.uid;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public boolean getAuthorityEdit() {
        return this.authority_edit;
    }

    public boolean getAuthorityDelete() {
        return this.authority_delete;
    }

    public List<ALEipUser> getMemberList() {
        return this.members;
    }

    public String getAclPortletFeature() {
        return "msgboard_category";
    }
}

