/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gadgets;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALApplication;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALOAuthConsumer;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.social.ALApplicationService;
import com.aimluck.eip.services.social.ALOAuthConsumerService;
import com.aimluck.eip.services.social.gadgets.ALGadgetSpec;
import com.aimluck.eip.services.social.model.ALApplicationGetRequest;
import com.aimluck.eip.services.social.model.ALApplicationPutRequest;
import com.aimluck.eip.services.social.model.ALOAuthConsumerPutRequest;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GadgetsAdminFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GadgetsAdminFormData.class.getName());
    private ALStringField url;
    private ALStringField title;
    private ALStringField description;
    private ALStringField icon;
    private List<ALOAuthConsumer> oAuthConsumers;
    private ALGadgetSpec metaData;
    private ALStringField sendActivity;
    private String appId;

    public void initField() {
        this.url = new ALStringField();
        this.url.setFieldName(ALLocalizationUtils.getl10n((String)"GADGETS_SETFIELDNAME_URL"));
        this.url.setTrim(true);
        this.title = new ALStringField();
        this.title.setFieldName(ALLocalizationUtils.getl10n((String)"GADGETS_SETFIELDNAME_TITLE"));
        this.title.setTrim(true);
        this.description = new ALStringField();
        this.description.setFieldName(ALLocalizationUtils.getl10n((String)"GADGETS_SETFIELDNAME_DESCRIPTION"));
        this.description.setTrim(true);
        this.icon = new ALStringField();
        this.icon.setFieldName(ALLocalizationUtils.getl10n((String)"GADGETS_SETFIELDNAME_ICON"));
        this.icon.setTrim(true);
        this.oAuthConsumers = new ArrayList<ALOAuthConsumer>();
        this.sendActivity = new ALStringField();
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (this.getMode().equals("update")) {
            this.appId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            ALApplication app = ALApplicationService.get((ALApplicationGetRequest)new ALApplicationGetRequest().withAppId(this.appId).withStatus(ALApplicationGetRequest.Status.ALL).withIsDetail(true).withIsFetchXml(true));
            if (app == null) {
                return false;
            }
            this.url.setValue(app.getUrl().getValue());
            this.title.setValue(app.getTitle().getValue());
            this.description.setValue(app.getDescription().getValue());
            this.icon.setValue(app.getIcon().getValue());
            this.oAuthConsumers = app.getOAuthConsumers();
            int size = this.oAuthConsumers.size();
            for (int i = 0; i < size; ++i) {
                ALOAuthConsumer service = this.oAuthConsumers.get(i);
                String key = "consumerKey" + i;
                String keyString = rundata.getParameters().getString(key);
                service.getConsumerKey().setValue(keyString);
                key = "consumerSecret" + i;
                keyString = rundata.getParameters().getString(key);
                service.getConsumerSecret().setValue(keyString);
                key = "type" + i;
                keyString = rundata.getParameters().getString(key);
                service.getType().setValue(keyString);
            }
        }
        return res;
    }

    protected void setValidator() throws ALPageNotFoundException, ALDBErrorException {
        this.url.setNotNull(true);
        this.url.limitMaxLength(255);
    }

    protected boolean validate(List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        if (!"update".equals(this.getMode())) {
            this.url.validate(msgList);
        }
        if (msgList.size() == 0) {
            this.metaData = ALApplicationService.getMetaData((String)this.url.getValue(), (boolean)true);
            if (!"update".equals(this.getMode()) && this.metaData == null) {
                msgList.add(ALLocalizationUtils.getl10n((String)"GADGETS_ALERT_SET_VALID_GADGET_URL"));
            }
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        String appId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        ALApplication app = ALApplicationService.get((ALApplicationGetRequest)new ALApplicationGetRequest().withAppId(appId).withStatus(ALApplicationGetRequest.Status.ALL).withIsDetail(true).withIsFetchXml(true));
        if (app == null) {
            return false;
        }
        this.url.setValue(app.getUrl().getValue());
        this.title.setValue(app.getTitle().getValue());
        this.description.setValue(app.getDescription().getValue());
        this.icon.setValue(app.getIcon().getValue());
        this.oAuthConsumers = app.getOAuthConsumers();
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            String activityLoginName = null;
            if ("true".equals(this.sendActivity.getValue())) {
                activityLoginName = ALEipUtils.getALEipUser((RunData)rundata).getName().getValue();
            }
            ALApplicationService.create((ALApplicationPutRequest)new ALApplicationPutRequest().withUrl(this.url.getValue()).withTitle(this.metaData.getTitle()).withActivityuserId(ALEipUtils.getUserId((RunData)rundata)).withDescription(this.metaData.getDescription()).withIcon(this.metaData.getIcon()).withActivityLoginName(activityLoginName));
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(ALEipUtils.getUserId((RunData)rundata), 6, "\u30a2\u30d7\u30ea\u300c" + this.metaData.getTitle() + "\u300d\u3092\u8ffd\u52a0");
        }
        catch (Throwable t) {
            logger.error((Object)t, t);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            ALApplicationService.update((String)this.appId, (ALApplicationPutRequest)new ALApplicationPutRequest().withTitle(this.metaData.getTitle()).withActivityuserId(ALEipUtils.getUserId((RunData)rundata)).withDescription(this.metaData.getDescription()).withIcon(this.metaData.getIcon()));
            for (ALOAuthConsumer service : this.oAuthConsumers) {
                ALOAuthConsumerService.put((ALOAuthConsumerPutRequest)new ALOAuthConsumerPutRequest().withAppId(this.appId).withName(service.getName().getValue()).withConsumerKey(service.getConsumerKey().getValue()).withConsumerSecret(service.getConsumerSecret().getValue()).withType("RSA-SHA1".equalsIgnoreCase(service.getType().getValue()) ? ALOAuthConsumerPutRequest.Type.RSASHA1 : ALOAuthConsumerPutRequest.Type.HMACSHA1));
            }
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(ALEipUtils.getUserId((RunData)rundata), 6, "\u30a2\u30d7\u30ea\u300c" + this.metaData.getTitle() + "\u300d\u3092\u66f4\u65b0");
        }
        catch (Throwable t) {
            logger.error((Object)t, t);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        String appId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            String deletedAppTitle = "";
            ALApplication app = ALApplicationService.get((ALApplicationGetRequest)new ALApplicationGetRequest().withAppId(appId).withStatus(ALApplicationGetRequest.Status.ALL).withIsDetail(true).withIsFetchXml(true));
            if (app != null) {
                deletedAppTitle = app.getTitle().toString();
            }
            ALApplicationService.delete((String[])new String[]{appId});
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(ALEipUtils.getUserId((RunData)rundata), 6, "\u30a2\u30d7\u30ea\u300c" + deletedAppTitle + "\u300d\u3092\u524a\u9664");
        }
        catch (Throwable t) {
            logger.error((Object)t, t);
            throw new ALDBErrorException();
        }
        return true;
    }

    public boolean enableFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            if (!this.doCheckSecurity(rundata, context)) {
                return false;
            }
            String appId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (appId == null || "".equals(appId)) {
                return false;
            }
            ALApplicationService.enable((String[])new String[]{appId});
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"gadgets", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean disableFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            if (!this.doCheckSecurity(rundata, context)) {
                return false;
            }
            String appId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (appId == null || "".equals(appId)) {
                return false;
            }
            ALApplicationService.disable((String[])new String[]{appId});
        }
        catch (Exception e) {
            logger.error((Object)"gadgets", (Throwable)e);
            return false;
        }
        return true;
    }

    public ALStringField getUrl() {
        return this.url;
    }

    public String getUrlCR() {
        return ALCommonUtils.replaceToAutoCR((String)this.url.toString());
    }

    public List<ALOAuthConsumer> getOAuthConsumers() {
        return this.oAuthConsumers;
    }

    public ALStringField getTitle() {
        return this.title;
    }

    public void setTitle(ALStringField title) {
        this.title = title;
    }

    public ALStringField getIcon() {
        return this.icon;
    }

    public void setIcon(ALStringField icon) {
        this.icon = icon;
    }

    public void setUrl(ALStringField url) {
        this.url = url;
    }

    public void setDescription(ALStringField description) {
        this.description = description;
    }

    public ALStringField getDescription() {
        return this.description;
    }

    public ALStringField getSendActivity() {
        return this.sendActivity;
    }

    public void setSendActivity(String sendActivity) {
        this.sendActivity.setValue(sendActivity);
    }
}

