/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gadgets.util;

import com.aimluck.eip.cayenne.om.account.JetspeedUserProfile;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.orm.query.Where;
import com.aimluck.eip.util.ALEipUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class PsmlDBUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)PsmlDBUtils.class.getName());

    public static String getMyHtmlPsml(RunData runData) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", ALEipUtils.getLoginName((RunData)runData));
        map.put("mediaType", "html");
        return PsmlDBUtils.getPsmlOne(map);
    }

    public static String getTemplateHtmlPsml(RunData runData) {
        return PsmlDBUtils.getPsmlOne(PsmlDBUtils.getTemplateMap());
    }

    public static String getPsmlOne(Map<String, String> map) {
        SelectQuery query = Database.query(JetspeedUserProfile.class);
        PsmlDBUtils.setProfileOneCriteria((SelectQuery<JetspeedUserProfile>)query, map);
        JetspeedUserProfile psml = (JetspeedUserProfile)query.fetchSingle();
        return new String(psml.getProfile());
    }

    public static JetspeedUserProfile getTemplateHtmlProfile() {
        DataContext dataContext = DataContext.getThreadDataContext();
        return PsmlDBUtils.getTemplateHtmlProfile(dataContext);
    }

    public static JetspeedUserProfile getTemplateHtmlProfile(DataContext dataContext) {
        return PsmlDBUtils.getProfileOne(PsmlDBUtils.getTemplateMap(), dataContext);
    }

    public static List<JetspeedUserProfile> getAllUserHtmlProfile() {
        DataContext dataContext = DataContext.getThreadDataContext();
        return PsmlDBUtils.getAllUserHtmlProfile(dataContext);
    }

    public static List<JetspeedUserProfile> getAllUserHtmlProfile(DataContext dataContext) {
        return PsmlDBUtils.getProfile(PsmlDBUtils.getHtmlMap(), dataContext);
    }

    public static JetspeedUserProfile getProfileOne(Map<String, String> map, DataContext dataContext) {
        SelectQuery query = Database.query((DataContext)dataContext, JetspeedUserProfile.class);
        PsmlDBUtils.setProfileOneCriteria((SelectQuery<JetspeedUserProfile>)query, map);
        return (JetspeedUserProfile)query.fetchSingle();
    }

    public static List<JetspeedUserProfile> getProfile(Map<String, String> map, DataContext dataContext) {
        SelectQuery query = Database.query((DataContext)dataContext, JetspeedUserProfile.class);
        if (map.containsKey("userName")) {
            PsmlDBUtils.setProfileOneCriteria((SelectQuery<JetspeedUserProfile>)query, map);
        } else {
            PsmlDBUtils.setAllUserProfileCriteria((SelectQuery<JetspeedUserProfile>)query, map);
        }
        return query.fetchList();
    }

    public static void setProfileOneCriteria(SelectQuery<JetspeedUserProfile> query, Map<String, String> map) {
        query.where(new Where[]{Operations.eq((String)"mediaType", (Object)map.get("mediaType")), Operations.and((Where[])new Where[]{Operations.eq((String)"userName", (Object)map.get("userName"))})});
    }

    public static void setAllUserProfileCriteria(SelectQuery<JetspeedUserProfile> query, Map<String, String> map) {
        query.where(new Where[]{Operations.eq((String)"mediaType", (Object)map.get("mediaType")), Operations.and((Where[])new Where[]{Operations.notIn((String)"userName", (Object[])new Object[]{"admin", "anon", "template"})})});
    }

    public static Map<String, String> getTemplateMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", "template");
        map.put("mediaType", "html");
        return map;
    }

    public static Map<String, String> getHtmlMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mediaType", "html");
        return map;
    }

    public static void checkAndFixInconsistency(String userName) {
        DataContext dataContext = DataContext.getThreadDataContext();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", userName);
        map.put("mediaType", "html");
        List<JetspeedUserProfile> list = PsmlDBUtils.getProfile(map, dataContext);
        if (list.size() > 1) {
            try {
                list.remove(0);
                Database.deleteAll(list);
                Database.commit();
            }
            catch (Exception e) {
                Database.rollback();
                logger.error((Object)"[PsmlDBUtils]", (Throwable)e);
            }
        }
        try {
            TurbineUser tuser = ALEipUtils.getTurbineUser((String)userName);
            if (tuser == null) {
                SelectQuery query = Database.query(JetspeedUserProfile.class);
                query.where(Operations.eq((String)"userName", (Object)userName));
                List result = query.fetchList();
                Database.deleteAll((List)result);
                Database.commit();
            }
        }
        catch (ALDBErrorException e) {
            Database.rollback();
            logger.error((Object)e, (Throwable)e);
        }
    }
}

