/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gadgets.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.servlet.ServletConfig;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jetspeed.om.profile.BasePSMLDocument;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.RunData;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PsmlUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)PsmlUtils.class.getName());
    public static final String ADMIN_NAME = "admin";
    public static final String ANON_NAME = "anon";
    public static final String TEMPLATE_NAME = "template";
    public static final String DEFAULT_PAGE_NAME = "default.psml";
    public static final String ADMIN_PORTRET_ID = "101";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ELEMENT_ENTRY = "entry";
    public static final String ELEMENT_PARAMETER = "parameter";
    public static final String DEFAULT_TIMELINE_PAGE_NAME = "defaultTimeline.psml";
    public static final String DEFAULT_SCHEDULE_PAGE_NAME = "defaultSchedule.psml";

    public static String parsePsml(String psml) throws Exception {
        try {
            Document dom = PsmlUtils.loadXMLFrom(psml);
            if (dom == null) {
                return null;
            }
            NodeList portlets = dom.getElementsByTagName("portlets");
            for (int i = 0; i < portlets.getLength(); ++i) {
                Node node = portlets.item(i);
                if (node.getAttributes().getNamedItem(ATTRIBUTE_ID).getNodeValue().equals(ADMIN_PORTRET_ID)) {
                    Node parent = node.getParentNode();
                    parent.removeChild(node);
                    continue;
                }
                node.getAttributes().removeNamedItem(ATTRIBUTE_ID);
            }
            NodeList entry = dom.getElementsByTagName(ELEMENT_ENTRY);
            for (int i = 0; i < entry.getLength(); ++i) {
                Node node = entry.item(i);
                node.getAttributes().removeNamedItem(ATTRIBUTE_ID);
            }
            NodeList params = dom.getElementsByTagName(ELEMENT_PARAMETER);
            for (int i = 0; i < params.getLength(); ++i) {
                Node node = params.item(i);
                Node parent = node.getParentNode();
                if (parent.getAttributes().getNamedItem("parent") == null) continue;
                if (parent.getAttributes().getNamedItem("parent").getNodeValue().equals("Schedule") || parent.getAttributes().getNamedItem("parent").getNodeValue().equals("AjaxScheduleWeekly")) {
                    parent.removeChild(node);
                    --i;
                }
                if (!parent.getAttributes().getNamedItem("parent").getNodeValue().equals("GadgetsTemplate") || !node.getAttributes().getNamedItem("name").getNodeValue().equals("mid")) continue;
                parent.removeChild(node);
                --i;
            }
            StringWriter sw = new StringWriter();
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer transformer = tfactory.newTransformer();
            transformer.transform(new DOMSource(dom), new StreamResult(sw));
            return sw.toString();
        }
        catch (RuntimeException ex) {
            logger.error((Object)"[PsmlUtils]", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"[PsmlUtils]", (Throwable)ex);
            throw ex;
        }
    }

    public static String parsePsmlForAllUser(String psml) throws Exception {
        try {
            Document dom = PsmlUtils.loadXMLFrom(psml);
            NodeList portlets = dom.getElementsByTagName("portlets");
            for (int i = 0; i < portlets.getLength(); ++i) {
                Node node = portlets.item(i);
                if (node.getAttributes().getNamedItem(ATTRIBUTE_ID).getNodeValue().equals(ADMIN_PORTRET_ID)) {
                    Node parent = node.getParentNode();
                    parent.removeChild(node);
                    continue;
                }
                node.getAttributes().removeNamedItem(ATTRIBUTE_ID);
            }
            NodeList entry = dom.getElementsByTagName(ELEMENT_ENTRY);
            for (int i = 0; i < entry.getLength(); ++i) {
                Node node = entry.item(i);
                node.getAttributes().removeNamedItem(ATTRIBUTE_ID);
            }
            NodeList params = dom.getElementsByTagName(ELEMENT_PARAMETER);
            for (int i = 0; i < params.getLength(); ++i) {
                Node node = params.item(i);
                Node parent = node.getParentNode();
                if (parent.getAttributes().getNamedItem("parent") == null || !parent.getAttributes().getNamedItem("parent").getNodeValue().equals("GadgetsTemplate") || !node.getAttributes().getNamedItem("name").getNodeValue().equals("mid")) continue;
                parent.removeChild(node);
                --i;
            }
            StringWriter sw = new StringWriter();
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer transformer = tfactory.newTransformer();
            transformer.transform(new DOMSource(dom), new StreamResult(sw));
            return sw.toString();
        }
        catch (RuntimeException ex) {
            logger.error((Object)"[PsmlUtils]", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"[PsmlUtils]", (Throwable)ex);
            throw ex;
        }
    }

    public static Document loadXMLFrom(String xml) throws SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            StringReader strReader = new StringReader(xml);
            Document doc = builder.parse(new InputSource(strReader));
            return doc;
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static File getTemplateHtmlDefaultPsmlFile(RunData runData) {
        String path = PsmlUtils.getTemplateHtmlDefaultPsmlPath(runData);
        File psml = new File(path);
        if (!psml.exists()) {
            return null;
        }
        return psml;
    }

    public static String getTemplateHtmlDefaultPsmlPath(RunData runData) {
        String root = JetspeedResources.getString((String)"services.PsmlManager.root");
        ServletConfig conf = runData.getServletConfig();
        String rootPath = conf.getServletContext().getRealPath(root);
        StringBuffer buffer = new StringBuffer();
        buffer.append(rootPath).append(File.separator);
        buffer.append("user").append(File.separator);
        buffer.append(TEMPLATE_NAME).append(File.separator);
        buffer.append("html").append(File.separator);
        buffer.append(DEFAULT_PAGE_NAME);
        return buffer.toString();
    }

    public static PSMLDocument loadDocument(File file, Mapping map) {
        BasePSMLDocument doc = null;
        if (file != null) {
            doc = new BasePSMLDocument();
            Portlets portlets = null;
            try {
                doc.setName(file.getCanonicalPath());
                DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = dbfactory.newDocumentBuilder();
                Document d = builder.parse(file);
                Unmarshaller unmarshaller = new Unmarshaller(map);
                portlets = (Portlets)unmarshaller.unmarshal((Node)d);
                doc.setPortlets(portlets);
            }
            catch (IOException e) {
                logger.error((Object)("PSMLManager: Could not load the file " + file.getAbsolutePath()), (Throwable)e);
                doc = null;
            }
            catch (MarshalException e) {
                logger.error((Object)("PSMLManager: Could not unmarshal the file " + file.getAbsolutePath()), (Throwable)e);
                doc = null;
            }
            catch (MappingException e) {
                logger.error((Object)("PSMLManager: Could not unmarshal the file " + file.getAbsolutePath()), (Throwable)e);
                doc = null;
            }
            catch (ValidationException e) {
                logger.error((Object)("PSMLManager: document " + file.getAbsolutePath() + " is not valid"), (Throwable)e);
                doc = null;
            }
            catch (ParserConfigurationException e) {
                logger.error((Object)("PSMLManager: Could not load the file " + file.getAbsolutePath()), (Throwable)e);
                doc = null;
            }
            catch (SAXException e) {
                logger.error((Object)("PSMLManager: Could not load the file " + file.getAbsolutePath()), (Throwable)e);
                doc = null;
            }
        }
        return doc;
    }

    public static Mapping getMapping(RunData runData) {
        ServletConfig conf = runData.getServletConfig();
        String mapFilePath = conf.getServletContext().getRealPath(JetspeedResources.getString((String)"services.PsmlManager.mapping"));
        File map = new File(mapFilePath);
        if (!map.exists()) {
            return null;
        }
        Mapping mapping = null;
        try {
            mapping = new Mapping();
            InputSource is = new InputSource(new FileReader(map));
            is.setSystemId(map.getCanonicalPath());
            mapping.loadMapping(is);
        }
        catch (RuntimeException e) {
            logger.error((Object)"PSMLManager: Error in psml mapping creation", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"PSMLManager: Error in psml mapping creation", (Throwable)e);
        }
        return mapping;
    }

    public static String PSMLEncode(String psml) {
        char[] a;
        StringBuffer buf = new StringBuffer();
        for (char cha : a = psml.toCharArray()) {
            String tmp = String.valueOf(cha);
            if (!tmp.matches("\\p{ASCII}*")) {
                buf.append(PsmlUtils.NCREncode(tmp, 16));
                continue;
            }
            buf.append(tmp);
        }
        return buf.toString();
    }

    public static String NCREncode(String str, int radix) {
        String NCRheader;
        String NCRfooter = ";";
        if (radix == 10) {
            NCRheader = "&#";
        } else if (radix == 16) {
            NCRheader = "&#x";
        } else {
            throw new IllegalArgumentException("Illegal radix.");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            sb.append(NCRheader);
            sb.append(Integer.toString(str.charAt(i), radix));
            sb.append(NCRfooter);
        }
        return sb.toString();
    }

    public static File getTemplateHtmlDefaultTimelinePsmlFile(RunData runData) {
        String path = PsmlUtils.getTemplateHtmlDefaultTimelinePsmlPath(runData);
        File psml = new File(path);
        if (!psml.exists()) {
            return null;
        }
        return psml;
    }

    public static String getTemplateHtmlDefaultTimelinePsmlPath(RunData runData) {
        String root = JetspeedResources.getString((String)"services.PsmlManager.root");
        ServletConfig conf = runData.getServletConfig();
        String rootPath = conf.getServletContext().getRealPath(root);
        StringBuffer buffer = new StringBuffer();
        buffer.append(rootPath).append(File.separator);
        buffer.append("user").append(File.separator);
        buffer.append(TEMPLATE_NAME).append(File.separator);
        buffer.append("html").append(File.separator);
        buffer.append(DEFAULT_TIMELINE_PAGE_NAME);
        return buffer.toString();
    }

    public static File getTemplateHtmlDefaultSchedulePsmlFile(RunData runData) {
        String path = PsmlUtils.getTemplateHtmlDefaultSchedulePsmlPath(runData);
        File psml = new File(path);
        if (!psml.exists()) {
            return null;
        }
        return psml;
    }

    public static String getTemplateHtmlDefaultSchedulePsmlPath(RunData runData) {
        String root = JetspeedResources.getString((String)"services.PsmlManager.root");
        ServletConfig conf = runData.getServletConfig();
        String rootPath = conf.getServletContext().getRealPath(root);
        StringBuffer buffer = new StringBuffer();
        buffer.append(rootPath).append(File.separator);
        buffer.append("user").append(File.separator);
        buffer.append(TEMPLATE_NAME).append(File.separator);
        buffer.append("html").append(File.separator);
        buffer.append(DEFAULT_SCHEDULE_PAGE_NAME);
        return buffer.toString();
    }
}

