/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.whatsnew;

import com.aimluck.eip.cayenne.om.portlet.EipTWhatsNew;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.WhatsNewContainer;
import com.aimluck.eip.whatsnew.WhatsNewResultData;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WhatsNewSelectData
extends ALAbstractSelectData<WhatsNewContainer, WhatsNewContainer>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WhatsNewSelectData.class.getName());
    private int uid;
    private int viewSpan;
    private int viewNum;
    public List<Integer> parentIds;

    public void initField() {
        this.viewSpan = 0;
        this.viewNum = 100;
        super.initField();
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.parentIds = new ArrayList<Integer>();
        SelectQuery query = Database.query(EipTWhatsNew.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"parentId", (Object)0);
        query.setQualifier(exp1.notExp());
        Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.uid);
        query.andQualifier(exp2);
        List readflags = query.fetchList();
        for (int i = 0; i < readflags.size(); ++i) {
            this.parentIds.add(((EipTWhatsNew)readflags.get(i)).getParentId());
        }
        super.init(action, rundata, context);
    }

    public ResultList<WhatsNewContainer> selectList(RunData rundata, Context context) {
        try {
            WhatsNewUtils.removeMonthOverWhatsNew();
            ArrayList<WhatsNewContainer> list = new ArrayList<WhatsNewContainer>();
            list.add(this.getContainerPublic(rundata, context, 1));
            list.add(this.getContainer(rundata, context, 2));
            list.add(this.getContainerBoth(rundata, context, 4));
            list.add(this.getContainer(rundata, context, 6));
            list.add(this.getContainer(rundata, context, 3));
            list.add(this.getContainer(rundata, context, 5));
            return new ResultList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"whatsnew", (Throwable)ex);
            return null;
        }
    }

    private WhatsNewContainer getContainer(RunData rundata, Context context, int type) {
        WhatsNewContainer con = new WhatsNewContainer();
        SelectQuery<EipTWhatsNew> query = Database.query(EipTWhatsNew.class);
        Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)this.uid);
        query.setQualifier(exp);
        Expression exp2 = ExpressionFactory.matchExp((String)"portletType", (Object)type);
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.matchExp((String)"parentId", (Object)Integer.valueOf("-1"));
        query.andQualifier(exp3);
        query = this.addSpanCriteria(query);
        query.orderDesending("updateDate");
        List temp = query.fetchList();
        con.setList(temp);
        con.setType(type);
        return con;
    }

    private WhatsNewContainer getContainerPublic(RunData rundata, Context context, int type) {
        int size;
        WhatsNewContainer con = new WhatsNewContainer();
        SelectQuery<EipTWhatsNew> query = Database.query(EipTWhatsNew.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"portletType", (Object)type);
        query.setQualifier(exp1);
        Expression exp3 = ExpressionFactory.matchExp((String)"parentId", (Object)0);
        query.andQualifier(exp3);
        query = this.addSpanCriteria(query);
        query = this.addNumberCriteria(query);
        query.orderDesending("updateDate");
        List result = query.fetchList();
        ArrayList<EipTWhatsNew> filterd_result = new ArrayList<EipTWhatsNew>();
        if (null != result && (size = result.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                int id = ((EipTWhatsNew)result.get(i)).getWhatsNewId();
                if (this.parentIds.indexOf(id) != -1) continue;
                filterd_result.add((EipTWhatsNew)result.get(i));
            }
        }
        con.setList(filterd_result);
        con.setType(type);
        return con;
    }

    private WhatsNewContainer getContainerBoth(RunData rundata, Context context, int type) {
        WhatsNewContainer con = new WhatsNewContainer();
        SelectQuery query = Database.query(EipTWhatsNew.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"portletType", (Object)type);
        query.setQualifier(exp1);
        if (this.parentIds != null && this.parentIds.size() > 0) {
            Expression exp2 = ExpressionFactory.inDbExp((String)"WHATSNEW_ID", this.parentIds);
            query.andQualifier(exp2.notExp());
        }
        Expression exp3 = ExpressionFactory.matchExp((String)"parentId", (Object)0);
        query.andQualifier(exp3);
        query.orderDesending("updateDate");
        List temp = query.fetchList();
        query = Database.query(EipTWhatsNew.class);
        Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)this.uid);
        query.setQualifier(exp);
        Expression exp4 = ExpressionFactory.matchExp((String)"portletType", (Object)type);
        query.andQualifier(exp4);
        Expression exp5 = ExpressionFactory.matchExp((String)"parentId", (Object)Integer.valueOf("-1"));
        query.andQualifier(exp5);
        query.orderDesending("updateDate");
        List performQuery = query.fetchList();
        temp.addAll(performQuery);
        con.setList(temp);
        con.setType(type);
        return con;
    }

    protected Object getResultData(WhatsNewContainer record) {
        WhatsNewResultData rd = WhatsNewUtils.setupWhatsNewResultData(record, this.uid, this.viewNum, this.viewSpan);
        return rd;
    }

    public WhatsNewContainer selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultDataDetail(WhatsNewContainer obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        return map;
    }

    public void setViewSpan(int i) {
        this.viewSpan = i;
    }

    public void setViewNum(int i) {
        this.viewNum = i;
    }

    private SelectQuery<EipTWhatsNew> addSpanCriteria(SelectQuery<EipTWhatsNew> query) {
        if (this.viewSpan > 0) {
            Calendar cal = Calendar.getInstance();
            if (this.viewSpan == 31) {
                cal.add(2, -1);
                cal.set(5, 1);
            } else {
                cal.add(5, -1 * this.viewSpan);
            }
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Expression exp = ExpressionFactory.greaterOrEqualExp((String)"updateDate", (Object)cal.getTime());
            query.andQualifier(exp);
        }
        return query;
    }

    private SelectQuery<EipTWhatsNew> addNumberCriteria(SelectQuery<EipTWhatsNew> query) {
        if (this.viewNum > 0) {
            query.limit(this.viewNum);
        }
        return query;
    }
}

