/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.report;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTReport;
import com.aimluck.eip.cayenne.om.portlet.EipTReportFile;
import com.aimluck.eip.cayenne.om.portlet.EipTReportMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.actions.report.ReportAction;
import com.aimluck.eip.modules.screens.ReportDetailScreen;
import com.aimluck.eip.modules.screens.ReportFormJSONScreen;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.report.util.ReportUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ReportReplyFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ReportReplyFormData.class.getName());
    private ALStringField report_name;
    private ALStringField note;
    private ALStringField attachment = null;
    private List<FileuploadLiteBean> fileuploadList = null;
    private String folderName = null;
    private int uid;
    private String orgId;
    private String aclPortletFeature = null;
    private boolean hasAclCategoryList;
    private boolean hasAclUpdateReportOthers;
    private boolean hasAclInsertReportReply;
    private boolean hasAclDeleteReportReply;
    private boolean hasAclDeleteReportOthers;
    private ALEipUser login_user;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.orgId = Database.getDomainName();
        this.folderName = rundata.getParameters().getString("folderName");
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAclDeleteReportOthers = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "report_other", 16);
        this.hasAclUpdateReportOthers = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "report_other", 8);
        this.hasAclInsertReportReply = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "report_reply", 4);
        this.hasAclDeleteReportReply = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "report_reply", 16);
    }

    public void initField() {
        this.report_name = new ALStringField();
        this.report_name.setFieldName(ALLocalizationUtils.getl10n((String)"REPORT_SETFIELDNAME_RETURN_REPORT_NAME"));
        this.report_name.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"REPORT_SETFIELDNAME_NOTE"));
        this.note.setTrim(false);
        this.attachment = new ALStringField();
        this.attachment.setFieldName(ALLocalizationUtils.getl10n((String)"REPORT_SETFIELDNAME_ATTACHMENT"));
        this.attachment.setTrim(true);
        this.fileuploadList = new ArrayList<FileuploadLiteBean>();
    }

    protected void setValidator() {
        this.note.setNotNull(true);
        this.note.limitMaxLength(10000);
    }

    protected boolean validate(List<String> reportList) {
        this.report_name.validate(reportList);
        this.note.validate(reportList);
        return reportList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> reportList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> reportList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int i;
            int fsize;
            String reportid = rundata.getParameters().getString("report_reply_id");
            EipTReport report = this.hasAclDeleteReportReply ? ReportUtils.getEipTReportReply(rundata, context, reportid, true) : ReportUtils.getEipTReportReply(rundata, context, reportid, false);
            if (report == null) {
                logger.debug((Object)"[ReportreportReplyFormData] Not found ID...");
                throw new ALPageNotFoundException();
            }
            ArrayList<String> fpaths = new ArrayList<String>();
            List files = report.getEipTReportFiles();
            if (files != null && files.size() > 0) {
                fsize = files.size();
                for (i = 0; i < fsize; ++i) {
                    fpaths.add(((EipTReportFile)files.get(i)).getFilePath());
                }
            }
            Database.delete((Persistent)report);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(report.getReportId().intValue(), 320, report.getReportName());
            if (fpaths.size() > 0) {
                fsize = fpaths.size();
                for (i = 0; i < fsize; ++i) {
                    ALStorageService.deleteFile((String)(ReportUtils.getSaveDirPath(this.orgId, this.uid) + (String)fpaths.get(i)));
                }
            }
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[ReportreportReplyFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> reportList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTReport parentreport = ReportUtils.getEipTReportParentReply(rundata, context, false);
            if (parentreport == null) {
                logger.debug((Object)"[ReportreportReplyFormData] Not found ID...");
                throw new ALPageNotFoundException();
            }
            Date updateDate = Calendar.getInstance().getTime();
            EipTReport report = (EipTReport)Database.create(EipTReport.class);
            report.setReportName(this.report_name.getValue());
            report.setUserId(Integer.valueOf((int)this.login_user.getUserId().getValue()));
            report.setNote(this.note.getValue());
            report.setCreateDate(updateDate);
            report.setUpdateDate(Calendar.getInstance().getTime());
            report.setTurbineUser(ALEipUtils.getTurbineUser((int)ALEipUtils.getUserId((RunData)rundata)));
            report.setParentId(parentreport.getReportId());
            this.insertAttachmentFiles(this.fileuploadList, this.folderName, this.uid, report, reportList);
            Database.commit();
            List<ALEipUser> recipientList = this.getRecipientList(rundata, context);
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(report.getReportId().intValue(), 320, report.getReportName());
            String loginName = this.login_user.getName().getValue();
            ArrayList<String> recipientNameList = new ArrayList<String>();
            for (ALEipUser recipient : recipientList) {
                recipientNameList.add(recipient.getName().getValue());
            }
            ReportUtils.createReportReplyActivity(parentreport, loginName, recipientNameList);
            try {
                List destMemberList = ALMailUtils.getALEipUserAddrs(recipientList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                String subject = "[" + ALOrgUtilsService.getAlias() + "]" + ALLocalizationUtils.getl10n((String)"REPORT_RETURN_REPORT_MSG");
                String orgId = Database.getDomainName();
                ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                for (ALEipUserAddr destMember : destMemberList) {
                    ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                    message.setPcSubject(subject);
                    message.setPcBody(ReportUtils.createReplyMsgForPc(rundata, report, parentreport));
                    message.setCellularSubject(subject);
                    message.setCellularBody(ReportUtils.createReplyMsgForCellPhone(rundata, report, parentreport, destMember.getUserId()));
                    messageList.add(message);
                }
                ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)26)));
            }
            catch (Exception ex) {
                logger.error((Object)"report", (Throwable)ex);
                return false;
            }
            ALStorageService.deleteTmpFolder((int)this.uid, (String)this.folderName);
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[ReportreportReplyFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    private List<ALEipUser> getRecipientList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        ArrayList<Integer> userIdList = new ArrayList<Integer>();
        Integer loginUserId = ALEipUtils.getUserId((RunData)rundata);
        EipTReport parenttopic = ReportUtils.getEipTReport(rundata, context);
        SelectQuery mapQuery = Database.query(EipTReportMap.class);
        Expression mapExp = ExpressionFactory.matchExp((String)"reportId", (Object)parenttopic.getReportId());
        mapQuery.setQualifier(mapExp);
        List mapList = mapQuery.fetchList();
        for (EipTReportMap map : mapList) {
            Integer userId = map.getUserId();
            if (userId.equals(loginUserId) || userIdList.contains(userId)) continue;
            userIdList.add(map.getUserId());
        }
        SelectQuery topicQuery = Database.query(EipTReport.class);
        Expression topicExp = ExpressionFactory.matchExp((String)"parentId", (Object)parenttopic.getReportId());
        topicQuery.setQualifier(topicExp);
        List topicList = topicQuery.fetchList();
        topicList.add(parenttopic);
        for (EipTReport topic : topicList) {
            Integer userId = topic.getUserId();
            if (userId.equals(loginUserId) || userIdList.contains(userId)) continue;
            userIdList.add(userId);
        }
        if (userIdList.isEmpty()) {
            return new ArrayList<ALEipUser>(0);
        }
        SelectQuery userQuery = Database.query(TurbineUser.class);
        Expression userExp = ExpressionFactory.inDbExp((String)"USER_ID", userIdList);
        userQuery.setQualifier(userExp);
        return ALEipUtils.getUsersFromSelectQuery((SelectQuery)userQuery);
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> reportList) {
        return false;
    }

    public boolean doInsert(ALAction action, RunData rundata, Context context) {
        try {
            if (!this.doCheckSecurity(rundata, context)) {
                return false;
            }
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 4);
            action.setMode("insert");
            ArrayList<String> reportList = new ArrayList<String>();
            this.setValidator();
            boolean res = false;
            if (this.isOverQuota()) {
                reportList.add(ALLocalizationUtils.getl10n((String)"COMMON_FULL_DISK_DELETE_DETA_OR_CHANGE_PLAN"));
            } else {
                boolean bl = res = this.setFormData(rundata, context, reportList) && this.validate(reportList) && this.insertFormData(rundata, context, reportList);
            }
            if (!res) {
                action.setMode("new_form");
                this.setMode(action.getMode());
            }
            if (action instanceof ReportFormJSONScreen) {
                action.setResultData((Object)this);
                action.addErrorMessages(reportList);
                action.putData(rundata, context);
            } else {
                ReportAction reportAction = (ReportAction)action;
                reportAction.setResultDataOnReportDetail((Object)this);
                reportAction.addErrorMessagesOnReportDetail(reportList);
                reportAction.putDataOnReportDetail(rundata, context);
            }
            return res;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public boolean doViewForm(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            action.setMode("reply");
            ArrayList<String> reportList = new ArrayList<String>();
            boolean res = this.setFormData(rundata, context, reportList);
            if (action instanceof ReportDetailScreen) {
                ReportDetailScreen reportAction = (ReportDetailScreen)action;
                reportAction.setResultDataOnReportDetail((Object)this);
                reportAction.addErrorMessagesOnReportDetail(reportList);
                reportAction.putDataOnReportDetail(rundata, context);
            } else {
                ReportAction reportAction = (ReportAction)action;
                reportAction.setResultDataOnReportDetail((Object)this);
                reportAction.addErrorMessagesOnReportDetail(reportList);
                reportAction.putDataOnReportDetail(rundata, context);
            }
            return res;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> reportList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, reportList);
        try {
            this.fileuploadList = FileuploadUtils.getFileuploadList((RunData)rundata);
        }
        catch (Exception ex) {
            logger.error((Object)"report", (Throwable)ex);
        }
        return res;
    }

    public void setAclPortletFeature(String featureName) {
        this.aclPortletFeature = featureName;
    }

    public ALStringField getReportName() {
        return this.report_name;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public List<FileuploadLiteBean> getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getAclPortletFeature() {
        if (this.aclPortletFeature == null || "".equals(this.aclPortletFeature)) {
            return "report_reply";
        }
        return this.aclPortletFeature;
    }

    private boolean insertAttachmentFiles(List<FileuploadLiteBean> fileuploadList, String folderName, int uid, EipTReport entry, List<String> msgList) {
        if (fileuploadList == null || fileuploadList.size() <= 0) {
            return true;
        }
        try {
            int length = fileuploadList.size();
            ArrayList<FileuploadLiteBean> newfilebeans = new ArrayList<FileuploadLiteBean>();
            FileuploadLiteBean filebean = null;
            for (int i = 0; i < length; ++i) {
                filebean = fileuploadList.get(i);
                if (!filebean.isNewFile()) continue;
                newfilebeans.add(filebean);
            }
            int newfilebeansSize = newfilebeans.size();
            if (newfilebeansSize > 0) {
                FileuploadLiteBean newfilebean = null;
                for (int j = 0; j < length; ++j) {
                    newfilebean = (FileuploadLiteBean)newfilebeans.get(j);
                    String[] acceptExts = ImageIO.getWriterFormatNames();
                    byte[] fileThumbnail = null;
                    FileuploadUtils.ShrinkImageSet bytesShrinkFilebean = FileuploadUtils.getBytesShrinkFilebean((String)this.orgId, (String)folderName, (int)uid, (FileuploadLiteBean)newfilebean, (String[])acceptExts, (int)86, (int)86, msgList, (boolean)false);
                    if (bytesShrinkFilebean != null) {
                        fileThumbnail = bytesShrinkFilebean.getShrinkImage();
                    }
                    String filename = j + "_" + String.valueOf(System.nanoTime());
                    EipTReportFile file = (EipTReportFile)Database.create(EipTReportFile.class);
                    file.setOwnerId(Integer.valueOf(uid));
                    file.setFileName(newfilebean.getFileName());
                    file.setFilePath(ReportUtils.getRelativePath(filename));
                    if (fileThumbnail != null) {
                        file.setFileThumbnail(fileThumbnail);
                    }
                    file.setEipTReport(entry);
                    file.setCreateDate(Calendar.getInstance().getTime());
                    file.setUpdateDate(Calendar.getInstance().getTime());
                    ALStorageService.copyTmpFile((int)uid, (String)folderName, (String)String.valueOf(newfilebean.getFileId()), (String)ReportUtils.FOLDER_FILEDIR_REPORT, (String)(ReportUtils.CATEGORY_KEY + ALStorageService.separator() + uid), (String)filename);
                }
                ALStorageService.deleteTmpFolder((int)uid, (String)folderName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[ReportReplyFormData]", (Throwable)e);
        }
        return true;
    }

    public boolean hasAclUpdatereportOthers() {
        return this.hasAclUpdateReportOthers;
    }

    public boolean hasAclDeleteReportOthers() {
        return this.hasAclDeleteReportOthers;
    }

    public boolean hasAclDeleteReportReply() {
        return this.hasAclDeleteReportReply;
    }

    public boolean hasAclInsertReportReply() {
        return this.hasAclInsertReportReply;
    }
}

