/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.report;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTReport;
import com.aimluck.eip.cayenne.om.portlet.EipTReportFile;
import com.aimluck.eip.cayenne.om.portlet.EipTReportMap;
import com.aimluck.eip.cayenne.om.portlet.EipTReportMemberMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractMultiFilterSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.report.ReportDetailResultData;
import com.aimluck.eip.report.ReportResultData;
import com.aimluck.eip.report.util.ReportUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ReportSelectData
extends ALAbstractMultiFilterSelectData<EipTReport, EipTReport>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ReportSelectData.class.getName());
    public static final String SUBMENU_CREATED = "created";
    public static final String SUBMENU_REQUESTED = "requested";
    public static final String SUBMENU_ALL = "all";
    private List<ALEipGroup> postList;
    private Object parentReport;
    private List<ReportResultData> coReportList;
    private String currentSubMenu;
    private boolean showReplyForm = false;
    private ALEipUser login_user;
    private boolean hasAuthorityOther;
    private ALStringField target_keyword;
    private int uid;
    private int view_uid;
    private String aclPortletFeature = null;
    private boolean isFileUploadable;
    private boolean isAdmin;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        String subMenuParam = rundata.getParameters().getString("submenu");
        this.currentSubMenu = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"submenu");
        if (subMenuParam == null && this.currentSubMenu == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"submenu", (String)SUBMENU_REQUESTED);
            this.currentSubMenu = SUBMENU_REQUESTED;
        } else if (subMenuParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"submenu", (String)subMenuParam);
            this.currentSubMenu = subMenuParam;
        }
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        String sorttype = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"create_date");
        }
        if ("create_date".equals(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR)) && (sorttype == null || "".equals(sorttype))) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
        }
        if (rundata.getParameters().getStringKey("clientid") != null) {
            this.view_uid = Integer.parseInt(rundata.getParameters().getStringKey("clientid").toString());
        }
        boolean isSelf = ReportUtils.isSelf(rundata, context);
        this.aclPortletFeature = !"detail".equals(action.getMode()) && !SUBMENU_ALL.equals(this.currentSubMenu) || isSelf || this.uid == this.view_uid ? "report_self" : "report_other";
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAuthorityOther = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "report_other", 1);
        this.postList = ALEipUtils.getMyGroups((RunData)rundata);
        this.showReplyForm = true;
        this.target_keyword = new ALStringField();
        super.init(action, rundata, context);
        this.isFileUploadable = ALEipUtils.isFileUploadable((RunData)rundata);
        this.isAdmin = ALEipUtils.isAdmin((int)ALEipUtils.getUserId((RunData)rundata));
    }

    public ResultList<EipTReport> selectList(RunData rundata, Context context) {
        try {
            if (ReportUtils.hasResetFlag(rundata, context)) {
                ReportUtils.resetFilter(rundata, context, ((Object)((Object)this)).getClass().getName());
                this.target_keyword.setValue("");
            } else {
                this.target_keyword.setValue(ReportUtils.getTargetKeyword(rundata, context));
            }
            SelectQuery<EipTReport> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForFilter(query, rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"report", (Throwable)ex);
            return null;
        }
    }

    protected void parseFilterMap(String key, String val) {
        super.parseFilterMap(key, val);
        HashSet unUse = new HashSet();
        for (Map.Entry pair : this.current_filterMap.entrySet()) {
            if (!((List)pair.getValue()).contains("0")) continue;
            unUse.add(pair.getKey());
        }
        for (String unusekey : unUse) {
            this.current_filterMap.remove(unusekey);
        }
    }

    protected SelectQuery<EipTReport> buildSelectQueryForFilter(SelectQuery<EipTReport> query, RunData rundata, Context context) {
        super.buildSelectQueryForFilter(query, rundata, context);
        if (this.current_filterMap.containsKey("post")) {
            List postIds = (List)this.current_filterMap.get("post");
            HashSet<Integer> userIds = new HashSet<Integer>();
            for (String post : postIds) {
                List userId = ALEipUtils.getUserIds((String)post);
                userIds.addAll(userId);
            }
            if (userIds.isEmpty()) {
                userIds.add(-1);
            }
            Expression exp = ExpressionFactory.inExp((String)"userId", userIds);
            query.andQualifier(exp);
        }
        return query;
    }

    private SelectQuery<EipTReport> getSelectQuery(RunData rundata, Context context) {
        Expression exp1;
        SelectQuery q;
        SelectQuery query = Database.query(EipTReport.class);
        Integer login_user_id = (int)this.login_user.getUserId().getValue();
        if (this.target_keyword != null && !this.target_keyword.getValue().equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR, (String)this.target_keyword.getValue());
        } else {
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR);
        }
        if (ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"Report_Maximize") == "false") {
            q = Database.query(EipTReportMap.class);
            exp1 = ExpressionFactory.matchExp((String)"userId", (Object)login_user_id);
            q.andQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"status", (Object)"U");
            q.andQualifier(exp2);
            List queryList = q.fetchList();
            ArrayList resultid = new ArrayList();
            for (Object item : queryList) {
                if (item.getReportId() != 0 && !resultid.contains(item.getReportId())) {
                    resultid.add(item.getReportId());
                    continue;
                }
                if (resultid.contains(item.getReportId())) continue;
                resultid.add(item.getReportId());
            }
            if (resultid.size() == 0) {
                resultid.add(-1);
            }
            Expression ex = ExpressionFactory.inDbExp((String)"REPORT_ID", (Collection)resultid);
            query.andQualifier(ex);
        } else if (SUBMENU_CREATED.equals(this.currentSubMenu)) {
            Expression exp12 = ExpressionFactory.matchExp((String)"userId", (Object)login_user_id);
            query.andQualifier(exp12);
        } else if (SUBMENU_REQUESTED.equals(this.currentSubMenu)) {
            q = Database.query(EipTReportMap.class);
            exp1 = ExpressionFactory.matchExp((String)"userId", (Object)login_user_id);
            q.andQualifier(exp1);
            List queryList = q.fetchList();
            ArrayList<Integer> resultid = new ArrayList<Integer>();
            for (EipTReportMap item : queryList) {
                if (item.getReportId() != 0 && !resultid.contains(item.getReportId())) {
                    resultid.add(item.getReportId());
                    continue;
                }
                if (resultid.contains(item.getReportId())) continue;
                resultid.add(item.getReportId());
            }
            if (resultid.size() == 0) {
                resultid.add(-1);
            }
            Expression exp3 = ExpressionFactory.inDbExp((String)"REPORT_ID", resultid);
            query.andQualifier(exp3);
        } else if (SUBMENU_ALL.equals(this.currentSubMenu)) {
            // empty if block
        }
        String search = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR);
        if (search != null && !search.equals("")) {
            this.current_search = search;
            Expression ex1 = ExpressionFactory.likeExp((String)"reportName", (Object)("%" + search + "%"));
            Expression ex2 = ExpressionFactory.likeExp((String)"note", (Object)("%" + search + "%"));
            SelectQuery q2 = Database.query(EipTReport.class);
            q2.andQualifier(ex1.orExp(ex2));
            List queryList = q2.fetchList();
            ArrayList<Integer> resultid = new ArrayList<Integer>();
            for (EipTReport item : queryList) {
                if (item.getParentId() != 0 && !resultid.contains(item.getParentId())) {
                    resultid.add(item.getParentId());
                    continue;
                }
                if (resultid.contains(item.getReportId())) continue;
                resultid.add(item.getReportId());
            }
            if (resultid.size() == 0) {
                resultid.add(-1);
            }
            Expression ex3 = ExpressionFactory.inDbExp((String)"REPORT_ID", resultid);
            query.andQualifier(ex3);
        }
        Expression ex = ExpressionFactory.noMatchExp((String)"reportName", (Object)"");
        query.andQualifier(ex);
        return query;
    }

    protected Object getResultData(EipTReport record) {
        try {
            ReportResultData rd = new ReportResultData();
            rd.initField();
            rd.setReportId(record.getReportId().intValue());
            rd.setReportName(record.getReportName());
            rd.setCreateDate(record.getCreateDate());
            rd.setStartDate(record.getStartDate());
            rd.setEndDate(record.getEndDate());
            ALEipUser client = ALEipUtils.getALEipUser((int)record.getUserId());
            rd.setClientName(client.getAliasName().getValue());
            rd.setClientId(client.getUserId().getValue());
            Integer login_user_id = (int)this.login_user.getUserId().getValue();
            rd.setIsSelfReport(record.getUserId().intValue() == login_user_id.intValue());
            ArrayList<Integer> users = new ArrayList<Integer>();
            EipTReportMap map = null;
            List<EipTReportMap> tmp_maps = ReportUtils.getEipTReportMap(record);
            HashMap<Integer, String> statusList = new HashMap<Integer, String>();
            if (record.getParentId() == 0) {
                int size = tmp_maps.size();
                for (int i = 0; i < size; ++i) {
                    map = tmp_maps.get(i);
                    users.add(map.getUserId());
                    statusList.put(map.getUserId(), map.getStatus());
                }
                rd.setStatusList(statusList);
            }
            Integer readNotes = 0;
            for (EipTReportMap reportmap : tmp_maps) {
                if (!reportmap.getStatus().equals("R")) continue;
                Integer n = readNotes;
                Integer n2 = readNotes = Integer.valueOf(readNotes + 1);
            }
            rd.setSentReport(tmp_maps.size());
            rd.setReadReport(readNotes.longValue());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"report", (Throwable)ex);
            return null;
        }
    }

    public EipTReport selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        EipTReport request = ReportUtils.getEipTReport(rundata, context);
        return request;
    }

    public boolean doViewDetail(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 2);
            action.setMode("detail");
            List<EipTReport> aList = this.selectDetailList(rundata, context);
            if (aList != null) {
                this.coReportList = new ArrayList<ReportResultData>();
                int size = aList.size();
                for (int i = 0; i < size; ++i) {
                    this.coReportList.add((ReportResultData)this.getResultDataDetail(aList.get(i)));
                }
            }
            action.setResultData((Object)this);
            action.putData(rundata, context);
            return true;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public List<EipTReport> selectDetailList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String reportid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        if (reportid == null || Integer.valueOf(reportid) == null) {
            logger.debug((Object)"[ReportTopic] Empty ID...");
            throw new ALPageNotFoundException();
        }
        String coreportsort = ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2b-sort");
        try {
            this.parentReport = this.getResultDataDetail(ReportUtils.getEipTReportParentReply(rundata, context, false));
            SelectQuery<EipTReport> query = this.getSelectQueryForCoreport(rundata, context, reportid, coreportsort);
            if ("response_new".equals(coreportsort)) {
                query.orderDesending("createDate");
            } else {
                query.orderAscending("createDate");
            }
            List resultList = query.fetchList();
            return resultList;
        }
        catch (ALPageNotFoundException pageNotFound) {
            throw pageNotFound;
        }
        catch (Exception ex) {
            logger.error((Object)"[ReportSelectData]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    private SelectQuery<EipTReport> getSelectQueryForCoreport(RunData rundata, Context context, String reportid, String coreportsort) {
        SelectQuery query = Database.query(EipTReport.class);
        Expression exp = ExpressionFactory.matchExp((String)"parentId", (Object)Integer.valueOf(reportid));
        query.setQualifier(exp);
        query.distinct(true);
        return query;
    }

    protected Object getResultDataDetail(EipTReport obj) throws ALPageNotFoundException, ALDBErrorException {
        try {
            List list;
            EipTReport record = obj;
            ReportDetailResultData rd = new ReportDetailResultData();
            rd.initField();
            rd.setUserId(record.getUserId().longValue());
            rd.setStartDate(record.getStartDate());
            rd.setEndDate(record.getEndDate());
            rd.setReportName(record.getReportName());
            rd.setReportId(record.getReportId().longValue());
            rd.setNote(record.getNote());
            ALEipUser client = ALEipUtils.getALEipUser((int)record.getUserId());
            rd.setClientName(client.getAliasName().getValue());
            rd.setClientId(client.getUserId().getValue());
            Integer login_user_id = (int)this.login_user.getUserId().getValue();
            rd.setIsSelfReport(record.getUserId().intValue() == login_user_id.intValue());
            ArrayList<Integer> users = new ArrayList<Integer>();
            EipTReportMap map = null;
            List<EipTReportMap> tmp_maps = ReportUtils.getEipTReportMap(record);
            HashMap<Integer, String> statusList = new HashMap<Integer, String>();
            if (record.getParentId() == 0) {
                int size = tmp_maps.size();
                for (int i = 0; i < size; ++i) {
                    map = tmp_maps.get(i);
                    users.add(map.getUserId());
                    if (map.getUserId().intValue() == login_user_id.intValue()) {
                        map.setStatus("R");
                        Database.commit();
                    }
                    statusList.put(map.getUserId(), map.getStatus());
                }
                rd.setStatusList(statusList);
                SelectQuery query = Database.query(TurbineUser.class);
                Expression exp = ExpressionFactory.inDbExp((String)"USER_ID", users);
                query.setQualifier(exp);
                rd.setMapList(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
                ArrayList<Integer> users1 = new ArrayList<Integer>();
                EipTReportMemberMap map1 = null;
                List<EipTReportMemberMap> tmp_maps1 = ReportUtils.getEipTReportMemberMap(record);
                int size1 = tmp_maps1.size();
                for (int i = 0; i < size1; ++i) {
                    map1 = tmp_maps1.get(i);
                    users1.add(map1.getUserId());
                }
                SelectQuery query1 = Database.query(TurbineUser.class);
                Expression exp1 = ExpressionFactory.inDbExp((String)"USER_ID", users1);
                query1.setQualifier(exp1);
                rd.setMemberList(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query1));
            }
            if ((list = ReportUtils.getSelectQueryForFiles(record.getReportId()).fetchList()) != null && list.size() > 0) {
                ArrayList<FileuploadBean> attachmentFileList = new ArrayList<FileuploadBean>();
                FileuploadBean filebean = null;
                for (EipTReportFile file : list) {
                    String realname = file.getFileName();
                    DataHandler hData = new DataHandler((DataSource)new FileDataSource(realname));
                    filebean = new FileuploadBean();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(realname);
                    if (hData != null) {
                        filebean.setContentType(hData.getContentType());
                    }
                    filebean.setIsImage(FileuploadUtils.isImage((String)realname));
                    attachmentFileList.add(filebean);
                }
                rd.setAttachmentFiles(attachmentFileList);
            }
            rd.setCreateDate(record.getCreateDate());
            rd.setUpdateDate(record.getUpdateDate());
            return rd;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"report", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("report_name", "reportName");
        map.putValue("create_date", "createDate");
        map.putValue("user_id", "userId");
        map.putValue("parent_id", "parentId");
        map.putValue("start_date", "startDate");
        return map;
    }

    public String getCurrentSubMenu() {
        return this.currentSubMenu;
    }

    public ALEipUser getLoginUser() {
        return this.login_user;
    }

    public boolean showReplyForm() {
        return this.showReplyForm;
    }

    public List<ReportResultData> getCoReportList() {
        return this.coReportList;
    }

    public Object getParentReport() {
        return this.parentReport;
    }

    public List<ALEipGroup> getPostList() {
        return this.postList;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public boolean hasAuthorityOther() {
        return this.hasAuthorityOther;
    }

    public ALStringField getTargetKeyword() {
        return this.target_keyword;
    }

    public boolean isFileUploadable() {
        return this.isFileUploadable;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }
}

