/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.eventlog;

import com.aimluck.eip.cayenne.om.portlet.EipTEventlog;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class EventlogMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)EventlogMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            SelectQuery query = Database.query(EipTEventlog.class);
            Expression exp = ExpressionFactory.inDbExp((String)"EVENTLOG_ID", values);
            query.setQualifier(exp);
            List logs = query.fetchList();
            if (logs == null || logs.size() == 0) {
                return false;
            }
            Database.deleteAll((List)logs);
            Database.commit();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"eventlog", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean doAllDelete(ALAction action, RunData rundata, Context context) {
        try {
            if (!this.doCheckSecurity(rundata, context)) {
                return false;
            }
            this.doCheckAclPermission(rundata, context, this.getDefineAclType());
            ArrayList<String> msgList = new ArrayList<String>();
            boolean res = false;
            res = this.allDeleteAction(rundata, context, msgList);
            action.setResultData((Object)this);
            action.setErrorMessages(msgList);
            action.putData(rundata, context);
            return res;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
    }

    protected boolean allDeleteAction(RunData rundata, Context context, List<String> msgList) {
        try {
            String sql = "DELETE FROM eip_t_eventlog WHERE EVENTLOG_ID > 0";
            Database.sql(EipTEventlog.class, (String)sql).execute();
            Database.commit();
        }
        catch (RuntimeException ex) {
            Database.rollback();
            logger.error((Object)"eventlog", (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"eventlog", (Throwable)ex);
            return false;
        }
        return true;
    }
}

