/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.memo;

import com.aimluck.eip.cayenne.om.portlet.EipTMemo;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.memo.util.MemoUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MemoMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MemoMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                ids.add(Integer.valueOf(values.get(i)));
            }
            SelectQuery query = Database.query(EipTMemo.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.inDbExp((String)"MEMO_ID", ids);
            query.andQualifier(exp2);
            List memos = query.fetchList();
            if (memos == null || memos.size() == 0) {
                return false;
            }
            int lsize = memos.size();
            String saved_memoid = ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1a-memos").trim();
            for (int i = 0; i < lsize; ++i) {
                EipTMemo memo = (EipTMemo)memos.get(i);
                if (saved_memoid != null && memo.getMemoId().toString().matches(saved_memoid)) {
                    MemoUtils.saveMemoSelection(rundata, "");
                }
                Database.delete((Persistent)memo);
                Database.commit();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(memo.getMemoId().intValue(), 170, memo.getMemoName());
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"memo", (Throwable)ex);
            return false;
        }
        return true;
    }
}

