/*
 * Decompiled with CFR 0.152.
 */
package com.develop.delegator;

import com.develop.delegator.InternalError;
import com.develop.java.lang.reflect.InvocationHandler;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Interceptor
implements InvocationHandler {
    private final Object realObject;
    private final Class realClass;
    static int callId;
    public static PrintStream output;

    public Interceptor(Object realObject) {
        this.realObject = realObject;
        this.realClass = realObject.getClass();
    }

    public Object invoke(Object proxy, Method meth, Object[] args) throws Throwable {
        try {
            Object[] replacementArgs = this.preProcess(++callId, proxy, meth, args);
            Object realObjectReturn = meth.invoke(this.realObject, replacementArgs);
            return this.postProcess(callId, realObjectReturn);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        catch (Throwable t) {
            throw new InternalError(t);
        }
    }

    private Object[] preProcess(int currentCall, Object proxy, Method meth, Object[] args) {
        output.println("Preprocessing " + currentCall + " " + meth.getName());
        return args;
    }

    private Object postProcess(int currentCall, Object realObjectReturn) {
        output.println("Postprocessing " + currentCall);
        return realObjectReturn;
    }

    static {
        output = System.out;
    }
}

