/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ojb.broker.Identity;
import ojb.broker.cache.ObjectCache;
import ojb.broker.cache.ObjectCacheDefaultImpl;

public class MetaObjectCacheImpl
implements ObjectCache {
    private Map cachesByClass = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;

    public MetaObjectCacheImpl() {
        this.setClassCache(class$java$lang$Object == null ? (class$java$lang$Object = MetaObjectCacheImpl.class$("java.lang.Object")) : class$java$lang$Object, (ObjectCache)new ObjectCacheDefaultImpl());
    }

    public void setClassCache(Class objectClass, ObjectCache cache) {
        this.setClassCache(objectClass.getName(), cache);
    }

    public void cache(Object obj) {
        if (obj != null) {
            Identity oid = new Identity(obj);
            this.cache(oid, obj);
        }
    }

    public void cache(Identity oid, Object obj) {
        ObjectCache cache;
        if (oid != null && obj != null && (cache = this.getCache(oid.getObjectsClass())) != null) {
            cache.cache(oid, obj);
        }
    }

    public Object lookup(Identity oid) {
        ObjectCache cache;
        Object ret = null;
        if (oid != null && (cache = this.getCache(oid.getObjectsClass())) != null) {
            ret = cache.lookup(oid);
        }
        return ret;
    }

    protected void removeByOID(Identity oid) {
        ObjectCache cache;
        if (oid != null && (cache = this.getCache(oid.getObjectsClass())) != null) {
            cache.remove(oid);
        }
    }

    public void remove(Object obj) {
        if (obj != null) {
            if (obj instanceof Identity) {
                this.removeByOID((Identity)obj);
                return;
            }
            ObjectCache cache = this.getCache(obj.getClass());
            if (cache != null) {
                cache.remove(obj);
            }
        }
    }

    public void clear() {
        Iterator it = this.cachesByClass.values().iterator();
        while (it.hasNext()) {
            ((ObjectCache)it.next()).clear();
        }
        this.cachesByClass.clear();
    }

    private void setClassCache(String className, ObjectCache cache) {
        this.cachesByClass.put(className, cache);
    }

    private ObjectCache getCache(Class objectClass) {
        ObjectCache cache = (ObjectCache)this.cachesByClass.get(objectClass.getName());
        if (cache == null && !this.cachesByClass.containsKey(objectClass.getName()) && !objectClass.equals(class$java$lang$Object == null ? (class$java$lang$Object = MetaObjectCacheImpl.class$("java.lang.Object")) : class$java$lang$Object)) {
            cache = this.getCache(objectClass.getSuperclass());
        }
        return cache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

