/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import ojb.broker.util.LoggerFactory;

class SampleThread
implements Runnable {
    Connection con;
    BufferedReader in;
    Statement stmt;
    PreparedStatement pstmt;
    ResultSet rs;
    DatabaseMetaData dma;
    Vector childThreads;
    String url;
    String sqlName;
    char command;
    String sql;
    StringBuffer curStatement;
    boolean norsClose;
    boolean batchMode;
    boolean rsmd;

    public SampleThread(String fileName) {
        try {
            FileReader fr = new FileReader(fileName);
            this.in = new BufferedReader(fr);
            this.childThreads = new Vector(10, 10);
            this.sqlName = fileName;
        }
        catch (Exception e) {
            LoggerFactory.getBootLogger().error(e);
        }
    }

    void waitForChildren() throws InterruptedException {
        int i = 0;
        while (i < this.childThreads.size()) {
            Thread curThread = (Thread)this.childThreads.elementAt(i);
            curThread.join();
            ++i;
        }
    }

    void closers() throws SQLException {
        if (this.norsClose) {
            return;
        }
        if (this.rs == null) {
            return;
        }
        if (this.rsmd) {
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int numCols = rsmd.getColumnCount();
            StringBuffer lineOut = new StringBuffer(64);
            LoggerFactory.getBootLogger().info("Result Set Meta Data");
            int i = 1;
            while (i <= numCols) {
                String colName = rsmd.getColumnName(i);
                String tabName = rsmd.getTableName(i);
                lineOut.setLength(0);
                lineOut.append("Table='" + tabName + "' ");
                lineOut.append(colName + ": ");
                if (rsmd.isAutoIncrement(i)) {
                    lineOut.append("[AUTO INC] ");
                }
                if (rsmd.isCaseSensitive(i)) {
                    lineOut.append("[CASE SENSITIVE] ");
                }
                if (rsmd.isCurrency(i)) {
                    lineOut.append("[CURRENCY] ");
                }
                if (rsmd.isNullable(i) == 1) {
                    lineOut.append("[NULLABLE] ");
                }
                if (rsmd.isReadOnly(i)) {
                    lineOut.append("[READONLY] ");
                }
                LoggerFactory.getBootLogger().info(lineOut.toString());
                ++i;
            }
        }
        try {
            this.rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void getSQL(String loopStatement) throws IOException {
        if (loopStatement == null) {
            this.curStatement.setLength(0);
            boolean endFound = false;
            while (!endFound) {
                if (!this.in.ready()) break;
                String curLine = this.in.readLine();
                if (curLine == null || curLine.length() == 0) continue;
                if ((curLine = curLine.trim()).startsWith("/*")) {
                    while (!curLine.startsWith("*/")) {
                        curLine = this.in.readLine();
                    }
                    continue;
                }
                if (curLine.charAt(0) == ';' || curLine.charAt(0) == '!' || curLine.charAt(0) == '-' || curLine.charAt(0) == '/' || curLine.charAt(0) == '#') continue;
                if (this.curStatement.length() > 0) {
                    this.curStatement.append(' ');
                }
                this.curStatement.append(curLine);
                if (this.curStatement.charAt(this.curStatement.length() - 1) != ';') continue;
                endFound = true;
                this.curStatement.setLength(this.curStatement.length() - 1);
            }
            this.sql = this.curStatement.toString();
        } else {
            this.sql = loopStatement;
        }
        this.sql = this.sql.trim();
        if (this.sql.length() > 0) {
            this.command = this.sql.charAt(0);
            if (this.sql.length() > 1 && this.sql.charAt(1) != ' ') {
                this.command = (char)101;
                this.sql = "  " + this.sql;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        thisThread = Thread.currentThread();
        thisThread.setName(this.sqlName);
        startTime = 0L;
        diffTime = 0L;
        gettingRepeatEntries = false;
        repeatCount = 0;
        repeatSQL = new String[100];
        nextRepeatSQL = 0;
        this.curStatement = new StringBuffer(512);
        try {
            while (this.in.ready()) {
                if (repeatCount > 0) {
                    if (gettingRepeatEntries) {
                        this.getSQL(null);
                        repeatSQL[nextRepeatSQL++] = this.sql;
                        if (this.command != '}') continue;
                        gettingRepeatEntries = false;
                        nextRepeatSQL = 0;
                        continue;
                    }
                    this.getSQL(repeatSQL[nextRepeatSQL++]);
                    if (this.command == '}') {
                        nextRepeatSQL = 0;
                        --repeatCount;
                        continue;
                    }
                } else {
                    this.getSQL(null);
                    if (this.sql.length() == 0) break;
                }
                try {
                    this.sql = this.sql.substring(2);
                    this.sql = this.sql.trim();
                }
                catch (Exception e) {
                    this.sql = "";
                }
                try {
                    tokens = new StringTokenizer(this.sql);
                    token = null;
                    startTime = System.currentTimeMillis();
                    block6 : switch (this.command) {
                        case 'c': {
                            if (this.sql.equalsIgnoreCase("autocommit on")) {
                                this.con.setAutoCommit(true);
                                LoggerFactory.getBootLogger().info("Auto-commit is " + this.con.getAutoCommit());
                                break;
                            }
                            if (this.sql.equalsIgnoreCase("autocommit off")) {
                                this.con.setAutoCommit(false);
                                LoggerFactory.getBootLogger().info("Auto-commit is " + this.con.getAutoCommit());
                                break;
                            }
                            if (this.sql.equalsIgnoreCase("break")) {
                                LoggerFactory.getBootLogger().info("Breakpoint reached");
                                break;
                            }
                            if (this.sql.equalsIgnoreCase("batch mode")) {
                                this.batchMode = true;
                                break;
                            }
                            if (this.sql.equalsIgnoreCase("execute batch")) {
                                if (this.stmt != null) {
                                    this.stmt.executeBatch();
                                }
                                if (this.pstmt != null) {
                                    this.pstmt.executeBatch();
                                }
                                this.batchMode = false;
                                break;
                            }
                            if (this.sql.equalsIgnoreCase("time")) {
                                LoggerFactory.getBootLogger().info("Last command took: " + diffTime);
                                break;
                            }
                            if (this.sql.equalsIgnoreCase("close")) {
                                if (this.stmt != null) {
                                    this.stmt.close();
                                }
                                this.stmt = null;
                                this.con.close();
                                this.con = null;
                                break;
                            }
                            if (this.sql.equalsIgnoreCase("rollback")) {
                                this.con.rollback();
                                break;
                            }
                            if (this.sql.equalsIgnoreCase("commit")) {
                                this.con.commit();
                                break;
                            }
                            if (this.sql.equalsIgnoreCase("show meta-data")) {
                                this.rs = this.dma.getTypeInfo();
                                SampleThread.dispResultSet(this.rs);
                                this.rs.close();
                                this.rs = this.dma.getTables("", "", "%", null);
                                SampleThread.dispResultSet(this.rs);
                                this.rs.close();
                                break;
                            }
                            if (this.sql.equalsIgnoreCase("wait for children")) {
                                this.waitForChildren();
                                break;
                            }
                            if (this.sql.equalsIgnoreCase("exit")) {
                                System.exit(0);
                                break;
                            }
                            command = tokens.nextToken();
                            if (command.equalsIgnoreCase("set")) {
                                setWhat = tokens.nextToken();
                                if (setWhat.equalsIgnoreCase("timeout")) {
                                    timeout = Integer.parseInt(tokens.nextToken());
                                    this.stmt.setQueryTimeout(timeout);
                                    break;
                                }
                                if (setWhat.equalsIgnoreCase("maxRows")) {
                                    max = Integer.parseInt(tokens.nextToken());
                                    this.stmt.setMaxRows(max);
                                    break;
                                }
                                if (setWhat.equalsIgnoreCase("isolation")) {
                                    isolationLevel = tokens.nextToken();
                                    if (isolationLevel.equalsIgnoreCase("READ_UNCOMMITTED")) {
                                        this.con.setTransactionIsolation(1);
                                        break;
                                    }
                                    if (isolationLevel.equalsIgnoreCase("SERIALIZABLE")) {
                                        this.con.setTransactionIsolation(8);
                                        break;
                                    }
                                    if (isolationLevel.equalsIgnoreCase("READ_COMMITTED")) {
                                        this.con.setTransactionIsolation(2);
                                        break;
                                    }
                                    if (isolationLevel.equalsIgnoreCase("REPEATABLE_READ")) {
                                        this.con.setTransactionIsolation(4);
                                        break;
                                    }
                                    LoggerFactory.getBootLogger().info("Unknown set isolation level: " + isolationLevel);
                                    break;
                                }
                                LoggerFactory.getBootLogger().info("Unknown set command: " + setWhat);
                                break;
                            }
                            if (command.equalsIgnoreCase("get")) {
                                getWhat = tokens.nextToken();
                                if (getWhat.equalsIgnoreCase("columns")) {
                                    tablePattern = tokens.nextToken();
                                    colPattern = tokens.nextToken();
                                    this.rs = this.dma.getColumns("", "", tablePattern, colPattern);
                                    SampleThread.dispResultSet(this.rs);
                                    this.rs.close();
                                    break;
                                }
                                if (getWhat.equalsIgnoreCase("imported_keys")) {
                                    table = tokens.nextToken();
                                    this.rs = this.dma.getImportedKeys(null, null, table);
                                    SampleThread.dispResultSet(this.rs);
                                    this.rs.close();
                                    break;
                                }
                                if (getWhat.equalsIgnoreCase("exported_keys")) {
                                    table = tokens.nextToken();
                                    this.rs = this.dma.getExportedKeys(null, null, table);
                                    SampleThread.dispResultSet(this.rs);
                                    this.rs.close();
                                    break;
                                }
                                if (getWhat.equalsIgnoreCase("crossReference")) {
                                    ptable = tokens.nextToken();
                                    ftable = tokens.nextToken();
                                    this.rs = this.dma.getCrossReference(null, null, ptable, null, null, ftable);
                                    SampleThread.dispResultSet(this.rs);
                                    this.rs.close();
                                    break;
                                }
                                LoggerFactory.getBootLogger().info("Unknown get command: " + getWhat);
                                break;
                            }
                            if (command.equalsIgnoreCase("sleep")) {
                                interval = Integer.parseInt(tokens.nextToken());
                                Thread.sleep(interval);
                                break;
                            }
                            LoggerFactory.getBootLogger().info("Unknown command: " + command);
                            break;
                        }
                        case 'd': {
                            Class.forName(this.sql, true, Thread.currentThread().getContextClassLoader()).newInstance();
                            break;
                        }
                        case 'e': {
                            if (this.batchMode) {
                                this.stmt.addBatch(this.sql);
                                break;
                            }
                            this.stmt.executeUpdate(this.sql);
                            this.rs = this.stmt.getResultSet();
                            this.closers();
                            break;
                        }
                        case 'i': {
                            this.rs = this.dma.getIndexInfo(null, null, this.sql, false, false);
                            SampleThread.dispResultSet(this.rs);
                            this.rs = this.dma.getPrimaryKeys(null, null, this.sql);
                            SampleThread.dispResultSet(this.rs);
                            this.rs.close();
                            break;
                        }
                        case 'o': {
                            url = tokens.nextToken();
                            props = new Properties();
                            username = null;
                            password = null;
                            if (tokens.hasMoreTokens()) {
                                username = tokens.nextToken();
                            }
                            if (tokens.hasMoreTokens()) {
                                password = tokens.nextToken();
                            }
                            this.con = username != null ? DriverManager.getConnection(url, username, password) : DriverManager.getConnection(url);
                            this.dma = this.con.getMetaData();
                            LoggerFactory.getBootLogger().info("DB url:  " + this.dma.getURL());
                            LoggerFactory.getBootLogger().info("Driver:  " + this.dma.getDriverName());
                            LoggerFactory.getBootLogger().info("Version: " + this.dma.getDriverVersion());
                            this.stmt = this.con.createStatement();
                            try {
                                this.stmt.setQueryTimeout(300);
                            }
                            catch (Throwable t) {
                                LoggerFactory.getBootLogger().warn("setQueryTimeout() not supported by driver");
                            }
                            this.pstmt = null;
                            break;
                        }
                        case 'p': {
                            this.pstmt = this.con.prepareStatement(this.sql);
                            this.rs = this.pstmt.getResultSet();
                            this.closers();
                            break;
                        }
                        case 'q': {
                            this.rs = this.stmt.executeQuery(this.sql);
                            SampleThread.dispResultSet(this.rs);
                            this.closers();
                            break;
                        }
                        case 'r': {
                            count = tokens.nextToken();
                            repeatCount = Integer.parseInt(count);
                            gettingRepeatEntries = true;
                            break;
                        }
                        case 's': {
                            st = new StringTokenizer(this.sql, ",;%", true);
                            i = 1;
                            block28: while (true) {
                                if (!st.hasMoreTokens()) {
                                    if (!this.batchMode) break;
                                    this.pstmt.addBatch();
                                    break block6;
                                }
                                token = st.nextToken();
                                if (token.equals(" ") || token.equals(";") || token.equals(",")) continue;
                                if (token.equals("%")) {
                                    typeSpecifier = st.nextToken();
                                    percent = st.nextToken();
                                    token = st.nextToken();
                                    if (typeSpecifier.equalsIgnoreCase("binaryStream")) {
                                        file = new File(token);
                                        fileLength = (int)file.length();
                                        fin = new FileInputStream(file);
                                        this.pstmt.setBinaryStream(i++, (InputStream)fin, fileLength);
                                        continue;
                                    }
                                    if (typeSpecifier.equalsIgnoreCase("asciiStream")) {
                                        file = new File(token);
                                        fileLength = (int)file.length();
                                        fin = new FileInputStream(file);
                                        this.pstmt.setAsciiStream(i++, (InputStream)fin, fileLength);
                                        continue;
                                    }
                                    if (typeSpecifier.equalsIgnoreCase("timestamp")) {
                                        t = Timestamp.valueOf(token);
                                        this.pstmt.setTimestamp(i++, t);
                                        continue;
                                    }
                                    if (typeSpecifier.equalsIgnoreCase("boolean")) {
                                        b = new Boolean(token);
                                        this.pstmt.setBoolean(i++, b);
                                        continue;
                                    }
                                    if (typeSpecifier.equalsIgnoreCase("int array")) {
                                        intTokens = new StringTokenizer(token, " ", false);
                                        ints = new int[intTokens.countTokens()];
                                        j = 0;
                                        while (true) {
                                            if (!intTokens.hasMoreTokens()) {
                                                this.pstmt.setObject(i++, ints);
                                                continue block28;
                                            }
                                            ints[j++] = Integer.parseInt(intTokens.nextToken());
                                        }
                                    }
                                    LoggerFactory.getBootLogger().info("Unknown type specifier: " + typeSpecifier);
                                    continue;
                                }
                                token = token.trim();
                                this.pstmt.setString(i++, token);
                            }
                            this.pstmt.executeUpdate();
                            break;
                        }
                        case 't': {
                            newThread = new Thread(new SampleThread(this.sql));
                            newThread.start();
                            this.childThreads.addElement(newThread);
                            break;
                        }
                        case 'u': {
                            colname = tokens.nextToken();
                            value = tokens.nextToken();
                            this.rs.updateString(colname, value);
                            break;
                        }
                        default: {
                            throw new Exception("Unknown command: " + this.command);
                        }
                    }
                    diffTime = System.currentTimeMillis() - startTime;
                }
                catch (Exception e) {
                    LoggerFactory.getBootLogger().error(e);
                }
            }
            this.waitForChildren();
        }
        catch (Exception e) {
            LoggerFactory.getBootLogger().error(e);
            var25_41 = null;
            try {
                this.in.close();
                return;
            }
            catch (Exception e) {
                LoggerFactory.getBootLogger().error(e);
                return;
            }
        }
        var25_40 = null;
        ** GOTO lbl-1000
        {
            catch (Throwable var24_46) {
                var25_42 = null;
                ** try [egrp 5[TRYBLOCK] [5 : 2499->2509)] { 
lbl303:
                // 1 sources

                this.in.close();
                throw var24_46;
lbl305:
                // 1 sources

                catch (Exception e) {
                    LoggerFactory.getBootLogger().error(e);
                }
                throw var24_46;
            }
lbl-1000:
            // 1 sources

            try {}
            catch (Exception e) {}
            LoggerFactory.getBootLogger().error(e);
            return;
            this.in.close();
            return;
        }
    }

    static void dispResultSet(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int numCols = rsmd.getColumnCount();
        int i = 1;
        while (i <= numCols) {
            String pre = "";
            if (i > 1) {
                pre = ",";
            }
            LoggerFactory.getBootLogger().info(pre + rsmd.getColumnLabel(i));
            ++i;
        }
        LoggerFactory.getBootLogger().info("");
        while (rs.next()) {
            LoggerFactory.getBootLogger().info(SampleThread.dispRow(rs));
        }
    }

    static String dispRow(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int numCols = rsmd.getColumnCount();
        StringBuffer sb = new StringBuffer(128);
        int i = 1;
        while (i <= numCols) {
            Object o;
            if (i > 1) {
                sb.append(',');
            }
            if (!((o = rs.getObject(i)) instanceof int[])) {
                sb.append(rs.getString(i));
            }
            ++i;
        }
        return sb.toString();
    }
}

