/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.util;

import java.util.Hashtable;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.query.QueryByExample;
import ojb.broker.singlevm.PersistenceBrokerImpl;
import ojb.broker.util.HighLowSequence;
import ojb.broker.util.SequenceManagerDefaultImpl;

public class SequenceManagerHighLowImpl
extends SequenceManagerDefaultImpl {
    private Hashtable sequences = new Hashtable();
    private int defaultGrabSize = 10;

    public SequenceManagerHighLowImpl(PersistenceBrokerImpl broker) {
        super(broker);
        int grabsize = PersistenceBrokerFactory.getConfiguration().getSequenceManagerGrabSize();
        this.setIncrement(grabsize);
    }

    public void setIncrement(int defaultGrabSize) {
        this.defaultGrabSize = defaultGrabSize;
    }

    public synchronized int getUniqueId(Class clazz, String fieldName) throws PersistenceBrokerException {
        HighLowSequence tmp;
        int id = 0;
        String clName = clazz.getName();
        HighLowSequence seq = (HighLowSequence)this.sequences.get(clName);
        if (seq == null) {
            tmp = new HighLowSequence();
            tmp.setClassName(clazz.getName());
            tmp.setFieldName(fieldName);
            seq = (HighLowSequence)this.broker.getObjectByQuery(new QueryByExample(tmp));
            if (seq == null) {
                int lastId = this.getMaxForExtent(clazz, fieldName);
                seq = new HighLowSequence(clazz.getName(), fieldName, lastId, this.defaultGrabSize);
            }
            seq.grabNextKeySet();
            this.broker.store(seq);
            this.sequences.put(clName, seq);
        }
        if ((id = seq.getNextId()) == 0) {
            tmp = new HighLowSequence();
            tmp.setClassName(clazz.getName());
            tmp.setFieldName(fieldName);
            seq = (HighLowSequence)this.broker.getObjectByQuery(new QueryByExample(tmp));
            seq.grabNextKeySet();
            this.broker.store(seq);
            id = seq.getNextId();
        }
        if (id == 0) {
            throw new RuntimeException("Unable to build new ID");
        }
        return id;
    }

    public String getUniqueString(Class clazz, String fieldName) {
        return String.valueOf(this.getUniqueId(clazz, fieldName));
    }
}

