/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg.states;

import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.odmg.ObjectEnvelope;
import ojb.odmg.states.ModificationState;
import ojb.odmg.states.StateNewDelete;
import ojb.odmg.states.StateOldClean;

public class StateOldDelete
extends ModificationState {
    private static StateOldDelete _instance = new StateOldDelete();

    public ModificationState markClean() {
        return StateOldClean.getInstance();
    }

    public ModificationState markDelete() {
        return this;
    }

    public ModificationState markDirty() {
        return this;
    }

    public ModificationState markNew() {
        return StateNewDelete.getInstance();
    }

    public ModificationState markOld() {
        return this;
    }

    private StateOldDelete() {
    }

    public static StateOldDelete getInstance() {
        return _instance;
    }

    public void checkpoint(ObjectEnvelope mod, PersistenceBroker broker) throws PersistenceBrokerException {
        broker.delete(mod.getObject());
    }

    public void commit(ObjectEnvelope mod, PersistenceBroker broker) throws PersistenceBrokerException {
        broker.delete(mod.getObject());
        this.removeFromCache(mod.getObject(), broker);
    }

    public void rollback(ObjectEnvelope mod, PersistenceBroker broker) {
        this.removeFromCache(mod.getObject(), broker);
    }
}

