/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail;

import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.mail.util.ALStaticObject;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.util.ALCommonUtils;
import java.util.Calendar;
import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.om.security.User;

public class ALPop3MailReceiveThread
implements Runnable {
    public static final String KEY_NEW_MAIL_NUM = "nmn";
    public static final String KEY_RECEIVE_MAIL_NUM = "rmn";
    public static final String KEY_RECEIVE_MAIL_ALL_NUM = "rman";
    public static final String KEY_RECEIVE_STAT = "rs";
    public static final String KEY_THREAD = "thread";
    public static final int PROCESS_TYPE_RECEIVEMAIL = 1;
    public static final int PROCESS_TYPE_GET_NEWMAILNUM = 2;
    public static final int PROCESS_TYPE_STOP_RECEIVEMAIL = 3;
    public static final int PROCESS_STAT_FINISHED = 0;
    public static final int PROCESS_STAT_PROCESSING = -100;
    public static final int PROCESS_STAT_NONPROCESSING = -101;
    private String orgId = null;
    private String userId = null;
    private int mailAccountId = 0;
    private int processType = 1;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALPop3MailReceiveThread.class.getName());

    public ALPop3MailReceiveThread(String orgId, JetspeedUser user, int mailAccountId, int processType) {
        this.orgId = orgId;
        this.mailAccountId = mailAccountId;
        this.processType = processType;
        this.userId = user.getUserId();
        ALStaticObject ob = ALStaticObject.getInstance();
        ob.addAccountId(mailAccountId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ALStaticObject ob = ALStaticObject.getInstance();
        try {
            DataContext.bindThreadDataContext((DataContext)Database.createDataContext((String)this.orgId));
            EipMMailAccount account = ALMailUtils.getMailAccount(Integer.parseInt(this.userId), this.mailAccountId);
            if (this.processType == 1) {
                logger.info((Object)("[ALFilePop3MailReceiveThread] start receivemail (orgId, userId, mailAccountId)=(" + Database.getDomainName() + "," + this.userId + "," + this.mailAccountId + ")"));
                int res = this.receiveMail(this.orgId, account);
                ob.updateAccountStat(this.mailAccountId, KEY_RECEIVE_MAIL_NUM, res);
            } else if (this.processType == 2) {
                logger.info((Object)("[ALFilePop3MailReceiveThread] start newmailnum (orgId, userId, mailAccountId)=(" + this.orgId + "," + this.userId + "," + this.mailAccountId + ")"));
                int res = this.checkNewMailNum(this.orgId, account);
                if (res >= 0) {
                    ob.updateAccountStat(this.mailAccountId, KEY_NEW_MAIL_NUM, res);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"ALFilePop3MailReceiveThread.run", (Throwable)e);
        }
        finally {
            Database.tearDown();
            ob.updateAccountStat(this.mailAccountId, KEY_RECEIVE_STAT, 0);
            ALStaticObject.getInstance().removeAccountId(this.mailAccountId);
        }
    }

    private int receiveMail(String orgId, EipMMailAccount account) {
        ALStaticObject.getInstance().updateAccountStat(this.mailAccountId, KEY_RECEIVE_STAT, -100);
        int result = -1;
        if (account == null) {
            return result;
        }
        try {
            ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
            ALMailReceiverContext rcontext = ALMailUtils.getALPop3MailReceiverContext(orgId, account);
            result = handler.receive(rcontext, orgId);
            if (result <= -1 && result != -3) {
                return result;
            }
            DataContext dataContext = account.getDataContext();
            account.setLastReceivedDate(Calendar.getInstance().getTime());
            Database.commit((DataContext)dataContext);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"ALFilePop3MailReceiveThread.receiveMail", (Throwable)ex);
            result = -1;
            return result;
        }
        return result;
    }

    private int checkNewMailNum(String orgId, EipMMailAccount account) {
        int res = -1;
        if (account == null) {
            return res;
        }
        try {
            ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
            ALMailReceiverContext rcontext = ALMailUtils.getALPop3MailReceiverContext(orgId, account);
            res = handler.getNewMailSum(rcontext);
        }
        catch (Exception ex) {
            logger.error((Object)"ALFilePop3MailReceiveThread.checkNewMailNum", (Throwable)ex);
            res = -1;
        }
        return res;
    }

    public static int getNewMailNum(User user, int mailAccountId) {
        if (user == null) {
            return -101;
        }
        ALStaticObject ob = ALStaticObject.getInstance();
        Object obj = ob.getAccountStat(mailAccountId, KEY_NEW_MAIL_NUM);
        if (obj == null) {
            return -101;
        }
        return (Integer)obj;
    }

    public static boolean isProcessing(User user, int mailAccountId) {
        return !ALStaticObject.getInstance().receivable(mailAccountId);
    }

    public static boolean isReceiving(User user, int mailAccountId, String mailReceiveThreadStatus) {
        Object objRS = ALStaticObject.getInstance().getAccountStat(mailAccountId, KEY_RECEIVE_STAT);
        if ("1".equals(mailReceiveThreadStatus)) {
            return true;
        }
        return objRS != null && (Integer)objRS == -100;
    }

    public static int getReceiveMailResult(User user, int mailAccountId) {
        ALStaticObject ob = ALStaticObject.getInstance();
        Object obj = ob.getAccountStat(mailAccountId, KEY_RECEIVE_MAIL_NUM);
        if (obj == null) {
            return -101;
        }
        return (Integer)obj;
    }

    public static String getReceiveMailResultStr(User user, int mailAccountId, String mailReceiveThreadStatus) {
        String msg = null;
        if (ALPop3MailReceiveThread.isReceiving(user, mailAccountId, mailReceiveThreadStatus)) {
            StringBuffer sb = new StringBuffer();
            Object objRMAN = ALStaticObject.getInstance().getAccountStat(mailAccountId, KEY_RECEIVE_MAIL_ALL_NUM);
            Object objRMN = ALStaticObject.getInstance().getAccountStat(mailAccountId, KEY_RECEIVE_MAIL_NUM);
            if (objRMAN != null) {
                sb.append("\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u4e2d\u3067\u3059\uff08 ").append(objRMAN).append(" \u4ef6\u4e2d ").append(objRMN).append(" \u4ef6\u3092\u53d7\u4fe1 \uff09\u3002");
            } else {
                sb.append("\u30e1\u30fc\u30eb\u53d7\u4fe1\u30b5\u30fc\u30d0\u306b\u554f\u3044\u5408\u308f\u305b\u4e2d\u3067\u3059\u3002");
            }
            return sb.toString();
        }
        int res = ALPop3MailReceiveThread.getReceiveMailResult(user, mailAccountId);
        if (res == -101) {
            msg = "";
            return msg;
        }
        if (res == -1) {
            msg = "\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u30e1\u30fc\u30eb\u30a2\u30ab\u30a6\u30f3\u30c8\u306e\u8a2d\u5b9a\u3092\u3054\u78ba\u8a8d\u304f\u3060\u3055\u3044\u3002";
        } else if (res == -2) {
            msg = "\u30e1\u30fc\u30eb\u306e\u53d7\u4fe1\u4e2d\u3001\u3082\u3057\u304f\u306f\u3001\u30e1\u30f3\u30c6\u30ca\u30f3\u30b9\u4e2d\u3067\u3059\u3002\u3057\u3070\u3089\u304f\u3057\u3066\u304b\u3089\u3001\u300e\u30e1\u30fc\u30eb\u4e00\u89a7\u300f\u30dc\u30bf\u30f3\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
        } else if (res == -3) {
            int size = ALCommonUtils.getMaxFileSize();
            msg = size + "MB \u3088\u308a\u3082\u5927\u304d\u3044\u30b5\u30a4\u30ba\u306e\u30e1\u30fc\u30eb\u304c\u3042\u308a\u307e\u3057\u305f\u3002" + size + "MB\u3092\u8d85\u3048\u305f\u30e1\u30fc\u30eb\u306e\u5834\u5408\u306f\u3001\u9001\u4fe1\u8005\u306a\u3069\u306e\u60c5\u5831\u306e\u307f\u53d7\u4fe1\u3057\u3001\u672c\u6587\u306f\u53d7\u4fe1\u3057\u307e\u305b\u3093\u3002";
        } else {
            msg = res == -4 ? "\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u53d7\u4fe1\u30b5\u30fc\u30d0\uff08POP3\uff09\u3068\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" : (res == -5 ? "\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u53d7\u4fe1\u30b5\u30fc\u30d0\uff08POP3\uff09\u3078\u306e\u30ed\u30b0\u30a4\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" : (res == -6 ? "\u30b7\u30b9\u30c6\u30e0\u4e0a\u306e\u554f\u984c\u306b\u3088\u308a\u3001\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff08Exception \u30a8\u30e9\u30fc\uff09\u3002" : (res == -7 ? "\u30b7\u30b9\u30c6\u30e0\u4e0a\u306e\u554f\u984c\u306b\u3088\u308a\u3001\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff08OutOfMemory \u30a8\u30e9\u30fc\uff09\u3002" : "\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\u3002")));
        }
        ALStaticObject.getInstance().removeAccountId(mailAccountId);
        return msg;
    }
}

