/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.daemon.impl;

import java.io.Reader;
import java.util.Vector;
import org.apache.jetspeed.daemon.Daemon;
import org.apache.jetspeed.daemon.DaemonConfig;
import org.apache.jetspeed.daemon.DaemonEntry;
import org.apache.jetspeed.daemon.Feed;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.registry.FileRegistry;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.SimpleTransform;
import org.apache.turbine.services.TurbineServices;

public class FeedDaemon
implements Daemon {
    public static final String TEMP_FILE_KEY = "FeedDaemon-debug";
    public static String TEMP_DIRECTORY = JetspeedResources.getString("temp.directory");
    private static boolean processed = false;
    private static FeedDaemon instance = null;
    private int status = 1;
    private int result = 0;
    private DaemonConfig config = null;
    private DaemonEntry entry = null;
    private boolean initialized = false;
    private static int count = 0;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(FeedDaemon.class.getName());

    public static int getCount() {
        return count;
    }

    public static Feed[] getFeeds() {
        Vector v = JetspeedResources.getVector((String)"contentfeeds.feed.name");
        Vector<Feed> found = new Vector<Feed>();
        for (int i = 0; i < v.size(); ++i) {
            String name = (String)v.elementAt(i);
            String description = JetspeedResources.getString("contentfeeds.feed." + name + ".description");
            String url = JetspeedResources.getString("contentfeeds.feed." + name + ".url");
            found.addElement(new Feed(name, description, url));
        }
        Object[] feeds = new Feed[found.size()];
        found.copyInto(feeds);
        return feeds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.setResult(3);
            logger.info("Jetspeed:  FeedDaemon  -- BEGIN -- ");
            count = 0;
            Feed[] feeds = FeedDaemon.getFeeds();
            for (int i = 0; i < feeds.length; ++i) {
                String url = feeds[i].getURL();
                String name = "feed_" + feeds[i].getName();
                try {
                    logger.info("BEGIN FEED -> " + url);
                    Reader transformed = FeedDaemon.getEntries(url);
                    logger.info("Determining portlets...");
                    FileRegistry registry = (FileRegistry)TurbineServices.getInstance().getService("Registry");
                    registry.createFragment(name, transformed, true);
                    logger.info("END FEED -> " + url + " -> SUCCESS");
                    this.setResult(1);
                    continue;
                }
                catch (Exception e) {
                    this.error(e, "FeedDaemon:  Couldn't process URL:  " + url);
                    continue;
                }
                catch (Throwable t) {
                    this.error(t, "FeedDaemon:  Couldn't process URL:  " + url);
                }
            }
        }
        finally {
            logger.info("Jetspeed:  FeedDaemon  --  END  -- ");
        }
    }

    private void error(Throwable t, String message) {
        this.setResult(2);
        logger.error(message, t);
    }

    private void error(String message) {
        this.error(null, message);
    }

    public static final Reader getEntries(String url) throws Exception {
        String stylesheet = JetspeedResources.getString("contentfeeds.stylesheet.url");
        logger.info("FeedDaemon:  transforming url: " + url + " with stylesheet: " + stylesheet);
        return SimpleTransform.SAXTransform(url, stylesheet, null);
    }

    private static String strip(String target) {
        if (target.indexOf("<!DOCTYPE") != -1) {
            int begin = target.indexOf("\">") + 2;
            target = target.substring(begin, target.length());
        }
        return target;
    }

    public void init(DaemonConfig config, DaemonEntry entry) {
        this.config = config;
        this.entry = entry;
    }

    public DaemonConfig getDaemonConfig() {
        return this.config;
    }

    public DaemonEntry getDaemonEntry() {
        return this.entry;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public String getMessage() {
        return "Total number of content feeds found: " + FeedDaemon.getCount();
    }
}

