/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.daemon.impl.util;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ThreadGroupJoin {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ThreadGroupJoin.class.getName());

    public static void join(ThreadGroup tg) {
        ThreadGroupJoin.join(tg, null, 0);
    }

    public static void join(ThreadGroup tg, String source) {
        ThreadGroupJoin.join(tg, source, 100);
    }

    public static void join(ThreadGroup tg, String source, int interval) {
        Thread[] threads = new Thread[tg.activeCount()];
        tg.enumerate(threads);
        long begin = System.currentTimeMillis();
        for (int i = 0; i < threads.length; ++i) {
            Thread cfr_ignored_0 = threads[i];
            if (Thread.interrupted()) continue;
            try {
                if (threads[i] == null) continue;
                threads[i].join();
                if (i == 0 || i % interval != 0 || source == null) continue;
                long seconds = (System.currentTimeMillis() - begin) / 1000L;
                begin = System.currentTimeMillis();
                if (!logger.isInfoEnabled()) continue;
                logger.info(source + ": has completed " + i + " threads in " + seconds + " second(s)");
                continue;
            }
            catch (InterruptedException e) {
                logger.info("Thread: " + threads[i].getName() + " -> DONE");
            }
        }
    }
}

