/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.daemon.impl.util.diskcachedaemon;

import java.util.Enumeration;
import org.apache.jetspeed.daemon.impl.util.diskcachedaemon.PortletRefresher;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.urlmanager.URLFetcher;

public class URLRefresher
implements Runnable {
    private String url = null;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(URLRefresher.class.getName());

    public URLRefresher(String url) {
        this.url = url;
    }

    public void run() {
        try {
            if (URLFetcher.refresh(this.url)) {
                Enumeration enu = Registry.get(Registry.PORTLET).getEntries();
                while (enu.hasMoreElements()) {
                    PortletEntry entry = (PortletEntry)enu.nextElement();
                    if (entry.getURL() == null || !entry.getURL().equals(this.url)) continue;
                    try {
                        PortletRefresher pr = new PortletRefresher(entry);
                        pr.run();
                    }
                    catch (Throwable t) {
                        logger.info("DiskCacheDaemon: Error refreshing: " + this.url);
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error("Error refreshing URL", t);
        }
    }
}

