/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions;

import java.util.Date;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.modules.Action;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.GenerateUniqueId;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;

public class CreateNewUserAndConfirm
extends Action {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(CreateNewUserAndConfirm.class.getName());

    public void doPerform(RunData data) throws Exception {
        try {
            String submit = "submit1";
            String str = (String)data.getUser().getTemp(submit, (Object)"asdfasdf");
            if (str != null && str.equalsIgnoreCase(data.getParameters().getString(submit, ""))) {
                data.getUser().removeTemp(submit);
                data.setScreenTemplate(TurbineTemplate.getDefaultScreen());
                return;
            }
            String pass1 = data.getParameters().getString("password", "");
            String pass2 = data.getParameters().getString("password_confirm", "");
            if (pass1.length() == 0 || pass2.length() == 0 || !pass1.equals(pass2)) {
                data.setMessage(Localization.getString((RunData)data, (String)"CREATENEWUSERANDCONFIRM_PWNOTMATCH"));
                data.setScreenTemplate("NewAccount");
                return;
            }
            String username = data.getParameters().getString("username", "");
            username = JetspeedSecurity.convertUserName(username);
            pass1 = JetspeedSecurity.convertPassword(pass1);
            pass2 = JetspeedSecurity.convertPassword(pass2);
            if (username.length() == 0) {
                data.setMessage(Localization.getString((RunData)data, (String)"CREATENEWUSERANDCONFIRM_NOUSERNAME"));
                data.setScreenTemplate("NewAccount");
                return;
            }
            String email = data.getParameters().getString("email", "");
            if (email.length() == 0) {
                data.setMessage(Localization.getString((RunData)data, (String)"CREATENEWUSERANDCONFIRM_NOEMAIL"));
                data.setScreenTemplate("NewAccount");
                return;
            }
            String CHNAME = Localization.getString((RunData)data, (String)"CREATENEWUSERANDCONFIRM_DUPLICATEMSG");
            boolean accountExists = true;
            try {
                JetspeedSecurity.getUser(username);
            }
            catch (JetspeedSecurityException e) {
                accountExists = false;
            }
            if (!accountExists) {
                Date now = new Date();
                JetspeedUser user = JetspeedSecurity.getUserInstance();
                user.setUserName(username);
                user.setCreateDate(now);
                user.setLastLogin(new Date(0L));
                user.setFirstName(data.getParameters().getString("firstname"));
                user.setLastName(data.getParameters().getString("lastname"));
                user.setEmail(data.getParameters().getString("email"));
                this.createUser(user, data);
                String confirmValue = GenerateUniqueId.getIdentifier();
                boolean newUserNotification = JetspeedResources.getBoolean("newuser.notification.enable", false);
                boolean newUserApproval = JetspeedResources.getBoolean("newuser.approval.enable", false);
                boolean enableMail = JetspeedResources.getBoolean("newuser.confirm.enable", false);
                if (!enableMail) {
                    confirmValue = "CONFIRMED";
                }
                if (newUserApproval) {
                    confirmValue = "PENDING";
                }
                user.setConfirmed(confirmValue);
                data.setUser((User)user);
                user.setPassword(pass1);
                JetspeedSecurity.addUser(user);
                if (!enableMail && !newUserApproval) {
                    user.setHasLoggedIn(new Boolean(true));
                    user.setLastLogin(new Date(0L));
                }
                data.setMessage(Localization.getString((RunData)data, (String)"CREATENEWUSERANDCONFIRM_CREATE"));
                if (enableMail || newUserNotification || newUserApproval) {
                    data.setUser((User)JetspeedSecurity.getAnonymousUser());
                    data.getParameters().add("username", username);
                    data.getParameters().add("password", pass1);
                    if (!newUserApproval) {
                        ActionLoader.getInstance().exec(data, "SendConfirmationEmail");
                        data.setScreenTemplate("ConfirmRegistration");
                    } else {
                        data.setScreenTemplate("NewUserAwaitingAcceptance");
                    }
                    if (newUserNotification) {
                        ActionLoader.getInstance().exec(data, "SendNewUserNotificationEmail");
                    }
                } else {
                    this.bypassConfirmMail(data, username, pass1);
                }
            } else {
                data.setMessage(Localization.getString((RunData)data, (String)"CREATENEWUSERANDCONFIRM_CHOOSENEWNAME"));
                data.setScreenTemplate("NewAccount");
                data.getParameters().add("username", CHNAME);
            }
        }
        catch (Exception e) {
            logger.error("CreateNewUserAndConfirm", e);
            data.setMessage(e.toString());
            data.setStackTrace(StringUtils.stackTrace((Throwable)e), (Throwable)e);
            data.setScreenTemplate(JetspeedResources.getString("template.error", "Error"));
        }
    }

    protected void createUser(JetspeedUser user, RunData data) throws Exception {
    }

    private void bypassConfirmMail(RunData data, String username, String password) {
        JetspeedUser usr = null;
        try {
            usr = JetspeedSecurity.login(username, password);
            JetspeedLink jslink = JetspeedLinkFactory.getInstance(data);
            data.setRedirectURI(jslink.getHomePage().toString());
            JetspeedLinkFactory.putInstance(jslink);
        }
        catch (Exception e) {
            logger.error("Exception", e);
            data.setMessage(e.toString());
            data.setStackTrace(StringUtils.stackTrace((Throwable)e), (Throwable)e);
            data.setScreenTemplate(JetspeedResources.getString("template.error", "Error"));
        }
    }
}

