/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions;

import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.psmlmanager.PsmlImporter;
import org.apache.jetspeed.services.psmlmanager.PsmlManagerService;
import org.apache.turbine.modules.Action;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;

public class ImportPsml
extends Action {
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String CHECK_IMPORT = "check-import";

    public void doPerform(RunData data) throws Exception {
        try {
            String msg;
            ParameterParser parser = data.getParameters();
            boolean checkImport = parser.getBoolean(CHECK_IMPORT, false);
            String username = data.getUser().getUserName();
            if (!JetspeedSecurity.hasRole(username, "admin")) {
                data.setMessage("Only administrator can perform this action");
                throw new Exception("Only administrator can perform this action");
            }
            PsmlManagerService exporterService = null;
            PsmlManagerService importerService = null;
            try {
                exporterService = (PsmlManagerService)TurbineServices.getInstance().getService("PsmlImportManager");
            }
            catch (InstantiationException e) {
                msg = "PSML Importer: error loading Psml Exporter Service";
                data.setMessage(msg);
                Log.error((String)msg, (Throwable)e);
            }
            try {
                importerService = PsmlManager.getService();
            }
            catch (InstantiationException e) {
                msg = "PSML Importer: error loading Psml Importer Service";
                data.setMessage(msg);
                Log.error((String)msg, (Throwable)e);
            }
            if (exporterService.getClass().getName().equals(importerService.getClass().getName())) {
                String msg2 = "PSML Importer Error: Importer Class cannot equal Exporter Class.";
                data.setMessage(msg2);
                Log.error((String)msg2);
            }
            PsmlImporter importer = new PsmlImporter();
            importer.setCheck(checkImport);
            boolean ran = importer.run(exporterService, importerService);
            if (ran) {
                String msg3 = "**** PSML Importer - completed";
                System.out.println(msg3);
                data.setMessage(msg3);
            } else {
                String msg4 = "**** PSML Importer - did not run";
                System.out.println(msg4);
                data.setMessage(msg4);
            }
        }
        catch (Exception e) {
            data.setMessage(e.getMessage());
            Log.error((String)e.getMessage());
        }
    }
}

