/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions;

import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.nosecurity.FakeJetspeedUser;
import org.apache.turbine.modules.Action;
import org.apache.turbine.om.security.User;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;

public class JetspeedAccessController
extends Action {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedAccessController.class.getName());

    public void doPerform(RunData data) throws Exception {
        Profile currentProfile;
        Profile newProfile;
        JetspeedRunData jdata;
        block7: {
            JetspeedUser user = (JetspeedUser)data.getUser();
            this.getACL(data);
            jdata = null;
            try {
                jdata = (JetspeedRunData)data;
            }
            catch (ClassCastException e) {
                logger.error("The RunData object does not implement the expected interface, please verify the RunData factory settings", e);
                return;
            }
            newProfile = null;
            currentProfile = null;
            try {
                newProfile = Profiler.getProfile((RunData)jdata);
                currentProfile = jdata.getProfile();
            }
            catch (Throwable other) {
                data.setScreenTemplate(JetspeedResources.getString("template.error"));
                String message = other.getMessage() != null ? other.getMessage() : other.toString();
                data.setMessage(message);
                data.setStackTrace(StringUtils.stackTrace((Throwable)other), other);
                if (currentProfile == null) {
                    currentProfile = Profiler.createProfile();
                }
                if (newProfile == null) {
                    newProfile = Profiler.createProfile();
                }
                if (data.getUser() != null) break block7;
                FakeJetspeedUser juser = new FakeJetspeedUser(JetspeedSecurity.getAnonymousUserName(), false);
                data.setUser((User)juser);
            }
        }
        if (currentProfile == null || !currentProfile.equals(newProfile)) {
            jdata.setProfile(newProfile);
        }
    }

    protected void getACL(RunData data) {
        data.setACL(null);
    }
}

