/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions;

import java.util.Locale;
import org.apache.jetspeed.modules.actions.TemplateSessionValidator;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.customlocalization.CustomLocalizationService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;

public class JetspeedSessionValidator
extends TemplateSessionValidator {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedSessionValidator.class.getName());

    public void doPerform(RunData data) throws Exception {
        CustomLocalizationService locService;
        Locale locale;
        try {
            super.doPerform(data);
        }
        catch (Throwable other) {
            data.setScreenTemplate(JetspeedResources.getString("template.error"));
            String message = other.getMessage() != null ? other.getMessage() : other.toString();
            data.setMessage(message);
            data.setStackTrace(StringUtils.stackTrace((Throwable)other), other);
            return;
        }
        JetspeedUser user = (JetspeedUser)data.getUser();
        if ((user == null || !user.hasLoggedIn()) && JetspeedResources.getBoolean("automatic.logon.enable", false) && data.getRequest().getCookies() != null) {
            String userName = data.getCookies().getString("username", "");
            String loginCookieValue = data.getCookies().getString("logincookie", "");
            if (userName.length() > 0 && loginCookieValue.length() > 0) {
                try {
                    user = JetspeedSecurity.getUser(userName);
                    if (user.getPerm("logincookie", "").equals(loginCookieValue)) {
                        data.setUser((User)user);
                        user.setHasLoggedIn(Boolean.TRUE);
                        user.updateLastLogin();
                        data.save();
                    }
                }
                catch (LoginException noSuchUser) {
                }
                catch (UnknownUserException unknownUser) {
                    logger.warn("Username from the cookie was not found: " + userName);
                }
                catch (Exception other) {
                    logger.error(other);
                }
            }
        }
        JetspeedRunData jdata = null;
        try {
            jdata = (JetspeedRunData)data;
        }
        catch (ClassCastException e) {
            logger.error("The RunData object does not implement the expected interface, please verify the RunData factory settings", e);
            return;
        }
        String language = data.getRequest().getParameter("js_language");
        if (null != language) {
            user.setPerm("language", language);
        }
        if ((locale = (locService = (CustomLocalizationService)ServiceUtil.getServiceByName("LocalizationService")).getLocale(data)) == null) {
            locale = new Locale(TurbineResources.getString((String)"locale.default.language", (String)"en"), TurbineResources.getString((String)"locale.default.country", (String)"US"));
        }
        data.getUser().setTemp("locale", (Object)locale);
        String paramPortlet = jdata.getParameters().getString("js_peid");
        if (paramPortlet != null && paramPortlet.length() > 0) {
            jdata.setJs_peid(paramPortlet);
        }
    }

    public boolean requiresNewSession(RunData data) {
        return false;
    }
}

