/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.controls;

import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletState;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.modules.Action;
import org.apache.turbine.util.RunData;

public class Minimize
extends Action {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(Minimize.class.getName());

    public void doPerform(RunData rundata) throws Exception {
        if (rundata.getUser() == null) {
            return;
        }
        String peid = rundata.getParameters().getString("js_peid");
        if (peid == null) {
            return;
        }
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        Entry entry = jdata.getProfile().getDocument().getEntryById(peid);
        if (entry == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to get PEID (" + peid + ") entry for User (" + rundata.getUser().getName() + ")");
            }
            return;
        }
        Portlet portlet = PortletFactory.getPortlet(entry);
        if (portlet != null && portlet instanceof PortletState) {
            if (logger.isDebugEnabled()) {
                logger.debug("peid = " + peid);
                logger.debug("portlet id = " + portlet.getID());
            }
            if (portlet.getID().equals(peid)) {
                ((PortletState)((Object)portlet)).setMinimized(true, rundata);
            }
        }
    }
}

