/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import org.apache.jetspeed.modules.actions.portlets.RegistryUpdateAction;
import org.apache.jetspeed.om.registry.ClientEntry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ClientUpdateAction
extends RegistryUpdateAction {
    private static final String whoAmI = "ClientUpdateAction: ";
    private static final String CLIENT_UPDATE_PANE = "ClientForm";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ClientUpdateAction.class.getName());

    public ClientUpdateAction() {
        this.registryEntryName = "client_name";
        this.registry = Registry.CLIENT;
        this.pane = CLIENT_UPDATE_PANE;
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        super.buildNormalContext(portlet, context, rundata);
        String mode = rundata.getParameters().getString("mode");
        if (mode != null && (mode.equals("delete") || mode.equals("update"))) {
            String clientName = rundata.getParameters().getString("client_name");
            ClientEntry clientEntry = (ClientEntry)Registry.getEntry(Registry.CLIENT, clientName);
            context.put("entry", (Object)clientEntry);
        }
    }

    public void doAddmimetype(RunData rundata, Context context) throws Exception {
        try {
            String clientName = rundata.getParameters().getString("client_name");
            ClientEntry clientEntry = (ClientEntry)Registry.getEntry(Registry.CLIENT, clientName);
            if (clientEntry != null) {
                String mimeType = rundata.getParameters().getString("mime_type");
                clientEntry.getMimetypeMap().addMimetype(mimeType);
                Registry.addEntry(Registry.CLIENT, clientEntry);
                this.clearUserData(rundata);
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error(((Object)((Object)this)).getClass().getName() + ": Failed to find registry entry while trying to add mime type");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 0);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Error addin mime type", e);
        }
    }

    public void doRemovemimetype(RunData rundata, Context context) throws Exception {
        try {
            String clientName = rundata.getParameters().getString("client_name");
            ClientEntry clientEntry = (ClientEntry)Registry.getEntry(Registry.CLIENT, clientName);
            if (clientEntry != null) {
                String[] mimeTypes = rundata.getParameters().getStrings("mime_type");
                if (mimeTypes != null && mimeTypes.length > 0) {
                    for (int i = 0; i < mimeTypes.length; ++i) {
                        String mimeType = mimeTypes[i];
                        clientEntry.getMimetypeMap().removeMimetype(mimeType);
                    }
                    Registry.addEntry(Registry.CLIENT, clientEntry);
                    this.clearUserData(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error(((Object)((Object)this)).getClass().getName() + ": Failed to find registry entry while trying to remove mime types");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 0);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Error removing mime types", e);
        }
    }

    protected void updateRegistryEntry(RunData rundata, RegistryEntry registryEntry) throws Exception {
        super.updateRegistryEntry(rundata, registryEntry);
        this.updateClientEntry(rundata, (ClientEntry)registryEntry);
    }

    private void updateClientEntry(RunData rundata, ClientEntry clientEntry) throws Exception {
        String userAgentPattern = rundata.getParameters().getString("user_agent_pattern");
        String manufacturer = rundata.getParameters().getString("manufacturer");
        String model = rundata.getParameters().getString("model");
        String version = rundata.getParameters().getString("version");
        if (this.hasChanged(clientEntry.getUseragentpattern(), userAgentPattern)) {
            try {
                RE re = new RE(userAgentPattern);
                clientEntry.setUseragentpattern(userAgentPattern);
            }
            catch (RESyntaxException e) {
                logger.error("ClientUpdateAction: Illegal regular expression syntax " + userAgentPattern + " for user agent");
                logger.debug("ClientUpdateAction: Illegal regular expression syntax for user agent", e);
                throw new IllegalArgumentException("Illegal regular expression syntax for user agent");
            }
        }
        if (this.hasChanged(clientEntry.getManufacturer(), manufacturer)) {
            clientEntry.setManufacturer(manufacturer);
        }
        if (this.hasChanged(clientEntry.getModel(), model)) {
            clientEntry.setModel(model);
        }
        if (this.hasChanged(clientEntry.getVersion(), version)) {
            clientEntry.setVersion(version);
        }
    }

    protected void resetForm(RunData rundata) {
        super.resetForm(rundata);
        String userAgentPattern = rundata.getParameters().getString("user_agent_pattern");
        String manufacturer = rundata.getParameters().getString("manufacturer");
        String model = rundata.getParameters().getString("model");
        String version = rundata.getParameters().getString("version");
        String capability = rundata.getParameters().getString("capability");
        String mimeType = rundata.getParameters().getString("mime_type");
        rundata.getUser().setTemp("user_agent_pattern", (Object)userAgentPattern);
        rundata.getUser().setTemp("manufacturer", (Object)manufacturer);
        rundata.getUser().setTemp("model", (Object)model);
        rundata.getUser().setTemp("version", (Object)version);
        rundata.getUser().setTemp("capability", (Object)capability);
        rundata.getUser().setTemp("mimetype", (Object)mimeType);
    }

    protected void clearUserData(RunData rundata) {
        block2: {
            try {
                super.clearUserData(rundata);
                rundata.getUser().removeTemp("user_agent_pattern");
                rundata.getUser().removeTemp("manufacturer");
                rundata.getUser().removeTemp("model");
                rundata.getUser().removeTemp("version");
                rundata.getUser().removeTemp("capability");
                rundata.getUser().removeTemp("mime_type");
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("ClientUpdateAction: Failed to clear user data");
            }
        }
    }
}

