/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.jetspeed.modules.actions.portlets.PortletFilter;
import org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction;
import org.apache.jetspeed.om.BaseSecurityReference;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.om.profile.Controller;
import org.apache.jetspeed.om.profile.MetaInfo;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.profile.QueryLocator;
import org.apache.jetspeed.om.profile.Skin;
import org.apache.jetspeed.om.profile.psml.PsmlControl;
import org.apache.jetspeed.om.profile.psml.PsmlController;
import org.apache.jetspeed.om.profile.psml.PsmlEntry;
import org.apache.jetspeed.om.profile.psml.PsmlMetaInfo;
import org.apache.jetspeed.om.profile.psml.PsmlPortlets;
import org.apache.jetspeed.om.profile.psml.PsmlReference;
import org.apache.jetspeed.om.profile.psml.PsmlSkin;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.registry.PortletInfoEntry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.base.BaseCategory;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.PortletSetController;
import org.apache.jetspeed.portal.PortletSkin;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.services.customlocalization.CustomLocalization;
import org.apache.jetspeed.services.idgenerator.JetspeedIdGenerator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.util.AutoProfile;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CustomizeSetAction
extends VelocityPortletAction {
    private static final String USER_SELECTIONS = "session.portlets.user.selections";
    private static final String UI_PORTLETS_SELECTED = "portletsSelected";
    private static final String PORTLET_LIST = "session.portlets.list";
    private static final String ALL_PORTLET_LIST = "session.all.portlets.list";
    private static final String PORTLET_LIST_PAGE_SIZE = "session.portlets.page.size";
    private static final String HIDE_EMPTY_CATEGORIES = "customizer.hide.empty.categories";
    public static final String FILTER_FIELDS = "filter_fields";
    public static final String FILTER_VALUES = "filter_values";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(CustomizeSetAction.class.getName());

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        String template;
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        SessionState customizationState = jdata.getPageSessionState();
        Profile profile = jdata.getCustomizedProfile();
        String mediaType = profile.getMediaType();
        context.put("mtype", (Object)profile.getMediaType());
        context.put("runs", (Object)AutoProfile.getPortletList(rundata));
        PortletSet set = (PortletSet)jdata.getCustomized();
        String mode = rundata.getParameters().getString("mode");
        if (mode == null) {
            mode = (String)customizationState.getAttribute("customize-mode");
            if (mode == null || mode.equalsIgnoreCase("addset") || mode.equalsIgnoreCase("general")) {
                mode = "layout";
            }
        } else {
            if (mediaType.equalsIgnoreCase("wml") && !mode.equalsIgnoreCase("add")) {
                mode = "layout";
            }
            customizationState.setAttribute("customize-mode", mode);
        }
        if ((template = (String)context.get("template")) != null) {
            int idx = template.lastIndexOf(".");
            if (idx > 0) {
                template = template.substring(0, idx);
            }
            StringBuffer buffer = new StringBuffer(template);
            buffer.append("-").append(mode).append(".vm");
            template = TemplateLocator.locatePortletTemplate(rundata, buffer.toString());
            context.put("feature", (Object)template);
        }
        if (set == null) {
            return;
        }
        String customizedPaneName = (String)customizationState.getAttribute("customize-paneName");
        if (customizedPaneName == null) {
            customizedPaneName = "*";
        }
        context.put("panename", (Object)customizedPaneName);
        context.put("skin", (Object)set.getPortletConfig().getPortletSkin());
        context.put("set", (Object)set);
        context.put("action", (Object)"portlets.CustomizeSetAction");
        context.put("controllers", (Object)CustomizeSetAction.buildInfoList(rundata, Registry.PORTLET_CONTROLLER, mediaType));
        context.put("customizer", (Object)portlet);
        String controllerName = set.getController().getConfig().getName();
        context.put("currentController", (Object)controllerName);
        context.put("currentSecurityRef", (Object)set.getPortletConfig().getSecurityRef());
        if (mediaType.equalsIgnoreCase("wml")) {
            context.put("currentSkin", (Object)"Not for wml!");
            context.put("allowproperties", (Object)"false");
        } else {
            if (set.getPortletConfig().getSkin() != null) {
                context.put("currentSkin", (Object)set.getPortletConfig().getPortletSkin().getName());
            }
            context.put("allowproperties", (Object)"true");
        }
        context.put("allowpane", (Object)"false");
        if (!mediaType.equalsIgnoreCase("wml") && set.getController() instanceof PortletSetController) {
            if (customizedPaneName != null) {
                context.put("allowpane", (Object)"true");
            }
        } else {
            context.put("allowportlet", (Object)"true");
        }
        if ("add".equals(mode)) {
            int start = rundata.getParameters().getInt("start", -1);
            if (start < 0) {
                start = 0;
                PortletSessionState.clearAttribute(rundata, USER_SELECTIONS);
                PortletSessionState.clearAttribute(rundata, PORTLET_LIST);
            }
            ArrayList allPortlets = new ArrayList();
            List portlets = CustomizeSetAction.buildPortletList(rundata, set, mediaType, allPortlets);
            Map userSelections = CustomizeSetAction.getUserSelections(rundata);
            List categories = CustomizeSetAction.buildCategoryList(rundata, mediaType, allPortlets);
            context.put("categories", (Object)categories);
            context.put("parents", (Object)PortletFilter.buildParentList(allPortlets));
            this.addFiltersToContext(rundata, context);
            int size = this.getSize(portlet);
            int end = Math.min(start + size, portlets.size());
            if (start > 0) {
                context.put("prev", (Object)String.valueOf(Math.max(start - size, 0)));
            }
            if (start + size < portlets.size()) {
                context.put("next", (Object)String.valueOf(start + size));
            }
            context.put("browser", portlets.subList(start, end));
            context.put("size", (Object)new Integer(size));
            context.put(UI_PORTLETS_SELECTED, (Object)userSelections);
            context.put("portlets", (Object)portlets);
        } else if ("addref".equals(mode)) {
            Iterator psmlIterator = null;
            psmlIterator = Profiler.query(new QueryLocator(15));
            int start = rundata.getParameters().getInt("start", 0);
            int size = this.getSize(portlet);
            LinkedList<Profile> psmlList = new LinkedList<Profile>();
            Profile refProfile = null;
            int profileCounter = 0;
            while (psmlIterator.hasNext()) {
                refProfile = (Profile)psmlIterator.next();
                if (refProfile.getMediaType() != null && !profile.getMediaType().equals(refProfile.getMediaType()) || (profile.getLanguage() == null ? refProfile.getLanguage() != null : refProfile.getLanguage() != null && (!profile.getLanguage().equals(refProfile.getLanguage()) || (profile.getCountry() != null ? refProfile.getCountry() != null && !profile.getCountry().equals(refProfile.getCountry()) : refProfile.getCountry() != null)))) continue;
                if (profile.getPath().equals(refProfile.getPath())) continue;
                if (profileCounter >= start + size) break;
                if (profileCounter >= start) {
                    psmlList.add(refProfile);
                }
                ++profileCounter;
            }
            if (start > 0) {
                context.put("prev", (Object)String.valueOf(Math.max(start - size, 0)));
            }
            if (size == psmlList.size() && psmlIterator.hasNext()) {
                context.put("next", (Object)String.valueOf(start + size));
            }
            context.put("psml", psmlList.iterator());
        }
    }

    public int getSize(VelocityPortlet portlet) {
        int size = 15;
        try {
            size = Integer.parseInt(portlet.getPortletConfig().getInitParameter("size"));
        }
        catch (Exception e) {
            logger.debug("CustomizeSetAction: Init param 'size' not parsed");
        }
        return size;
    }

    public void doCancel(RunData rundata, Context context) {
        SessionState customizationState = ((JetspeedRunData)rundata).getPageSessionState();
        customizationState.setAttribute("customize-mode", "layout");
    }

    public void doSave(RunData rundata, Context context) {
        this.doMetainfo(rundata, context);
        this.doSkin(rundata, context);
        this.doLayout(rundata, context);
        this.doSecurity(rundata, context);
        Profile profile = ((JetspeedRunData)rundata).getCustomizedProfile();
        try {
            String mtype = rundata.getParameters().getString("mtype");
            if (mtype != null) {
                profile.setMediaType(mtype);
            }
            profile.store();
        }
        catch (Exception e) {
            logger.error("Exception occured while saving PSML", e);
        }
    }

    public void doApply(RunData rundata, Context context) {
        this.doSave(rundata, context);
    }

    public void doAddset(RunData rundata, Context context) {
        Portlets portlets;
        PortletSet set = (PortletSet)((JetspeedRunData)rundata).getCustomized();
        String title = rundata.getParameters().getString("title", "My Pane");
        if (set != null && (portlets = ((JetspeedRunData)rundata).getCustomizedProfile().getDocument().getPortletsById(set.getID())) != null) {
            PsmlPortlets p = new PsmlPortlets();
            p.setMetaInfo(new PsmlMetaInfo());
            p.getMetaInfo().setTitle(title);
            p.setId(JetspeedIdGenerator.getNextPeid());
            SecurityReference defaultRef = PortalToolkit.getDefaultSecurityRef(((JetspeedRunData)rundata).getCustomizedProfile());
            if (defaultRef != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("CustomizeSetAction: setting default portlet set security to [" + defaultRef.getParent() + "]");
                }
                p.setSecurityRef(defaultRef);
            }
            portlets.addPortlets(p);
        }
        SessionState customizationState = ((JetspeedRunData)rundata).getPageSessionState();
        customizationState.setAttribute("customize-mode", "layout");
    }

    public void doPrevious(RunData rundata, Context context) throws Exception {
        int queryStart = rundata.getParameters().getInt("previous", 0);
        String mtype = rundata.getParameters().getString("mtype", null);
        this.maintainUserSelections(rundata);
        JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
        DynamicURI duri = null;
        duri = mtype == null ? link.setTemplate("Customize").addQueryData("start", String.valueOf(queryStart)) : link.setTemplate("Customize").addQueryData("start", String.valueOf(queryStart)).addQueryData("mtype", mtype);
        JetspeedLinkFactory.putInstance(link);
        rundata.setRedirectURI(duri.toString());
    }

    public void doNext(RunData rundata, Context context) throws Exception {
        int queryStart = rundata.getParameters().getInt("next", 0);
        String mtype = rundata.getParameters().getString("mtype", null);
        this.maintainUserSelections(rundata);
        JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
        DynamicURI duri = null;
        duri = mtype == null ? link.setTemplate("Customize").addQueryData("start", String.valueOf(queryStart)) : link.setTemplate("Customize").addQueryData("start", String.valueOf(queryStart)).addQueryData("mtype", mtype);
        JetspeedLinkFactory.putInstance(link);
        rundata.setRedirectURI(duri.toString());
    }

    protected void maintainUserSelections(RunData rundata) throws Exception {
        int size = rundata.getParameters().getInt("size", 0);
        int previous = rundata.getParameters().getInt("previous", -1);
        int start = 0;
        if (previous >= 0) {
            start = previous + size;
        }
        String[] pnames = rundata.getParameters().getStrings("pname");
        Map userSelections = CustomizeSetAction.getUserSelections(rundata);
        List portlets = (List)PortletSessionState.getAttribute(rundata, PORTLET_LIST, null);
        if (portlets != null) {
            int end = Math.min(start + size, portlets.size());
            int pnamesIndex = 0;
            for (int portletIndex = start; portletIndex < end; ++portletIndex) {
                PortletEntry entry = (PortletEntry)portlets.get(portletIndex);
                if (pnames != null && pnamesIndex < pnames.length && pnames[pnamesIndex].equals(entry.getName())) {
                    userSelections.put(entry.getName(), entry);
                    ++pnamesIndex;
                    continue;
                }
                userSelections.remove(entry.getName());
            }
        } else {
            throw new Exception("Master Portlet List is null!");
        }
        PortletSessionState.setAttribute(rundata, USER_SELECTIONS, userSelections);
    }

    public void doAdd(RunData rundata, Context context) throws Exception {
        PortletSet set = (PortletSet)((JetspeedRunData)rundata).getCustomized();
        this.maintainUserSelections(rundata);
        Map userSelections = CustomizeSetAction.getUserSelections(rundata);
        String[] pnames = new String[userSelections.size()];
        userSelections.keySet().toArray(pnames);
        PsmlControl ctrl = new PsmlControl();
        ctrl.setName("ClearPortletControl");
        if (pnames != null && set != null) {
            Portlets portlets = ((JetspeedRunData)rundata).getCustomizedProfile().getDocument().getPortletsById(set.getID());
            List usedPortlets = AutoProfile.getPortletList(rundata);
            for (int i = 0; i < pnames.length; ++i) {
                boolean addIt;
                PortletEntry entry = (PortletEntry)Registry.getEntry(Registry.PORTLET, pnames[i]);
                if (entry == null || portlets == null || !(addIt = true)) continue;
                PsmlEntry p = new PsmlEntry();
                p.setParent(pnames[i]);
                p.setId(JetspeedIdGenerator.getNextPeid());
                portlets.addEntry(p);
            }
        }
        SessionState customizationState = ((JetspeedRunData)rundata).getPageSessionState();
        customizationState.setAttribute("customize-mode", "layout");
    }

    public void doAddref(RunData rundata, Context context) throws Exception {
        PortletSet set = (PortletSet)((JetspeedRunData)rundata).getCustomized();
        String[] refNames = rundata.getParameters().getStrings("refname");
        PsmlControl ctrl = new PsmlControl();
        ctrl.setName("ClearPortletControl");
        if (refNames != null && set != null) {
            Portlets portlets = ((JetspeedRunData)rundata).getCustomizedProfile().getDocument().getPortletsById(set.getID());
            for (int i = 0; i < refNames.length; ++i) {
                SecurityReference sref = this.getSecurityReference(rundata, refNames[i]);
                if (sref != null) {
                    PsmlReference ref = new PsmlReference();
                    ref.setPath(refNames[i]);
                    ref.setSecurityRef(sref);
                    portlets.addReference(ref);
                    continue;
                }
                String tmpl = CustomLocalization.getString("CUSTOMIZER_ADD_REF_ERROR", rundata);
                Object[] args = new Object[]{refNames[i]};
                String message = MessageFormat.format(tmpl, args).toString();
                rundata.addMessage(message.concat("<br>"));
                if (!logger.isWarnEnabled()) continue;
                logger.warn(message);
            }
        }
        SessionState customizationState = ((JetspeedRunData)rundata).getPageSessionState();
        customizationState.setAttribute("customize-mode", "layout");
    }

    protected SecurityReference getSecurityReference(RunData rundata, String path) {
        try {
            PSMLDocument doc;
            ProfileLocator locator = Profiler.createLocator();
            locator.createFromPath(path);
            Profile profile = Profiler.getProfile(locator);
            if (profile != null && (doc = profile.getDocument()) != null) {
                Portlets rootSet = doc.getPortlets();
                return rootSet.getSecurityRef();
            }
        }
        catch (ProfileException e) {
            logger.error("Exception", e);
        }
        return null;
    }

    public void doMetainfo(RunData rundata, Context context) {
        Portlets portlets;
        PortletSet set = (PortletSet)((JetspeedRunData)rundata).getCustomized();
        String title = rundata.getParameters().getString("title");
        String description = rundata.getParameters().getString("description");
        if (set != null && (portlets = ((JetspeedRunData)rundata).getCustomizedProfile().getDocument().getPortletsById(set.getID())) != null) {
            MetaInfo meta = portlets.getMetaInfo();
            if (meta == null) {
                meta = new PsmlMetaInfo();
                portlets.setMetaInfo(meta);
            }
            if (title != null) {
                meta.setTitle(title);
                set.setTitle(title);
            }
            if (description != null) {
                meta.setDescription(description);
                set.setDescription(description);
            }
        }
    }

    public void doLayout(RunData rundata, Context context) {
        PortletSet set = (PortletSet)((JetspeedRunData)rundata).getCustomized();
        try {
            String controller = rundata.getParameters().getString("controller");
            if (controller != null) {
                Profile profile = ((JetspeedRunData)rundata).getCustomizedProfile();
                PortletController pc = PortalToolkit.getController(controller);
                if (pc != null) {
                    set.setController(pc);
                    Portlets portlets = profile.getDocument().getPortletsById(set.getID());
                    Controller c = portlets.getController();
                    if (c == null) {
                        c = new PsmlController();
                        portlets.setController(c);
                    }
                    c.setName(controller);
                    String linkedControl = pc.getConfig().getInitParameter("control");
                    if (linkedControl != null) {
                        PsmlControl ctl = new PsmlControl();
                        ctl.setName(linkedControl);
                        portlets.setControl(ctl);
                    } else {
                        portlets.setControl(null);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSkin(RunData rundata, Context context) {
        PortletSet set = (PortletSet)((JetspeedRunData)rundata).getCustomized();
        try {
            String skin = rundata.getParameters().getString("skin");
            Profile profile = ((JetspeedRunData)rundata).getCustomizedProfile();
            Portlets portlets = profile.getDocument().getPortletsById(set.getID());
            if (skin != null && skin.trim().length() > 0) {
                PortletSkin s = PortalToolkit.getSkin(skin);
                if (s == null) {
                    logger.warn("Unable to update skin for portlet set " + set.getID() + " because skin " + skin + " does not exist.");
                    return;
                }
                set.getPortletConfig().setPortletSkin(s);
                Skin psmlSkin = portlets.getSkin();
                if (psmlSkin == null) {
                    portlets.setSkin(new PsmlSkin());
                }
                portlets.getSkin().setName(skin);
                return;
            }
            String custPortletSetID = portlets.getId();
            String rootPortletSetID = profile.getRootSet().getID();
            if (custPortletSetID != null && rootPortletSetID != null && custPortletSetID.equals(rootPortletSetID)) {
                String defaultSkinName = JetspeedResources.getString("services.PortalToolkit.default.skin");
                PortletSkin defaultSkin = PortalToolkit.getSkin(defaultSkinName);
                if (defaultSkin == null) {
                    logger.warn("Unable to set default skin for root portlet set " + set.getID() + " because skin " + skin + " does not exist.");
                    return;
                }
                set.getPortletConfig().setPortletSkin(defaultSkin);
                Skin psmlSkin = portlets.getSkin();
                if (psmlSkin == null) {
                    portlets.setSkin(new PsmlSkin());
                }
                portlets.getSkin().setName(defaultSkin.getName());
                return;
            }
            set.getPortletConfig().setPortletSkin(null);
            portlets.setSkin(null);
            return;
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public void doSecurity(RunData rundata, Context context) {
        PortletSet set = (PortletSet)((JetspeedRunData)rundata).getCustomized();
        try {
            String securityRefName = rundata.getParameters().getString("securityRef");
            BaseSecurityReference securityRef = null;
            Profile profile = ((JetspeedRunData)rundata).getCustomizedProfile();
            Portlets portlets = profile.getDocument().getPortletsById(set.getID());
            if (securityRefName != null && securityRefName.trim().length() > 0) {
                securityRef = new BaseSecurityReference();
                securityRef.setParent(securityRefName);
            }
            set.getPortletConfig().setSecurityRef(securityRef);
            portlets.setSecurityRef(securityRef);
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
    }

    public static List buildPortletList(RunData data, PortletSet set, String mediaType, List allPortlets) {
        List<PortletEntry> list = new ArrayList();
        Iterator i = Registry.get(Registry.PORTLET).listEntryNames();
        while (i.hasNext()) {
            PortletEntry entry = (PortletEntry)Registry.getEntry(Registry.PORTLET, (String)i.next());
            allPortlets.add(entry);
            if (!JetspeedSecurity.checkPermission((JetspeedUser)data.getUser(), new PortalResource(entry), "view") || entry.isHidden() || entry.getType().equals("abstract") || !entry.hasMediaType(mediaType)) continue;
            list.add(entry);
        }
        String[] filterFields = (String[])PortletSessionState.getAttribute(data, FILTER_FIELDS);
        String[] filterValues = (String[])PortletSessionState.getAttribute(data, FILTER_VALUES);
        list = PortletFilter.filterPortlets(list, filterFields, filterValues);
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String t1 = ((PortletEntry)o1).getTitle() != null ? ((PortletEntry)o1).getTitle().toLowerCase() : ((PortletEntry)o1).getName().toLowerCase();
                String t2 = ((PortletEntry)o2).getTitle() != null ? ((PortletEntry)o2).getTitle().toLowerCase() : ((PortletEntry)o2).getName().toLowerCase();
                return t1.compareTo(t2);
            }
        });
        PortletSessionState.setAttribute(data, PORTLET_LIST, list);
        return list;
    }

    public static Map getUserSelections(RunData data) {
        HashMap userSelections = (HashMap)PortletSessionState.getAttribute(data, USER_SELECTIONS, null);
        if (userSelections == null) {
            userSelections = new HashMap();
            PortletSessionState.setAttribute(data, USER_SELECTIONS, userSelections);
        }
        return userSelections;
    }

    public static List buildInfoList(RunData data, String regName, String mediaType) {
        ArrayList<PortletInfoEntry> list = new ArrayList<PortletInfoEntry>();
        String mime = ((JetspeedRunData)data).getCapability().getPreferredType().toString();
        Iterator m = Registry.get(Registry.MEDIA_TYPE).listEntryNames();
        Iterator i = Registry.get(regName).listEntryNames();
        while (i.hasNext()) {
            PortletInfoEntry entry = (PortletInfoEntry)Registry.getEntry(regName, (String)i.next());
            if (!JetspeedSecurity.checkPermission((JetspeedUser)data.getUser(), new PortalResource(entry), "customize") || entry.isHidden() || !entry.hasMediaType(mediaType)) continue;
            list.add(entry);
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String t1 = ((RegistryEntry)o1).getTitle() != null ? ((RegistryEntry)o1).getTitle() : ((RegistryEntry)o1).getName();
                String t2 = ((RegistryEntry)o2).getTitle() != null ? ((RegistryEntry)o2).getTitle() : ((RegistryEntry)o2).getName();
                return t1.compareTo(t2);
            }
        });
        return list;
    }

    public static List buildList(RunData data, String regName) {
        ArrayList<RegistryEntry> list = new ArrayList<RegistryEntry>();
        Iterator i = Registry.get(regName).listEntryNames();
        while (i.hasNext()) {
            RegistryEntry entry = Registry.getEntry(regName, (String)i.next());
            if (!JetspeedSecurity.checkPermission((JetspeedUser)data.getUser(), new PortalResource(entry), "customize") || entry.isHidden()) continue;
            list.add(entry);
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String t1 = ((RegistryEntry)o1).getTitle() != null ? ((RegistryEntry)o1).getTitle() : ((RegistryEntry)o1).getName();
                String t2 = ((RegistryEntry)o2).getTitle() != null ? ((RegistryEntry)o2).getTitle() : ((RegistryEntry)o2).getName();
                return t1.compareTo(t2);
            }
        });
        return list;
    }

    public static List buildCategoryList(RunData data, String mediaType, List portlets) {
        boolean hideEmpties = JetspeedResources.getBoolean(HIDE_EMPTY_CATEGORIES, true);
        TreeMap<String, BaseCategory> catMap = new TreeMap<String, BaseCategory>();
        for (PortletEntry entry : portlets) {
            BaseCategory cat;
            Iterator cItr;
            if (hideEmpties) {
                if (!JetspeedSecurity.checkPermission((JetspeedUser)data.getUser(), new PortalResource(entry), "view") || entry.isHidden() || entry.getType().equals("abstract") || !entry.hasMediaType(mediaType)) continue;
                cItr = entry.listCategories();
                while (cItr.hasNext()) {
                    cat = (BaseCategory)cItr.next();
                    catMap.put(cat.getName(), cat);
                }
                continue;
            }
            cItr = entry.listCategories();
            while (cItr.hasNext()) {
                cat = (BaseCategory)cItr.next();
                catMap.put(cat.getName(), cat);
            }
        }
        return new ArrayList(catMap.values());
    }

    public void doFiltercategory(RunData rundata, Context context) throws Exception {
        String filterCat = rundata.getParameters().getString("filter_category", "All Portlets");
        PortletSessionState.setAttribute(rundata, "filter_category", filterCat);
        this.maintainUserSelections(rundata);
        String mtype = rundata.getParameters().getString("mtype", null);
        JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
        DynamicURI duri = null;
        duri = mtype == null ? link.setTemplate("Customize").addQueryData("start", "0") : link.setTemplate("Customize").addQueryData("start", "0").addQueryData("mtype", mtype);
        JetspeedLinkFactory.putInstance(link);
        rundata.setRedirectURI(duri.toString());
    }

    public void doFilter(RunData rundata, Context context) throws Exception {
        String[] filterFields = rundata.getParameters().getStrings("filter_field");
        String[] filterValues = new String[filterFields.length];
        for (int i = 0; i < filterFields.length; ++i) {
            String filterValue;
            String filterField = filterFields[i];
            if (filterField == null) continue;
            filterValues[i] = filterValue = rundata.getParameters().getString(filterField + ":filter_value");
        }
        PortletSessionState.setAttribute(rundata, FILTER_FIELDS, filterFields);
        PortletSessionState.setAttribute(rundata, FILTER_VALUES, filterValues);
        this.maintainUserSelections(rundata);
        String mtype = rundata.getParameters().getString("mtype", null);
        JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
        DynamicURI duri = null;
        duri = mtype == null ? link.setTemplate("Customize").addQueryData("start", "0") : link.setTemplate("Customize").addQueryData("start", "0").addQueryData("mtype", mtype);
        JetspeedLinkFactory.putInstance(link);
        rundata.setRedirectURI(duri.toString());
    }

    private void addFiltersToContext(RunData data, Context context) {
        String[] filterFields = (String[])PortletSessionState.getAttribute(data, FILTER_FIELDS);
        String[] filterValues = (String[])PortletSessionState.getAttribute(data, FILTER_VALUES);
        if (filterFields != null && filterValues != null && filterFields.length == filterValues.length) {
            for (int i = 0; i < filterFields.length; ++i) {
                String field = filterFields[i];
                String value = filterValues[i];
                context.put(field + "_filter_value", (Object)value);
            }
        }
    }
}

