/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.jetspeed.modules.actions.portlets.GenericMVCAction;
import org.apache.jetspeed.portal.Portlet;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class LogfileViewerAction
extends GenericMVCAction {
    private static final Logger logger = LogManager.getLogger((String)LogfileViewerAction.class.getName());
    private static HashMap appenders = null;

    protected void buildNormalContext(Portlet portlet, Context context, RunData rundata) throws Exception {
        LoggerRepository repos = logger.getLoggerRepository();
        Enumeration loggerEnum = repos.getCurrentLoggers();
        HashMap<String, String> files = new HashMap<String, String>();
        HashMap fileNames = new HashMap();
        appenders = new HashMap();
        while (loggerEnum.hasMoreElements()) {
            Logger appLogger = (Logger)loggerEnum.nextElement();
            Enumeration appenderEnum = appLogger.getAllAppenders();
            while (appenderEnum.hasMoreElements()) {
                Appender appender = (Appender)appenderEnum.nextElement();
                if (!(appender instanceof FileAppender)) continue;
                String name = appender.getName();
                String tempName = ((FileAppender)appender).getFile();
                tempName = tempName.substring(tempName.lastIndexOf(System.getProperty("file.separator")) + 1);
                if (name == null) {
                    name = tempName;
                    appender.setName(name);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("AppenderName " + name));
                }
                appenders.put(name, appender);
                files.put(name, tempName);
            }
        }
        context.put("appenders", appenders.values());
        context.put("files", files);
    }

    public void doUpdate(RunData data, Context context) {
        try {
            String fileName = data.getParameters().getString("selectedfile");
            logger.debug((Object)("selectedfile: " + fileName));
            if (fileName != null) {
                String content = this.readFile(fileName);
                context.put("logfile", (Object)content);
            } else {
                context.put("logfile", null);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in viewing logfile: ", (Throwable)ex);
        }
    }

    private String readFile(String filename) {
        StringBuffer buf = new StringBuffer("");
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while ((line = in.readLine()) != null) {
                buf.append(line + "\n");
            }
            in.close();
        }
        catch (IOException ioe) {
            logger.error((Object)("Error reading file " + filename), (Throwable)ioe);
        }
        return buf.toString();
    }
}

