/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.QueryLocator;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.portal.portlets.browser.DatabaseBrowserIterator;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.PortletConfigState;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.RESyntaxException;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class PsmlBrowseAction
extends VelocityPortletAction {
    protected static final String PSML_REFRESH_FLAG = "psmlRefreshFlag";
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    protected static final String PROFILE_ITERATOR = "profileIterator";
    protected static final String PAGE_SIZE = "page-size";
    protected static final String CUSTOMIZE_TEMPLATE = "customize-template";
    private static final String PEID = "js_peid";
    public static final String FILTER_VALUE = "filter_value";
    public static final String FILTER_REGEXP = "filter_regexp";
    public static final String FILTER_TYPE = "filter_type";
    public static final String FILTER_TYPE_USER = "filter_type_user";
    public static final String FILTER_TYPE_ROLE = "filter_type_role";
    public static final String FILTER_TYPE_GROUP = "filter_type_group";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(PsmlBrowseAction.class.getName());

    protected void buildConfigureContext(VelocityPortlet portlet, Context context, RunData rundata) {
        try {
            super.buildConfigureContext(portlet, context, rundata);
        }
        catch (Exception ex) {
            logger.error("Exception", ex);
        }
        context.put(PAGE_SIZE, (Object)PortletConfigState.getParameter(portlet, rundata, PAGE_SIZE, "20"));
        this.setTemplate(rundata, PortletConfigState.getParameter(portlet, rundata, CUSTOMIZE_TEMPLATE, null));
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        int start = rundata.getParameters().getInt("start", 0);
        if (start < 0) {
            start = 0;
        }
        String pageSize = PortletConfigState.getParameter(portlet, rundata, PAGE_SIZE, "20");
        int size = Integer.parseInt(pageSize);
        int next = start + size + 1;
        int prev = start - size - 1;
        boolean refreshFlag = rundata.getUser().getTemp(PSML_REFRESH_FLAG, (Object)FALSE).equals(TRUE);
        rundata.getUser().setTemp(PSML_REFRESH_FLAG, (Object)FALSE);
        DatabaseBrowserIterator windowIterator = (DatabaseBrowserIterator)PortletSessionState.getAttribute(portlet, rundata, PROFILE_ITERATOR);
        if (windowIterator == null || refreshFlag) {
            int index = 0;
            QueryLocator ql = new QueryLocator(15);
            ArrayList<Profile> entries = new ArrayList<Profile>();
            Iterator i = Profiler.query(ql);
            String filterValue = rundata.getParameters().getString(FILTER_VALUE);
            if (filterValue != null && !filterValue.trim().equalsIgnoreCase("")) {
                String filterType = rundata.getParameters().getString(FILTER_TYPE, FILTER_TYPE_USER);
                boolean useRE = rundata.getParameters().getBoolean(FILTER_REGEXP);
                RE r = null;
                RECompiler rc = null;
                if (useRE) {
                    try {
                        rc = new RECompiler();
                        r = new RE();
                        r.setProgram(rc.compile(filterValue));
                    }
                    catch (RESyntaxException rex) {
                        logger.warn("PsmlBrowseAction: error processing regular expression [" + filterValue + "]: " + rex.toString());
                    }
                }
                try {
                    while (i.hasNext()) {
                        Profile profile = (Profile)i.next();
                        String compareValue = null;
                        if (filterType.equals(FILTER_TYPE_USER)) {
                            compareValue = profile.getUserName();
                        } else if (filterType.equals(FILTER_TYPE_ROLE)) {
                            compareValue = profile.getRoleName();
                        } else if (filterType.equals(FILTER_TYPE_GROUP)) {
                            compareValue = profile.getGroupName();
                        }
                        if (compareValue == null) continue;
                        if (useRE && r.match(compareValue)) {
                            entries.add(profile);
                            continue;
                        }
                        if (!compareValue.startsWith(filterValue)) continue;
                        entries.add(profile);
                    }
                }
                catch (Exception e) {
                    logger.error("Exception", e);
                }
            } else {
                while (i.hasNext()) {
                    Profile profile = (Profile)i.next();
                    entries.add(profile);
                    ++index;
                }
            }
            ArrayList<String> entryType = new ArrayList<String>();
            entryType.add("Profile");
            windowIterator = new DatabaseBrowserIterator(entries, entryType, entryType, size);
            PortletSessionState.setAttribute(portlet, rundata, PROFILE_ITERATOR, (Object)windowIterator);
        } else {
            windowIterator.setTop(start);
        }
        if (windowIterator != null) {
            context.put("psml", (Object)windowIterator);
            if (start > 0) {
                context.put("prev", (Object)String.valueOf(prev + 1));
            }
            if (next <= windowIterator.getResultSetSize()) {
                context.put("next", (Object)String.valueOf(next - 1));
            }
        } else {
            logger.error("No Psml entries Found");
        }
    }

    public void doUpdate(RunData rundata, Context context) {
        String pageSize = null;
        VelocityPortlet portlet = (VelocityPortlet)context.get("portlet");
        if (portlet != null) {
            String peid = portlet.getID();
            if (peid != null && peid.equals(rundata.getParameters().getString(PEID))) {
                pageSize = rundata.getParameters().getString(PAGE_SIZE);
            }
            if (pageSize != null) {
                PortletConfigState.setInstanceParameter(portlet, rundata, PAGE_SIZE, pageSize);
                PortletSessionState.clearAttribute(portlet, rundata, PROFILE_ITERATOR);
            }
        }
        this.buildNormalContext(portlet, context, rundata);
    }

    public void doRefresh(RunData rundata, Context context) {
        VelocityPortlet portlet = (VelocityPortlet)context.get("portlet");
        PortletSessionState.clearAttribute(portlet, rundata, PROFILE_ITERATOR);
        rundata.getParameters().remove(FILTER_VALUE);
        this.buildNormalContext(portlet, context, rundata);
    }

    public void doFilter(RunData rundata, Context context) {
        VelocityPortlet portlet = (VelocityPortlet)context.get("portlet");
        PortletSessionState.clearAttribute(portlet, rundata, PROFILE_ITERATOR);
        this.buildNormalContext(portlet, context, rundata);
    }
}

