/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang.SerializationUtils;
import org.apache.jetspeed.modules.actions.portlets.GenericMVCAction;
import org.apache.jetspeed.modules.actions.portlets.security.SecurityConstants;
import org.apache.jetspeed.om.profile.BasePSMLDocument;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.profile.QueryLocator;
import org.apache.jetspeed.om.registry.Parameter;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.registry.Registry;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.portlets.browser.DatabaseBrowserIterator;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.jetspeed.util.PortletConfigState;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.jetspeed.util.PortletUtils;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.turbine.util.security.EntityExistsException;
import org.apache.velocity.context.Context;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.InputSource;

public class PsmlManagerAction
extends GenericMVCAction {
    public static final String CACHED_PSML = "PsmlManagerAction.cached.psml";
    protected static final String PSML_REFRESH_FLAG = "psmlRefreshFlag";
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    protected static final String PROFILE_ITERATOR = "profileIterator";
    protected static final String LAST_SEARCH_TYPE = "lastSearchType";
    protected static final String LAST_SEARCH_VALUE = "lastSearchValue";
    protected static final String PAGE_SIZE = "page-size";
    protected static final String DEFAULT_SEARCH = "default-search";
    protected static final String CUSTOMIZE_TEMPLATE = "customize-template";
    private static final String PEID = "js_peid";
    public static final String FILTER_VALUE = "filter_value";
    public static final String FILTER_REGEXP = "filter_regexp";
    public static final String FILTER_TYPE = "filter_type";
    public static final String FILTER_TYPE_USER = "filter_type_user";
    public static final String FILTER_TYPE_ROLE = "filter_type_role";
    public static final String FILTER_TYPE_GROUP = "filter_type_group";
    private static Hashtable queryModes = new Hashtable();
    protected static final String CATEGORY_NAME = "categoryName";
    protected static final String CATEGORY_VALUE = "categoryValue";
    protected static final String COPY_FROM = "copyFrom";
    protected static final String COPY_TO = "copyTo";
    protected static final String TEMP_LOCATOR = "tempLocator";
    protected static final String PSML_UPDATE_PANE = "PsmlForm";
    private static final JetspeedLogger logger;

    protected void buildConfigureContext(Portlet portlet, Context context, RunData rundata) {
        try {
            super.buildConfigureContext(portlet, context, rundata);
        }
        catch (Exception ex) {
            logger.error("Exception", ex);
        }
        context.put(PAGE_SIZE, (Object)PortletConfigState.getParameter(portlet, rundata, PAGE_SIZE, "20"));
        this.setTemplate(rundata, PortletConfigState.getParameter(portlet, rundata, CUSTOMIZE_TEMPLATE, null));
    }

    protected void buildNormalContext(Portlet portlet, Context context, RunData rundata) {
        PortletEntry entry = (PortletEntry)org.apache.jetspeed.services.Registry.getEntry(org.apache.jetspeed.services.Registry.PORTLET, portlet.getName());
        context.put("can-search", (Object)this.canPerformAction(rundata, entry, entry.getParameter("can-search")));
        context.put("can-clone", (Object)this.canPerformAction(rundata, entry, entry.getParameter("can-clone")));
        context.put("can-import", (Object)this.canPerformAction(rundata, entry, entry.getParameter("can-import")));
        context.put("can-export", (Object)this.canPerformAction(rundata, entry, entry.getParameter("can-export")));
        context.put("can-import-all", (Object)this.canPerformAction(rundata, entry, entry.getParameter("can-import-all")));
        context.put("can-export-all", (Object)this.canPerformAction(rundata, entry, entry.getParameter("can-export-all")));
        context.put("can-add", (Object)this.canPerformAction(rundata, entry, entry.getParameter("can-add")));
        context.put("can-remove", (Object)this.canPerformAction(rundata, entry, entry.getParameter("can-remove")));
        String mode = rundata.getParameters().getString("mode", "browse");
        if (mode.equals("browse")) {
            this.setTemplate(rundata, PortletConfigState.getParameter(portlet, rundata, "template", "browser-psml"));
            this.buildBrowseNormalContext(portlet, context, rundata);
        } else {
            this.setTemplate(rundata, PortletConfigState.getParameter(portlet, rundata, "detail-template", "psml-form"));
            this.buildDetailNormalContext(portlet, context, rundata);
        }
    }

    private void buildBrowseNormalContext(Portlet portlet, Context context, RunData rundata) {
        context.put("queryModes", (Object)queryModes);
        int start = rundata.getParameters().getInt("start", 0);
        if (start < 0) {
            start = 0;
        }
        String pageSize = PortletConfigState.getParameter(portlet, rundata, PAGE_SIZE, "20");
        int size = Integer.parseInt(pageSize);
        int next = start + size + 1;
        int prev = start - size - 1;
        boolean refreshFlag = this.getRefreshPsmlFlag(rundata);
        String defaultSearch = PortletConfigState.getParameter(portlet, rundata, DEFAULT_SEARCH, TRUE);
        DatabaseBrowserIterator windowIterator = (DatabaseBrowserIterator)PortletSessionState.getAttribute(portlet, rundata, PROFILE_ITERATOR);
        if (refreshFlag) {
            this.setRefreshPsmlFlag(rundata, FALSE);
            PortletSessionState.clearAttribute(portlet, rundata, PROFILE_ITERATOR);
            Integer type = (Integer)PortletSessionState.getAttribute(portlet, rundata, LAST_SEARCH_TYPE);
            String value = (String)PortletSessionState.getAttribute(portlet, rundata, LAST_SEARCH_VALUE);
            if (type != null && value != null) {
                windowIterator = this.performSearch(rundata, portlet, type, value);
            }
        } else if (windowIterator != null) {
            windowIterator.setTop(start);
        } else if (defaultSearch != null && defaultSearch.equals(TRUE)) {
            windowIterator = this.performSearch(rundata, portlet, 1, rundata.getUser().getUserName());
        }
        if (windowIterator != null) {
            context.put("psml", (Object)windowIterator);
            if (start > 0) {
                context.put("prev", (Object)String.valueOf(prev + 1));
            }
            if (next <= windowIterator.getResultSetSize()) {
                context.put("next", (Object)String.valueOf(next - 1));
            }
        }
    }

    private String canPerformAction(RunData rundata, PortletEntry entry, Parameter actionParam) {
        String result = TRUE;
        if (actionParam != null && entry != null) {
            PortalResource portalResource = new PortalResource(entry, actionParam);
            result = new Boolean(JetspeedSecurity.checkPermission((JetspeedUser)rundata.getUser(), portalResource, "customize")).toString();
        }
        return result;
    }

    public void doUpdate(RunData rundata, Context context) {
        String pageSize = null;
        Portlet portlet = (Portlet)context.get("portlet");
        if (portlet != null) {
            String peid = portlet.getID();
            if (peid != null && peid.equals(rundata.getParameters().getString(PEID))) {
                pageSize = rundata.getParameters().getString(PAGE_SIZE);
            }
            if (pageSize != null) {
                PortletConfigState.setInstanceParameter(portlet, rundata, PAGE_SIZE, pageSize);
                PortletSessionState.clearAttribute(portlet, rundata, PROFILE_ITERATOR);
            }
        }
        this.buildNormalContext(portlet, context, rundata);
    }

    public void doRefresh(RunData rundata, Context context) {
        Portlet portlet = (Portlet)context.get("portlet");
        PortletSessionState.clearAttribute(portlet, rundata, PROFILE_ITERATOR);
        PortletSessionState.clearAttribute(portlet, rundata, LAST_SEARCH_TYPE);
        PortletSessionState.clearAttribute(portlet, rundata, LAST_SEARCH_VALUE);
        rundata.getParameters().remove(FILTER_VALUE);
        this.buildNormalContext(portlet, context, rundata);
    }

    public void doFilter(RunData rundata, Context context) {
        int filterType = rundata.getParameters().getInt(FILTER_TYPE, 15);
        String filterValue = rundata.getParameters().getString(FILTER_VALUE, null);
        Portlet portlet = (Portlet)context.get("portlet");
        this.performSearch(rundata, portlet, filterType, filterValue);
        this.buildNormalContext(portlet, context, rundata);
    }

    private DatabaseBrowserIterator performSearch(RunData rundata, Portlet portlet, int type, String value) {
        QueryLocator ql = new QueryLocator(type);
        if (value != null) {
            switch (type) {
                case 1: {
                    try {
                        ql.setUser(JetspeedSecurity.getUser(value));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                case 2: {
                    try {
                        ql.setRole(JetspeedSecurity.getRole(value));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                case 4: {
                    try {
                        ql.setGroup(JetspeedSecurity.getGroup(value));
                        break;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        ArrayList<Profile> entries = new ArrayList<Profile>();
        Iterator i = Profiler.query(ql);
        try {
            while (i.hasNext()) {
                Profile profile = (Profile)i.next();
                if (!PortletUtils.canAccessProfile(rundata, profile)) continue;
                entries.add(profile);
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
        ArrayList<String> entryType = new ArrayList<String>();
        entryType.add("Profile");
        int size = Integer.parseInt(PortletConfigState.getParameter(portlet, rundata, PAGE_SIZE, "20"));
        DatabaseBrowserIterator windowIterator = new DatabaseBrowserIterator(entries, entryType, entryType, size);
        PortletSessionState.clearAttribute(portlet, rundata, PROFILE_ITERATOR);
        PortletSessionState.setAttribute(portlet, rundata, PROFILE_ITERATOR, (Object)windowIterator);
        PortletSessionState.setAttribute(portlet, rundata, LAST_SEARCH_TYPE, (Object)new Integer(type));
        PortletSessionState.setAttribute(portlet, rundata, LAST_SEARCH_VALUE, (Object)value);
        return windowIterator;
    }

    private void buildDetailNormalContext(Portlet portlet, Context context, RunData rundata) {
        try {
            String root;
            ResourceService serviceConf;
            String categoryValue;
            String categoryName;
            Profile profile;
            ProfileLocator tmpLocator;
            Registry mediaTypes;
            String msgid = rundata.getParameters().getString("msgid");
            if (msgid != null) {
                ProfileLocator locator;
                int id = Integer.parseInt(msgid);
                if (id < SecurityConstants.MESSAGES.length) {
                    context.put("msg", (Object)SecurityConstants.MESSAGES[id]);
                }
                if ((locator = (ProfileLocator)rundata.getUser().getTemp(TEMP_LOCATOR)) != null) {
                    context.put("profile", (Object)Profiler.createProfile(locator));
                }
            }
            String mode = rundata.getParameters().getString("mode");
            context.put("mode", (Object)mode);
            String path = rundata.getParameters().getString("entityid");
            if (mode != null && mode.equals("delete")) {
                ProfileLocator locator = Profiler.createLocator();
                locator.createFromPath(path);
                Profile profile2 = Profiler.getProfile(locator);
                if (profile2 != null) {
                    rundata.getUser().setTemp(TEMP_LOCATOR, (Object)locator);
                    context.put("profile", (Object)profile2);
                } else {
                    logger.error("Profile for Path:" + path + " Not Found!");
                }
            }
            if (mode != null && mode.equals("insert")) {
                mediaTypes = org.apache.jetspeed.services.Registry.get(org.apache.jetspeed.services.Registry.MEDIA_TYPE);
                context.put("mediaTypes", (Object)mediaTypes.listEntryNames());
                JetspeedRunData jdata = (JetspeedRunData)rundata;
                context.put("defMediaType", (Object)jdata.getCapability().getPreferredMediaType());
                if (msgid == null) {
                    if (((String)context.get("can-clone")).equals(FALSE)) {
                        context.put(CATEGORY_NAME, (Object)"user");
                        context.put(CATEGORY_VALUE, (Object)rundata.getUser().getUserName());
                        context.put(COPY_FROM, (Object)"none");
                        context.put("title", (Object)"My Page");
                    } else if (path == null) {
                        context.put(CATEGORY_NAME, (Object)"user");
                        context.put(CATEGORY_VALUE, (Object)"anon");
                        context.put(COPY_FROM, (Object)"user/anon/media-type/html/page/default.psml");
                    } else {
                        tmpLocator = Profiler.createLocator();
                        tmpLocator.createFromPath(path);
                        profile = Profiler.getProfile(tmpLocator);
                        if (profile != null) {
                            rundata.getUser().setTemp(TEMP_LOCATOR, (Object)tmpLocator);
                            context.put("profile", (Object)profile);
                            context.put("title", (Object)profile.getRootSet().getTitle());
                        }
                        categoryName = "group";
                        categoryValue = tmpLocator.getGroupName();
                        if (categoryValue == null) {
                            categoryName = "role";
                            categoryValue = tmpLocator.getRoleName();
                            if (categoryValue == null) {
                                categoryName = "user";
                                categoryValue = tmpLocator.getUserName();
                                if (categoryValue == null) {
                                    categoryName = "user";
                                    categoryValue = "anon";
                                }
                            }
                        }
                        context.put(CATEGORY_NAME, (Object)categoryName);
                        context.put(CATEGORY_VALUE, (Object)categoryValue);
                        context.put(COPY_FROM, (Object)path);
                    }
                } else {
                    context.put(CATEGORY_NAME, rundata.getUser().getTemp(CATEGORY_NAME));
                    context.put(CATEGORY_VALUE, rundata.getUser().getTemp(CATEGORY_VALUE));
                    context.put(COPY_FROM, rundata.getUser().getTemp(COPY_FROM));
                }
            }
            if (mode != null && mode.equals("export")) {
                if (msgid == null) {
                    String tmpPath = JetspeedResources.getString("temp.directory", "/tmp");
                    String exportPath = JetspeedResources.getString("psml.export.default.path", TurbineServlet.getRealPath((String)tmpPath));
                    if (path == null) {
                        context.put(COPY_TO, (Object)exportPath);
                        context.put(COPY_FROM, (Object)("user" + File.separator + "anon" + File.separator + "media-type" + File.separator + "html" + File.separator + "page" + File.separator + "default.psml"));
                    } else {
                        tmpLocator = Profiler.createLocator();
                        tmpLocator.createFromPath(path);
                        profile = Profiler.getProfile(tmpLocator);
                        if (profile != null) {
                            rundata.getUser().setTemp(TEMP_LOCATOR, (Object)tmpLocator);
                            context.put("profile", (Object)profile);
                        }
                        categoryName = "group";
                        categoryValue = tmpLocator.getGroupName();
                        if (categoryValue == null) {
                            categoryName = "role";
                            categoryValue = tmpLocator.getRoleName();
                            if (categoryValue == null) {
                                categoryName = "user";
                                categoryValue = tmpLocator.getUserName();
                                if (categoryValue == null) {
                                    categoryName = "user";
                                    categoryValue = "anon";
                                }
                            }
                        }
                        context.put(COPY_TO, (Object)(exportPath + File.separator + tmpLocator.getName()));
                        context.put(COPY_FROM, (Object)path);
                    }
                } else {
                    context.put(COPY_TO, rundata.getUser().getTemp(COPY_TO));
                    context.put(COPY_FROM, rundata.getUser().getTemp(COPY_FROM));
                }
            }
            if (mode != null && mode.equals("export_all")) {
                if (msgid == null) {
                    serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("PsmlManager");
                    root = serviceConf.getString("root", "/WEB-INF/psml");
                    context.put(COPY_TO, (Object)TurbineServlet.getRealPath((String)root));
                } else {
                    context.put(COPY_TO, rundata.getUser().getTemp(COPY_TO));
                }
            }
            if (mode != null && mode.equals("import")) {
                mediaTypes = org.apache.jetspeed.services.Registry.get(org.apache.jetspeed.services.Registry.MEDIA_TYPE);
                context.put("mediaTypes", (Object)mediaTypes.listEntryNames());
                if (msgid == null) {
                    ResourceService serviceConf2 = ((TurbineServices)TurbineServices.getInstance()).getResources("PsmlManager");
                    String root2 = serviceConf2.getString("root", "/WEB-INF/psml");
                    root2 = TurbineServlet.getRealPath((String)root2);
                    if (path == null) {
                        context.put(CATEGORY_NAME, (Object)"user");
                        context.put(CATEGORY_VALUE, (Object)"anon");
                        context.put(COPY_FROM, (Object)(root2 + File.separator + "user" + File.separator + "anon" + File.separator + "media-type" + File.separator + "html" + File.separator + "page" + File.separator + "default.psml"));
                    } else {
                        ProfileLocator tmpLocator2 = Profiler.createLocator();
                        tmpLocator2.createFromPath(path);
                        Profile profile3 = Profiler.getProfile(tmpLocator2);
                        if (profile3 != null) {
                            rundata.getUser().setTemp(TEMP_LOCATOR, (Object)tmpLocator2);
                            context.put("profile", (Object)profile3);
                        }
                        String categoryName2 = "group";
                        String categoryValue2 = tmpLocator2.getGroupName();
                        if (categoryValue2 == null) {
                            categoryName2 = "role";
                            categoryValue2 = tmpLocator2.getRoleName();
                            if (categoryValue2 == null) {
                                categoryName2 = "user";
                                categoryValue2 = tmpLocator2.getUserName();
                                if (categoryValue2 == null) {
                                    categoryName2 = "user";
                                    categoryValue2 = "anon";
                                }
                            }
                        }
                        context.put(CATEGORY_NAME, (Object)categoryName2);
                        context.put(CATEGORY_VALUE, (Object)categoryValue2);
                        String filePath = this.mapLocatorToFile(tmpLocator2);
                        context.put(COPY_FROM, (Object)(root2 + File.separator + filePath.toString()));
                    }
                } else {
                    context.put(CATEGORY_NAME, rundata.getUser().getTemp(CATEGORY_NAME));
                    context.put(CATEGORY_VALUE, rundata.getUser().getTemp(CATEGORY_VALUE));
                    context.put(COPY_FROM, rundata.getUser().getTemp(COPY_FROM));
                }
            }
            if (mode != null && mode.equals("import_all")) {
                if (msgid == null) {
                    serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("PsmlManager");
                    root = serviceConf.getString("root", "/WEB-INF/psml");
                    context.put(COPY_FROM, (Object)TurbineServlet.getRealPath((String)root));
                } else {
                    context.put(COPY_FROM, rundata.getUser().getTemp(COPY_FROM));
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
            rundata.setMessage("Error in PsmlUpdateAction: " + e.toString());
            rundata.setStackTrace(StringUtils.stackTrace((Throwable)e), (Throwable)e);
            rundata.setScreenTemplate(JetspeedResources.getString("template.error", "Error"));
        }
    }

    public void doInsert(RunData rundata, Context context) throws Exception {
        Profile profile = null;
        ProfileLocator locator = null;
        String categoryName = null;
        String categoryValue = null;
        String copyFrom = null;
        String name = null;
        String title = null;
        try {
            categoryName = rundata.getParameters().getString("CategoryName");
            categoryValue = rundata.getParameters().getString("CategoryValue");
            copyFrom = rundata.getParameters().getString("CopyFrom");
            name = rundata.getParameters().getString("name");
            title = rundata.getParameters().getString("title");
            locator = Profiler.createLocator();
            if (categoryName.equalsIgnoreCase("group")) {
                locator.setGroupByName(categoryValue);
            } else if (categoryName.equalsIgnoreCase("role")) {
                locator.setRoleByName(categoryValue);
            } else if (categoryName.equalsIgnoreCase("user")) {
                locator.setUser(JetspeedSecurity.getUser(categoryValue));
            } else {
                locator.setAnonymous(true);
            }
            String tempVar = rundata.getParameters().getString("MediaType");
            if (tempVar != null && tempVar.trim().length() > 0) {
                locator.setMediaType(tempVar);
            }
            if ((tempVar = rundata.getParameters().getString("Language")) != null && tempVar.trim().length() > 0) {
                locator.setLanguage(tempVar);
            }
            if ((tempVar = rundata.getParameters().getString("Country")) != null && tempVar.trim().length() > 0) {
                locator.setCountry(tempVar);
            }
            if (!name.endsWith(".psml")) {
                name = name + ".psml";
            }
            locator.setName(name);
            if (PsmlManager.getDocument(locator) != null) {
                throw new EntityExistsException("Profile:" + locator.getPath() + " Already Exists!");
            }
            if (name == null || name.trim().length() == 0) {
                JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
                DynamicURI duri = link.addPathInfo("mode", "insert").addPathInfo("msgid", 2);
                JetspeedLinkFactory.putInstance(link);
                rundata.setRedirectURI(duri.toString());
                if (locator != null) {
                    rundata.getUser().setTemp(TEMP_LOCATOR, (Object)locator);
                }
                if (categoryName != null) {
                    rundata.getUser().setTemp(CATEGORY_NAME, (Object)categoryName);
                }
                if (categoryValue != null) {
                    rundata.getUser().setTemp(CATEGORY_VALUE, (Object)categoryValue);
                }
                if (copyFrom != null) {
                    rundata.getUser().setTemp(COPY_FROM, (Object)copyFrom);
                }
                return;
            }
            Profile baseProfile = null;
            if (copyFrom != null && !copyFrom.equals("none")) {
                ProfileLocator baseLocator = Profiler.createLocator();
                baseLocator.createFromPath(copyFrom);
                baseProfile = Profiler.getProfile(baseLocator);
            }
            if (copyFrom.equals("none")) {
                profile = Profiler.createProfile(locator, null);
                profile.getDocument().getPortlets().setTitle(title);
                profile.store();
                this.setRefreshPsmlFlag(rundata, TRUE);
            } else if (baseProfile != null) {
                PSMLDocument doc = baseProfile.getDocument();
                if (doc != null) {
                    Portlets portlets = doc.getPortlets();
                    Portlets clonedPortlets = (Portlets)SerializationUtils.clone((Serializable)portlets);
                    PortletUtils.regenerateIds(clonedPortlets);
                    profile = Profiler.createProfile(locator, clonedPortlets);
                } else {
                    profile = Profiler.createProfile(locator, null);
                }
                this.setRefreshPsmlFlag(rundata, TRUE);
            } else {
                logger.error("Profile listed in Copy From Not Found!");
            }
            this.goBackToBrowser(rundata);
        }
        catch (EntityExistsException e) {
            logger.error("Exception", e);
            JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
            DynamicURI duri = link.addPathInfo("mode", "insert").addPathInfo("msgid", 3);
            JetspeedLinkFactory.putInstance(link);
            rundata.setRedirectURI(duri.toString());
        }
        catch (Exception e) {
            logger.error("Exception", e);
            JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
            DynamicURI duri = link.addPathInfo("mode", "insert").addPathInfo("msgid", 0);
            JetspeedLinkFactory.putInstance(link);
            rundata.setRedirectURI(duri.toString());
        }
        if (locator != null) {
            rundata.getUser().setTemp(TEMP_LOCATOR, (Object)locator);
        }
        if (categoryName != null) {
            rundata.getUser().setTemp(CATEGORY_NAME, (Object)categoryName);
        }
        if (categoryValue != null) {
            rundata.getUser().setTemp(CATEGORY_VALUE, (Object)categoryValue);
        }
        if (copyFrom != null) {
            rundata.getUser().setTemp(COPY_FROM, (Object)copyFrom);
        }
    }

    public void doDelete(RunData rundata, Context context) throws Exception {
        try {
            ProfileLocator locator = (ProfileLocator)rundata.getUser().getTemp(TEMP_LOCATOR);
            if (locator != null) {
                Profiler.removeProfile(locator);
                this.setRefreshPsmlFlag(rundata, TRUE);
            } else {
                logger.error("ProfileLocator not found!");
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
            JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
            DynamicURI duri = link.addPathInfo("mode", "delete").addPathInfo("msgid", 1);
            JetspeedLinkFactory.putInstance(link);
            rundata.setRedirectURI(duri.toString());
        }
    }

    private void setRefreshPsmlFlag(RunData rundata, String value) {
        rundata.getUser().setTemp(PSML_REFRESH_FLAG, (Object)value);
        if (value.equals(TRUE)) {
            rundata.getUser().removeTemp(CACHED_PSML);
        }
    }

    private boolean getRefreshPsmlFlag(RunData rundata) {
        return rundata.getUser().getTemp(PSML_REFRESH_FLAG, (Object)FALSE).equals(TRUE);
    }

    public void doExport(RunData rundata, Context context) throws Exception {
        Object profile = null;
        Object locator = null;
        String copyTo = null;
        String copyFrom = null;
        try {
            copyFrom = rundata.getParameters().getString("CopyFrom");
            copyTo = rundata.getParameters().getString("CopyTo");
            ProfileLocator baseLocator = Profiler.createLocator();
            baseLocator.createFromPath(copyFrom);
            Profile baseProfile = Profiler.getProfile(baseLocator);
            if (baseProfile != null) {
                PSMLDocument doc = baseProfile.getDocument();
                if (doc != null) {
                    if (!this.saveDocument(copyTo, doc)) {
                        throw new Exception("Failed to save PSML document");
                    }
                    rundata.addMessage("Profile [" + copyFrom + "] has been saved to disk in [" + copyTo + "]<br>");
                }
            } else {
                logger.error("Profile listed in Copy From Not Found!");
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
            JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
            DynamicURI duri = link.addPathInfo("mode", "export").addPathInfo("msgid", 0);
            JetspeedLinkFactory.putInstance(link);
            rundata.setRedirectURI(duri.toString());
        }
        if (copyTo != null) {
            rundata.getUser().setTemp(COPY_TO, (Object)copyTo);
        }
        if (copyFrom != null) {
            rundata.getUser().setTemp(COPY_FROM, (Object)copyFrom);
        }
    }

    public void doExportall(RunData rundata, Context context) throws Exception {
        String copyTo = null;
        logger.info("PsmlUpdateAction: Starting export all operation");
        try {
            copyTo = rundata.getParameters().getString("CopyTo");
            Iterator i = Profiler.query(new QueryLocator(15));
            while (i.hasNext()) {
                Profile profile = (Profile)i.next();
                PSMLDocument doc = profile.getDocument();
                if (doc == null) continue;
                StringBuffer copyToFile = new StringBuffer(copyTo);
                copyToFile.append(File.separator);
                if (profile.getGroupName() != null) {
                    copyToFile.append("group");
                    copyToFile.append(File.separator);
                    copyToFile.append(profile.getGroupName());
                    copyToFile.append(File.separator);
                } else if (profile.getRoleName() != null) {
                    copyToFile.append("role");
                    copyToFile.append(File.separator);
                    copyToFile.append(profile.getRoleName());
                    copyToFile.append(File.separator);
                } else if (profile.getUserName() != null) {
                    copyToFile.append("user");
                    copyToFile.append(File.separator);
                    copyToFile.append(profile.getUserName());
                    copyToFile.append(File.separator);
                }
                if (profile.getMediaType() != null) {
                    copyToFile.append(profile.getMediaType());
                    copyToFile.append(File.separator);
                }
                if (profile.getLanguage() != null) {
                    copyToFile.append(profile.getLanguage());
                    copyToFile.append(File.separator);
                }
                if (profile.getCountry() != null) {
                    copyToFile.append(profile.getCountry());
                    copyToFile.append(File.separator);
                }
                copyToFile.append(profile.getName());
                if (!this.saveDocument(copyToFile.toString(), doc)) {
                    logger.error("Failed to save PSML document for [" + profile.getPath());
                    continue;
                }
                String msg = "Profile [" + profile.getPath() + "] has been saved to disk in [" + copyToFile.toString() + "]<br>";
                logger.info(msg);
                rundata.addMessage(msg);
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
            JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
            DynamicURI duri = link.addPathInfo("mode", "export_all").addPathInfo("msgid", 0);
            JetspeedLinkFactory.putInstance(link);
            rundata.setRedirectURI(duri.toString());
        }
        if (copyTo != null) {
            rundata.getUser().setTemp(COPY_TO, (Object)copyTo);
        }
        logger.info("PsmlUpdateAction: Ending export all operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveDocument(String fileOrUrl, PSMLDocument doc) {
        boolean success = false;
        if (doc == null) {
            return false;
        }
        File f = new File(fileOrUrl);
        File d = new File(f.getParent());
        d.mkdirs();
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            OutputFormat format = new OutputFormat();
            format.setIndenting(true);
            format.setIndent(4);
            XMLSerializer serializer = new XMLSerializer((Writer)writer, format);
            Marshaller marshaller = new Marshaller(serializer.asDocumentHandler());
            marshaller.setMapping(this.loadMapping());
            marshaller.marshal((Object)doc.getPortlets());
            success = true;
        }
        catch (MarshalException e) {
            logger.error("PsmlManagerAction: Could not marshal the file " + f.getAbsolutePath(), e);
        }
        catch (MappingException e) {
            logger.error("PsmlManagerAction: Could not marshal the file " + f.getAbsolutePath(), e);
        }
        catch (ValidationException e) {
            logger.error("PsmlManagerAction: document " + f.getAbsolutePath() + " is not valid", e);
        }
        catch (IOException e) {
            logger.error("PsmlManagerAction: Could not save the file " + f.getAbsolutePath(), e);
        }
        catch (Exception e) {
            logger.error("PsmlManagerAction: Error while saving  " + f.getAbsolutePath(), e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {}
        }
        return success;
    }

    private Mapping loadMapping() throws Exception {
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("PsmlManager");
        Mapping mapping = null;
        String mapFile = serviceConf.getString("mapping", "${webappRoot}/WEB-INF/conf/psml-mapping.xml");
        if ((mapFile = TurbineServlet.getRealPath((String)mapFile)) != null) {
            File map = new File(mapFile);
            if (logger.isDebugEnabled()) {
                logger.debug("Loading psml mapping file " + mapFile);
            }
            if (map.exists() && map.isFile() && map.canRead()) {
                try {
                    mapping = new Mapping();
                    InputSource is = new InputSource(new FileReader(map));
                    is.setSystemId(mapFile);
                    mapping.loadMapping(is);
                }
                catch (Exception e) {
                    logger.error("Error in psml mapping creation", e);
                    throw new Exception("Error in mapping");
                }
            } else {
                throw new Exception("PSML Mapping not found or not a file or unreadable: " + mapFile);
            }
        }
        return mapping;
    }

    public void doImport(RunData rundata, Context context) throws Exception {
        Profile profile = null;
        ProfileLocator locator = null;
        String categoryName = null;
        String categoryValue = null;
        String copyFrom = null;
        String name = null;
        try {
            Portlets portlets;
            categoryName = rundata.getParameters().getString("CategoryName");
            categoryValue = rundata.getParameters().getString("CategoryValue");
            copyFrom = rundata.getParameters().getString("CopyFrom");
            name = rundata.getParameters().getString("name");
            locator = Profiler.createLocator();
            if (categoryName.equalsIgnoreCase("group")) {
                locator.setGroupByName(categoryValue);
            } else if (categoryName.equalsIgnoreCase("role")) {
                locator.setRoleByName(categoryValue);
            } else if (categoryName.equalsIgnoreCase("user")) {
                locator.setUser(JetspeedSecurity.getUser(categoryValue));
            } else {
                locator.setAnonymous(true);
            }
            String tempVar = rundata.getParameters().getString("MediaType");
            if (tempVar != null && tempVar.trim().length() > 0) {
                locator.setMediaType(tempVar);
            }
            if ((tempVar = rundata.getParameters().getString("Language")) != null && tempVar.trim().length() > 0) {
                locator.setLanguage(tempVar);
            }
            if ((tempVar = rundata.getParameters().getString("Country")) != null && tempVar.trim().length() > 0) {
                locator.setCountry(tempVar);
            }
            locator.setName(name);
            if (name == null || name.trim().length() == 0) {
                JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
                DynamicURI duri = link.addPathInfo("mode", "import").addPathInfo("msgid", 2);
                JetspeedLinkFactory.putInstance(link);
                rundata.setRedirectURI(duri.toString());
                if (locator != null) {
                    rundata.getUser().setTemp(TEMP_LOCATOR, (Object)locator);
                }
                if (categoryName != null) {
                    rundata.getUser().setTemp(CATEGORY_NAME, (Object)categoryName);
                }
                if (categoryValue != null) {
                    rundata.getUser().setTemp(CATEGORY_VALUE, (Object)categoryValue);
                }
                if (copyFrom != null) {
                    rundata.getUser().setTemp(COPY_FROM, (Object)copyFrom);
                }
                return;
            }
            PSMLDocument doc = this.loadDocument(copyFrom);
            if (doc != null) {
                portlets = doc.getPortlets();
                if (PsmlManager.getDocument(locator) != null) {
                    Profiler.removeProfile(locator);
                }
            } else {
                throw new Exception("Failed to load PSML document from disk");
            }
            profile = Profiler.createProfile(locator, portlets);
            rundata.addMessage("Profile for [" + locator.getPath() + "] has been imported from file [" + copyFrom + "]<br>");
            this.setRefreshPsmlFlag(rundata, TRUE);
            this.goBackToBrowser(rundata);
        }
        catch (Exception e) {
            logger.error("Exception", e);
            JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
            DynamicURI duri = link.addPathInfo("mode", "import").addPathInfo("msgid", 0);
            JetspeedLinkFactory.putInstance(link);
            rundata.setRedirectURI(duri.toString());
        }
        if (locator != null) {
            rundata.getUser().setTemp(TEMP_LOCATOR, (Object)locator);
        }
        if (categoryName != null) {
            rundata.getUser().setTemp(CATEGORY_NAME, (Object)categoryName);
        }
        if (categoryValue != null) {
            rundata.getUser().setTemp(CATEGORY_VALUE, (Object)categoryValue);
        }
        if (copyFrom != null) {
            rundata.getUser().setTemp(COPY_FROM, (Object)copyFrom);
        }
    }

    public void doImportall(RunData rundata, Context context) throws Exception {
        String copyFrom = null;
        try {
            copyFrom = rundata.getParameters().getString("CopyFrom");
            Vector files = new Vector();
            this.collectPsml(files, copyFrom);
            Iterator it = files.iterator();
            while (it.hasNext()) {
                String path = null;
                try {
                    Portlets portlets;
                    String psml = ((File)it.next()).getPath();
                    path = psml.substring(copyFrom.length() + 1);
                    ProfileLocator locator = this.mapFileToLocator(path);
                    PSMLDocument doc = this.loadDocument(psml);
                    if (doc != null) {
                        portlets = doc.getPortlets();
                        if (PsmlManager.getDocument(locator) != null) {
                            Profiler.removeProfile(locator);
                        }
                    } else {
                        throw new Exception("Failed to load PSML document [" + psml + "] from disk");
                    }
                    Portlets clonedPortlets = (Portlets)SerializationUtils.clone((Serializable)portlets);
                    PortletUtils.regenerateIds(clonedPortlets);
                    Profiler.createProfile(locator, clonedPortlets);
                    rundata.addMessage("Profile for [" + locator.getPath() + "] has been imported from file [" + psml + "]<br>");
                    this.setRefreshPsmlFlag(rundata, TRUE);
                }
                catch (Exception ouch) {
                    logger.error("Exception", ouch);
                    rundata.addMessage("ERROR importing file [" + path + "]: " + ouch.toString() + "<br>");
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
            JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
            DynamicURI duri = link.addPathInfo("mode", "import_all").addPathInfo("msgid", 0);
            JetspeedLinkFactory.putInstance(link);
            rundata.setRedirectURI(duri.toString());
        }
        if (copyFrom != null) {
            rundata.getUser().setTemp(COPY_FROM, (Object)copyFrom);
        }
    }

    private void collectPsml(Vector v, String root) {
        File dir = new File(root);
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.collectPsml(v, files[i].getPath());
                continue;
            }
            if (!files[i].isFile() || !files[i].getPath().endsWith(".psml")) continue;
            v.add(files[i]);
        }
    }

    private ProfileLocator mapFileToLocator(String path) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("PsmlUpdateAction.createFromPath: processing path = " + path);
        }
        ProfileLocator result = Profiler.createLocator();
        StringTokenizer tok = new StringTokenizer(path, File.separator);
        Vector<String> tokens = new Vector<String>();
        while (tok.hasMoreTokens()) {
            tokens.add(tok.nextToken());
        }
        if (tokens.size() > 1) {
            String type = (String)tokens.elementAt(0);
            String name = (String)tokens.elementAt(1);
            if (type.equals("user")) {
                result.setUser(JetspeedSecurity.getUser(name));
            } else if (type.equals("group")) {
                result.setGroup(JetspeedSecurity.getGroup(name));
            } else if (type.equals("role")) {
                result.setRole(JetspeedSecurity.getRole(name));
            }
        }
        if (tokens.size() > 0) {
            result.setName((String)tokens.lastElement());
        }
        switch (tokens.size()) {
            case 3: {
                break;
            }
            case 4: {
                result.setMediaType((String)tokens.elementAt(2));
                break;
            }
            case 5: {
                result.setMediaType((String)tokens.elementAt(2));
                result.setLanguage((String)tokens.elementAt(3));
                break;
            }
            case 6: {
                result.setMediaType((String)tokens.elementAt(2));
                result.setLanguage((String)tokens.elementAt(3));
                result.setCountry((String)tokens.elementAt(4));
                break;
            }
            default: {
                throw new Exception("Path must contain 3 to 6 elements: [" + path + "], and the size was: " + tokens.size());
            }
        }
        return result;
    }

    private String mapLocatorToFile(ProfileLocator locator) {
        StringBuffer path = new StringBuffer();
        Role role = locator.getRole();
        Group group = locator.getGroup();
        JetspeedUser user = locator.getUser();
        if (user != null) {
            path.append("user");
            String name = user.getUserName();
            if (null != name && name.length() > 0) {
                path.append(File.separator).append(name);
            }
        } else if (group != null) {
            path.append("group");
            String name = group.getName();
            if (null != name && name.length() > 0) {
                path.append(File.separator).append(name);
            }
        } else if (null != role) {
            path.append("role");
            String name = role.getName();
            if (null != name && name.length() > 0) {
                path.append(File.separator).append(name);
            }
        }
        if (null != locator.getMediaType()) {
            path.append(File.separator).append(locator.getMediaType());
        }
        if (null != locator.getLanguage()) {
            path.append(File.separator).append(locator.getLanguage());
        }
        if (null != locator.getCountry()) {
            path.append(File.separator).append(locator.getCountry());
        }
        if (null != locator.getName()) {
            if (!locator.getName().endsWith(".psml")) {
                path.append(File.separator).append(locator.getName()).append(".psml");
            } else {
                path.append(File.separator).append(locator.getName());
            }
        } else {
            path.append(File.separator).append("default.psml");
        }
        return path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PSMLDocument loadDocument(String fileOrUrl) {
        BasePSMLDocument doc = null;
        if (fileOrUrl != null) {
            File f = null;
            f = new File(fileOrUrl);
            if (!f.exists()) {
                return null;
            }
            doc = new BasePSMLDocument();
            doc.setName(fileOrUrl);
            Portlets portlets = null;
            FileReader reader = null;
            try {
                reader = new FileReader(f);
                Unmarshaller unmarshaller = new Unmarshaller(this.loadMapping());
                portlets = (Portlets)unmarshaller.unmarshal((Reader)reader);
                doc.setPortlets(portlets);
            }
            catch (IOException e) {
                logger.error("PsmlManagerAction: Could not load the file " + f.getAbsolutePath(), e);
            }
            catch (MarshalException e) {
                logger.error("PsmlManagerAction: Could not unmarshal the file " + f.getAbsolutePath(), e);
            }
            catch (MappingException e) {
                logger.error("PsmlManagerAction: Could not unmarshal the file " + f.getAbsolutePath(), e);
            }
            catch (ValidationException e) {
                logger.error("PsmlManagerAction: document " + f.getAbsolutePath() + " is not valid", e);
            }
            catch (Exception e) {
                logger.error("PsmlManagerAction: Error while loading  " + f.getAbsolutePath(), e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return doc;
    }

    private void goBackToBrowser(RunData rundata) throws Exception {
        JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
        rundata.setRedirectURI(link.toString());
        JetspeedLinkFactory.putInstance(link);
    }

    static {
        queryModes.put("All", String.valueOf(15));
        queryModes.put("User", String.valueOf(1));
        queryModes.put("Role", String.valueOf(2));
        queryModes.put("Group", String.valueOf(4));
        logger = JetspeedLogFactoryService.getLogger(PsmlManagerAction.class.getName());
    }
}

