/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import java.util.Hashtable;
import java.util.Iterator;
import org.apache.jetspeed.modules.actions.portlets.RegistryUpdateAction;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.SkinEntry;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class SkinUpdateAction
extends RegistryUpdateAction {
    private static final String PARAMETER = "parameter.";
    private static final String SKIN_UPDATE_PANE = "SkinForm";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(SkinUpdateAction.class.getName());

    public SkinUpdateAction() {
        this.registryEntryName = "skinname";
        this.registry = Registry.SKIN;
        this.pane = SKIN_UPDATE_PANE;
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        super.buildNormalContext(portlet, context, rundata);
        String mode = rundata.getParameters().getString("mode");
        if (mode != null && (mode.equals("delete") || mode.equals("update"))) {
            String skinName = rundata.getParameters().getString("skinname");
            SkinEntry skinEntry = (SkinEntry)Registry.getEntry(Registry.SKIN, skinName);
            context.put("entry", (Object)skinEntry);
        }
    }

    protected void updateRegistryEntry(RunData rundata, RegistryEntry registryEntry) throws Exception {
        super.updateRegistryEntry(rundata, registryEntry);
        this.updateParameters(rundata, (SkinEntry)registryEntry);
    }

    protected void resetForm(RunData rundata) {
        super.resetForm(rundata);
        Object[] keys = rundata.getParameters().getKeys();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                String parameterValue;
                String key = (String)keys[i];
                if (!key.startsWith(PARAMETER) || (parameterValue = rundata.getParameters().getString(key)) == null || parameterValue.length() <= 0) continue;
                rundata.getUser().setTemp(key, (Object)parameterValue);
            }
        }
    }

    private void updateParameters(RunData rundata, SkinEntry skinEntry) {
        Object[] keys = rundata.getParameters().getKeys();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                String parameterValue;
                String key = (String)keys[i];
                if (!key.startsWith(PARAMETER) || (parameterValue = rundata.getParameters().getString(key)) == null || parameterValue.length() <= 0) continue;
                String parameterName = key.substring(PARAMETER.length());
                skinEntry.removeParameter(parameterName);
                skinEntry.addParameter(parameterName, parameterValue);
            }
        }
    }

    protected void clearUserData(RunData rundata) {
        block4: {
            try {
                super.clearUserData(rundata);
                Hashtable tempStorage = rundata.getUser().getTempStorage();
                if (tempStorage != null) {
                    Iterator keyIter = tempStorage.keySet().iterator();
                    while (keyIter.hasNext()) {
                        String key;
                        Object keyObj = keyIter.next();
                        if (!(keyObj instanceof String) || !(key = (String)keyObj).startsWith(PARAMETER)) continue;
                        keyIter.remove();
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("SkinUpdateAction: Failed to clear user data");
            }
        }
    }
}

