/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets.designer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction;
import org.apache.jetspeed.modules.actions.portlets.designer.FileUploader;
import org.apache.jetspeed.modules.actions.portlets.designer.FormatPath;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.upload.FileItem;
import org.apache.velocity.context.Context;

public class HeaderAction
extends VelocityPortletAction {
    private static final JetspeedLogger log = JetspeedLogFactoryService.getLogger(HeaderAction.class.getName());
    private static final String IMAGES_DIRECTORY = "images/designer/";
    private static final String DEFAULT_CSS = "css/default.css";
    private String[] fileTypes = new String[]{"image/jpg", "image/gif", "image/jpeg", "application/x-shockwave-flash", "image/png", "image/x-png"};

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
    }

    public void doUpload(RunData rundata, Context context) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        boolean setLogo = rundata.getParameters().getBoolean("setLogo");
        boolean setBgImage = rundata.getParameters().getBoolean("setBgImage");
        boolean setBgColor = rundata.getParameters().getBoolean("setBgColor");
        boolean setFontFace = rundata.getParameters().getBoolean("setFontFace");
        boolean setFontSize = rundata.getParameters().getBoolean("setFontSize");
        boolean setFontColor = rundata.getParameters().getBoolean("setFontColor");
        boolean setTitle = rundata.getParameters().getBoolean("setTitle");
        FileItem fileLogo = null;
        FileItem fileBgImage = null;
        String bgColor = "";
        String fontFace = "";
        String fontSize = "";
        String fontColor = "";
        String bgImage = "";
        String title = "";
        if (setLogo) {
            fileLogo = rundata.getParameters().getFileItem("imgLogo");
        }
        if (setBgImage) {
            String sampleBg = rundata.getParameters().getString("sampleBgImage").trim();
            if (sampleBg != null && sampleBg.length() != 0) {
                bgImage = IMAGES_DIRECTORY + sampleBg;
            } else {
                fileBgImage = rundata.getParameters().getFileItem("bgImage");
            }
        }
        if (setBgColor) {
            bgColor = rundata.getParameters().getString("bgColor").trim();
        }
        if (setFontFace) {
            fontFace = rundata.getParameters().getString("fontFace").trim();
        }
        if (setFontSize) {
            fontSize = rundata.getParameters().getString("fontSize").trim();
        }
        if (setFontColor) {
            fontColor = rundata.getParameters().getString("fontColor").trim();
        }
        if (setTitle) {
            title = StringEscapeUtils.escapeHtml(rundata.getParameters().getString("portalTitle").trim());
        }
        log.info("fontColor : " + fontColor);
        String message = "";
        try {
            boolean hasFontColor;
            FileUploader fu;
            boolean hasUploaded;
            File f;
            int index2;
            int index;
            String logo = "";
            String slash = System.getProperty("file.separator");
            String imagePath = FormatPath.normalizeDirectoryPath(rundata.getServletContext().getRealPath("/images/designer/"));
            if (fileLogo != null) {
                File file = new File(fileLogo.getFileName());
                logo = file.getName();
                index = logo.lastIndexOf("\\");
                index2 = logo.lastIndexOf("//");
                if (index > 0) {
                    logo = logo.substring(index + 1);
                }
                if (index2 > 0) {
                    logo = logo.substring(index2 + 1);
                }
                if ((f = new File(imagePath + logo)).exists()) {
                    f.delete();
                }
                if (hasUploaded = (fu = new FileUploader()).upload(fileLogo, imagePath, this.fileTypes)) {
                    logo = IMAGES_DIRECTORY + logo;
                } else {
                    context.put("logoStatus", (Object)("Error occurred while uploading " + logo + ". Only gif, jpg, and jpeg image files can be uploaded. "));
                    logo = "";
                }
            }
            if (fileBgImage != null) {
                File file1 = new File(fileBgImage.getFileName());
                bgImage = file1.getName();
                index = bgImage.lastIndexOf("\\");
                index2 = bgImage.lastIndexOf("//");
                if (index > 0) {
                    bgImage = bgImage.substring(index + 1);
                }
                if (index2 > 0) {
                    bgImage = bgImage.substring(index2 + 1);
                }
                if ((f = new File(imagePath + bgImage)).exists()) {
                    f.delete();
                }
                fu = new FileUploader();
                hasUploaded = fu.upload(fileBgImage, imagePath, this.fileTypes);
                log.info("hasUploaded : " + hasUploaded);
                if (hasUploaded) {
                    bgImage = IMAGES_DIRECTORY + bgImage;
                } else {
                    context.put("bgStatus", (Object)("Error while uploading " + bgImage + ". Only gif, jpg, and jpeg image files can be uploaded. "));
                    bgImage = "";
                }
            }
            boolean hasColor = bgColor == null || bgColor.length() < 1;
            boolean hasFontFace = fontFace == null || fontFace.length() < 1;
            boolean hasFontSize = fontSize == null || fontSize.length() < 1;
            boolean bl = hasFontColor = fontColor == null || fontColor.length() < 1;
            if (hasColor) {
                bgColor = "white";
            }
            if (hasFontFace) {
                fontFace = "verdana";
            }
            if (hasFontSize) {
                fontSize = "12";
            }
            if (hasFontColor) {
                fontColor = "black";
            }
            ht.put("logo", logo);
            ht.put("BgImage", bgImage);
            ht.put("BgColor", bgColor);
            ht.put("FontFace", fontFace);
            ht.put("FontSize", fontSize);
            ht.put("FontColor", fontColor);
            ht.put("PortalTitle", title);
            ht.put("SetLogo", String.valueOf(setLogo));
            ht.put("SetBgImage", String.valueOf(setBgImage));
            ht.put("SetBgColor", String.valueOf(setBgColor));
            ht.put("SetFontFace", String.valueOf(setFontFace));
            ht.put("SetFontSize", String.valueOf(setFontSize));
            ht.put("SetFontColor", String.valueOf(setFontColor));
            ht.put("SetTitle", String.valueOf(setTitle));
            this.editHeader(rundata, context, ht);
        }
        catch (Exception ee) {
            message = ee.getMessage();
        }
    }

    public void editHeader(RunData rundata, Context context, Hashtable ht) throws Exception {
        try {
            String logo = (String)ht.get("logo");
            String bgImage = (String)ht.get("BgImage");
            String bgColor = (String)ht.get("BgColor");
            String fontSize = (String)ht.get("FontSize");
            String fontColor = (String)ht.get("FontColor");
            String title = (String)ht.get("PortalTitle");
            boolean setLogo = Boolean.valueOf((String)ht.get("SetLogo"));
            boolean setBgImage = Boolean.valueOf((String)ht.get("SetBgImage"));
            boolean setBgColor = Boolean.valueOf((String)ht.get("SetBgColor"));
            boolean setFontSize = Boolean.valueOf((String)ht.get("SetFontSize"));
            boolean setFontColor = Boolean.valueOf((String)ht.get("SetFontColor"));
            boolean setPortalTitle = Boolean.valueOf((String)ht.get("SetTitle"));
            String DEFAULT_ROOT = File.separator + "WEB-INF" + File.separator + "conf" + File.separator;
            String root = rundata.getServletConfig().getServletContext().getRealPath(DEFAULT_ROOT) + File.separator;
            Properties prop = new Properties();
            prop.clear();
            prop.load(new FileInputStream(root + "JetspeedResources.properties"));
            TurbineResources trProp = (TurbineResources)TurbineResources.getResources((String)(root + "JetspeedResources.properties"));
            boolean counter = false;
            if (setBgImage && !setBgColor && !counter) {
                setBgColor = true;
                bgColor = "FFFFFF";
                counter = true;
            }
            if (!setBgImage && setBgColor && !counter) {
                setBgImage = true;
                bgImage = "";
                counter = true;
            }
            if (setBgImage && setBgColor && !counter) {
                setBgColor = true;
                bgColor = "FFFFFF";
                counter = true;
            }
            if (setLogo) {
                TurbineResources.setProperty((String)"topnav.logo.file", (String)logo);
                prop.setProperty("topnav.logo.file", logo);
            }
            if (setBgImage) {
                TurbineResources.setProperty((String)"topnav.bg.image", (String)bgImage);
                prop.setProperty("topnav.bg.image", bgImage);
            }
            if (setBgColor) {
                TurbineResources.setProperty((String)"topnav.bg.color", (String)bgColor);
                prop.setProperty("topnav.bg.color", bgColor);
            }
            if (setFontSize) {
                TurbineResources.setProperty((String)"topnav.font.size", (String)fontSize);
                prop.setProperty("topnav.font.size", fontSize);
            }
            if (setFontColor) {
                TurbineResources.setProperty((String)"topnav.font.color", (String)fontColor);
                prop.setProperty("topnav.font.color", fontColor);
            }
            if (setPortalTitle) {
                TurbineResources.setProperty((String)"portal.title", (String)title);
                prop.setProperty("portal.title", title);
            }
            FileOutputStream stream = new FileOutputStream(root + "JetspeedResources.properties");
            prop.store(stream, "topnav.logo.file");
            prop.store(stream, "topnav.bg.image");
            prop.store(stream, "topnav.bg.color");
            prop.store(stream, "topnav.font.size");
            prop.store(stream, "topnav.font.color");
            stream.close();
            String logoJR = prop.getProperty("topnav.logo.file");
            String bgImageJR = prop.getProperty("topnav.bg.image");
            String bgColorJR = prop.getProperty("topnav.bg.color");
            String fontSizeJR = prop.getProperty("topnav.font.size");
            String fontColorJR = prop.getProperty("topnav.font.color");
            log.info("new Logo : " + logoJR);
            log.info("new bgImageJR : " + bgImageJR);
            log.info("new bgColorJR : " + bgColorJR);
            log.info("new fontSizeJR : " + fontSizeJR);
            log.info("new fontColorJR : " + fontColorJR);
            prop = null;
            System.gc();
            context.put("settingStatus", (Object)"Successfully changed settings.");
        }
        catch (Exception e) {
            context.put("settingStatus", (Object)"Error occurred while changing settings.");
            log.error(e);
        }
    }

    public void doDefault(RunData rundata, Context context) throws Exception {
        try {
            String logo = "images/designer/jetspeed-logo.gif";
            String bgImage = "";
            String fontSize = "10";
            String title = "Jakarta Jetspeed";
            String DEFAULT_ROOT = File.separator + "WEB-INF" + File.separator + "conf" + File.separator;
            String root = rundata.getServletConfig().getServletContext().getRealPath(DEFAULT_ROOT) + File.separator;
            Properties prop = new Properties();
            prop.load(new FileInputStream(root + "JetspeedResources.properties"));
            prop.clone();
            TurbineResources trProp = (TurbineResources)TurbineResources.getResources((String)(root + "JetspeedResources.properties"));
            TurbineResources.setProperty((String)"portal.title", (String)title);
            prop.setProperty("portal.title", title);
            TurbineResources.setProperty((String)"topnav.logo.file", (String)logo);
            prop.setProperty("topnav.logo.file", logo);
            TurbineResources.setProperty((String)"topnav.bg.image", (String)"");
            prop.setProperty("topnav.bg.image", "");
            TurbineResources.setProperty((String)"topnav.bg.color", (String)"");
            prop.setProperty("topnav.bg.color", "");
            TurbineResources.setProperty((String)"topnav.font.size", (String)"");
            prop.setProperty("topnav.font.size", "");
            TurbineResources.setProperty((String)"topnav.font.color", (String)"");
            prop.setProperty("topnav.font.color", "");
            FileOutputStream stream = new FileOutputStream(root + "JetspeedResources.properties");
            prop.save(stream, "topnav.logo.file");
            prop.save(stream, "portal.title");
            prop.save(stream, "topnav.bg.image");
            prop.save(stream, "topnav.bg.color");
            prop.save(stream, "ptopnav.font.size");
            prop.save(stream, "ptopnav.font.size");
            stream.close();
            context.put("settingStatus", (Object)"Successfully changed to default settings.");
        }
        catch (Exception e) {
            context.put("settingStatus", (Object)"Error occurred while changing to default settings. ");
            log.error(e);
        }
    }
}

