/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets.security;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.jetspeed.modules.actions.portlets.SecureVelocityPortletAction;
import org.apache.jetspeed.modules.actions.portlets.security.SecurityConstants;
import org.apache.jetspeed.om.security.Permission;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class RolePermissionUpdateAction
extends SecureVelocityPortletAction {
    private static final String TEMP_ROLE = "tempRole";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(RolePermissionUpdateAction.class.getName());

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildConfigureContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        try {
            int id;
            Object role = null;
            String mode = rundata.getParameters().getString("mode");
            String entityid = rundata.getParameters().getString("entityid");
            if (entityid == null || entityid.trim().length() == 0) {
                return;
            }
            this.buildRolePermissionContext(portlet, context, rundata, entityid);
            String msgid = rundata.getParameters().getString("msgid");
            if (msgid != null && (id = Integer.parseInt(msgid)) < SecurityConstants.MESSAGES.length) {
                context.put("msg", (Object)SecurityConstants.MESSAGES[id]);
            }
        }
        catch (Exception e) {
            logger.error("Error in Jetspeed Role Permission Security", e);
            rundata.setMessage("Error in Jetspeed Role Permission Security: " + e.toString());
            rundata.setStackTrace(StringUtils.stackTrace((Throwable)e), (Throwable)e);
            rundata.setScreenTemplate(JetspeedResources.getString("template.error", "Error"));
        }
    }

    public void doUpdate(RunData rundata, Context context) throws Exception {
        String entityid = rundata.getParameters().getString("entityid");
        if (entityid == null || entityid.trim().length() == 0) {
            logger.error("RolePermissionBrowser: Failed to get entity: " + entityid);
            DynamicURI duri = new DynamicURI(rundata);
            duri.addPathInfo("js_panename", "PermissionBrowser");
            duri.addPathInfo("msgid", 5);
            rundata.setRedirectURI(duri.toString());
            return;
        }
        Role role = JetspeedSecurity.getRole(entityid);
        if (null == role) {
            logger.error("RolePermissionBrowser: Failed to get role: " + entityid);
            DynamicURI duri = new DynamicURI(rundata);
            duri.addPathInfo("js_panename", "PermissionBrowser");
            duri.addPathInfo("msgid", 5);
            rundata.setRedirectURI(duri.toString());
            return;
        }
        try {
            List permissions = (List)rundata.getUser().getTemp("permissions");
            List selected = (List)rundata.getUser().getTemp("selected");
            if (permissions == null || selected == null) {
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "PermissionBrowser");
                duri.addPathInfo("msgid", 5);
                rundata.setRedirectURI(duri.toString());
                return;
            }
            for (int ix = 0; ix < permissions.size(); ++ix) {
                boolean oldValue;
                String permissionName = ((Permission)permissions.get(ix)).getName();
                boolean newValue = rundata.getParameters().getBoolean("box_" + permissionName, false);
                if (newValue == (oldValue = ((Boolean)selected.get(ix + 1)).booleanValue())) continue;
                if (newValue) {
                    JetspeedSecurity.grantPermission(role.getName(), permissionName);
                    continue;
                }
                JetspeedSecurity.revokePermission(role.getName(), permissionName);
            }
            rundata.getUser().setTemp("permissions", null);
            rundata.getUser().setTemp("selected", null);
        }
        catch (Exception e) {
            logger.error("Failed update role+permission", e);
            DynamicURI duri = new DynamicURI(rundata);
            duri.addPathInfo("js_panename", "PermissionBrowser");
            duri.addPathInfo("msgid", 0);
            if (role != null) {
                duri.addPathInfo("entityid", role.getName());
            }
            rundata.setRedirectURI(duri.toString());
        }
    }

    private void buildRolePermissionContext(VelocityPortlet portlet, Context context, RunData rundata, String roleName) throws JetspeedSecurityException {
        Iterator master = JetspeedSecurity.getPermissions();
        Role role = JetspeedSecurity.getRole(roleName);
        if (null == role) {
            logger.error("RolePermissionBrowser: Failed to get role: " + roleName);
            return;
        }
        Iterator subset = JetspeedSecurity.getPermissions(roleName);
        Vector<Permission> permissions = new Vector<Permission>();
        Vector<Boolean> selected = new Vector<Boolean>();
        boolean sel = false;
        int ix = 0;
        selected.add(0, new Boolean(sel));
        while (master.hasNext()) {
            Permission permission = (Permission)master.next();
            permissions.add(permission);
            sel = JetspeedSecurity.hasPermission(roleName, permission.getName());
            selected.add(++ix, new Boolean(sel));
        }
        selected.trimToSize();
        permissions.trimToSize();
        rundata.getUser().setTemp("permissions", permissions);
        rundata.getUser().setTemp("selected", selected);
        context.put("permissions", permissions);
        context.put("selected", selected);
        context.put("role", (Object)role);
    }
}

