/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets.security;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.jetspeed.modules.actions.portlets.SecureVelocityPortletAction;
import org.apache.jetspeed.modules.actions.portlets.security.SecurityConstants;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.PortletUtils;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class UserRoleUpdateAction
extends SecureVelocityPortletAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(UserRoleUpdateAction.class.getName());

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildConfigureContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        try {
            int id;
            Object role = null;
            String mode = rundata.getParameters().getString("mode");
            String entityid = rundata.getParameters().getString("entityid");
            if (entityid == null || entityid.trim().length() == 0) {
                return;
            }
            this.buildUserRoleContext(portlet, context, rundata, entityid);
            String msgid = rundata.getParameters().getString("msgid");
            if (msgid != null && (id = Integer.parseInt(msgid)) < SecurityConstants.MESSAGES.length) {
                context.put("msg", (Object)SecurityConstants.MESSAGES[id]);
            }
        }
        catch (Exception e) {
            logger.error("Error in Jetspeed User Role Security", e);
            rundata.setMessage("Error in Jetspeed User Role Security: " + e.toString());
            rundata.setStackTrace(StringUtils.stackTrace((Throwable)e), (Throwable)e);
            rundata.setScreenTemplate(JetspeedResources.getString("template.error", "Error"));
        }
    }

    public void doUpdate(RunData rundata, Context context) throws Exception {
        String entityid = rundata.getParameters().getString("entityid");
        if (entityid == null || entityid.trim().length() == 0) {
            logger.error("UserRoleBrowser: Failed to get entity: " + entityid);
            DynamicURI duri = new DynamicURI(rundata);
            duri.addPathInfo("js_panename", "UserRoleForm");
            duri.addPathInfo("msgid", 5);
            rundata.setRedirectURI(duri.toString());
            return;
        }
        JetspeedUser user = JetspeedSecurity.getUser(entityid);
        if (null == user) {
            logger.error("UserRoleBrowser: Failed to get user: " + entityid);
            DynamicURI duri = new DynamicURI(rundata);
            duri.addPathInfo("js_panename", "UserRoleForm");
            duri.addPathInfo("msgid", 5);
            rundata.setRedirectURI(duri.toString());
            return;
        }
        try {
            List roles = (List)rundata.getUser().getTemp("roles");
            List selected = (List)rundata.getUser().getTemp("selected");
            if (roles == null || selected == null) {
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "UserRoleForm");
                duri.addPathInfo("msgid", 5);
                rundata.setRedirectURI(duri.toString());
                return;
            }
            for (int ix = 0; ix < roles.size(); ++ix) {
                boolean oldValue;
                boolean newValue = rundata.getParameters().getBoolean("box_" + ((Role)roles.get(ix)).getName(), false);
                if (newValue == (oldValue = ((Boolean)selected.get(ix + 1)).booleanValue())) continue;
                if (newValue) {
                    Role newRole = (Role)roles.get(ix);
                    JetspeedSecurity.grantRole(user.getUserName(), newRole.getName());
                    if (!Profiler.useRoleProfileMerging()) continue;
                    this.appendNewRoleProfile((JetspeedRunData)rundata, user, newRole);
                    continue;
                }
                JetspeedSecurity.revokeRole(user.getUserName(), ((Role)roles.get(ix)).getName());
            }
            rundata.getUser().setTemp("roles", null);
            rundata.getUser().setTemp("selected", null);
        }
        catch (Exception e) {
            logger.error("Failed update role+permission: ", e);
            DynamicURI duri = new DynamicURI(rundata);
            duri.addPathInfo("js_panename", "UserRoleForm");
            duri.addPathInfo("msgid", 0);
            if (user != null) {
                duri.addPathInfo("entityid", user.getUserName());
            }
            rundata.setRedirectURI(duri.toString());
        }
    }

    private void appendNewRoleProfile(JetspeedRunData jdata, JetspeedUser user, Role role) throws Exception {
        ProfileLocator roleLocator = Profiler.createLocator();
        roleLocator.setRole(role);
        roleLocator.setMediaType(jdata.getCapability().getPreferredMediaType());
        roleLocator.setName("default.psml");
        Profile roleProfile = Profiler.getProfile(roleLocator);
        if (roleProfile != null && logger.isDebugEnabled()) {
            logger.debug("UserRoleUpdateAction: retrieved profile for role: " + roleProfile.getPath());
        }
        ProfileLocator userLocator = Profiler.createLocator();
        userLocator.setUser(user);
        userLocator.setMediaType(jdata.getCapability().getPreferredMediaType());
        userLocator.setName("default.psml");
        Profile userProfile = Profiler.getProfile(userLocator);
        if (userProfile != null && logger.isDebugEnabled()) {
            logger.debug("UserRoleUpdateAction: retrieved profile for user: " + userProfile.getPath());
        }
        if (roleProfile != null && roleProfile.getDocument() != null && userProfile != null && userProfile.getDocument() != null) {
            Profile tmpProfile = (Profile)roleProfile.clone();
            Portlets rolePortlets = tmpProfile.getDocument().getPortlets();
            Portlets userPortlets = userProfile.getDocument().getPortlets();
            if (rolePortlets.getPortletsCount() > 0) {
                for (int i = 0; i < rolePortlets.getPortletsCount(); ++i) {
                    Portlets pane = rolePortlets.getPortlets(i);
                    pane.setLayout(null);
                    userPortlets.addPortlets(pane);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("UserRoleUpdateAction: appended pane: " + pane.getId() + " to user: " + user.getUserName());
                }
            } else {
                if (rolePortlets.getTitle() == null) {
                    String title = StringUtils.firstLetterCaps((String)roleProfile.getRoleName());
                    rolePortlets.setTitle(title + " Home");
                }
                rolePortlets.setLayout(null);
                userPortlets.addPortlets(rolePortlets);
            }
            PortletUtils.regenerateIds(userPortlets);
            PsmlManager.store(userProfile);
        }
    }

    private void buildUserRoleContext(VelocityPortlet portlet, Context context, RunData rundata, String userid) throws Exception {
        JetspeedUser user = JetspeedSecurity.getUser(userid);
        if (null == user) {
            logger.error("UserRoleBrowser: Failed to get user: " + userid);
            return;
        }
        Iterator roles = JetspeedSecurity.getRoles();
        Vector<Role> masterRoles = new Vector<Role>();
        Vector<Boolean> selected = new Vector<Boolean>();
        int ix = 0;
        boolean sel = false;
        selected.add(ix, new Boolean(sel));
        while (roles.hasNext()) {
            Role role = (Role)roles.next();
            masterRoles.add(role);
            sel = JetspeedSecurity.hasRole(user.getUserName(), role.getName());
            selected.add(++ix, new Boolean(sel));
        }
        masterRoles.trimToSize();
        selected.trimToSize();
        rundata.getUser().setTemp("roles", masterRoles);
        rundata.getUser().setTemp("selected", selected);
        context.put("user", (Object)user);
        context.put("roles", masterRoles);
        context.put("selected", selected);
    }
}

