/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.parameters;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.Input;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.jetspeed.modules.parameters.ParameterPresentationStyle;
import org.apache.turbine.util.RunData;

public class CheckBoxGroup
extends ParameterPresentationStyle {
    public static final String ITEMS = "items";
    public static final String LAYOUT = "layout";
    public static final String LAYOUT_EW = "$eastwest";
    public static final String LAYOUT_NS = "$northsouth";
    public static final String PREFIX = "prefix";
    public static final String PREFIX_DEFAULT = "cb";

    public String getContent(RunData data, String name, String value, Map parms) {
        ElementContainer result = new ElementContainer();
        String items = (String)parms.get(ITEMS);
        String layout = (String)parms.get(LAYOUT);
        String prefix = (String)parms.get(PREFIX);
        if (prefix == null) {
            prefix = PREFIX_DEFAULT;
        }
        StringTokenizer st = new StringTokenizer(items, ",");
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.equalsIgnoreCase("")) continue;
            v.add(token);
        }
        Table t = new Table();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String item = ((String)e.nextElement()).trim();
            Input cb = new Input("CHECKBOX", prefix + item, item);
            cb.setChecked(value.indexOf(item) >= 0);
            cb.setOnClick(this.getJavascript(name, v, prefix));
            ElementContainer temp = new ElementContainer();
            temp.addElement((Element)cb).addElement("&nbsp;").addElement(item);
            if (layout.equalsIgnoreCase(LAYOUT_NS)) {
                t.addElement((Element)new TR().addElement((Element)new TD((Element)temp)));
                continue;
            }
            result.addElement((Element)temp);
        }
        if (layout.equalsIgnoreCase(LAYOUT_NS)) {
            result.addElement((Element)t);
        }
        result.addElement((Element)new Input("HIDDEN", name, value));
        return result.toString();
    }

    private String getJavascript(String name, Vector v, String prefix) {
        StringBuffer result = new StringBuffer();
        result.append(name).append(".value = ");
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String item = prefix + (String)e.nextElement();
            result.append("((");
            result.append(item);
            result.append(".checked) ? ");
            result.append(item);
            result.append(".value : '')");
            if (!e.hasMoreElements()) continue;
            result.append(" + ',' + ");
        }
        return result.toString();
    }

    public static void main(String[] args) {
        CheckBoxGroup cbg = new CheckBoxGroup();
        Hashtable<String, String> parms = new Hashtable<String, String>();
        parms.put(ITEMS, "Tomaszewski,Gorgon,Zmuda,Szymanowski,Musial,Kasperczak,Deyna,Cmikiewicz,Lato,Szarmach,Gadocha");
        System.out.println(cbg.getContent(null, "test", "Deyna,,,,Gorgon,Lato,Szarmach,", parms));
    }
}

