/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.dbpsml;

import java.sql.Connection;
import java.util.List;
import org.apache.jetspeed.om.dbpsml.BaseJetspeedGroupProfilePeer;
import org.apache.jetspeed.om.dbpsml.JetspeedGroupProfile;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.psmlmanager.db.DBOperations;
import org.apache.jetspeed.services.psmlmanager.db.DBUtils;
import org.apache.jetspeed.services.psmlmanager.db.DatabasePsmlManager;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public class JetspeedGroupProfilePeer
extends BaseJetspeedGroupProfilePeer
implements DBOperations {
    public void insert(Profile profile, Connection connection) throws Exception {
        this.doInsertOrUpdate(profile, 1, connection);
    }

    public void update(Profile profile, Connection connection) throws Exception {
        this.doInsertOrUpdate(profile, 2, connection);
    }

    private void doInsertOrUpdate(Profile profile, int operation, Connection connection) throws Exception {
        JetspeedGroupProfile groupProfile = new JetspeedGroupProfile();
        DatabasePsmlManager service = (DatabasePsmlManager)PsmlManager.getService();
        groupProfile.setGroupName(profile.getGroup().getName());
        groupProfile.setMediaType(profile.getMediaType());
        String language = profile.getLanguage();
        if (language != null && !language.equals("-1")) {
            groupProfile.setLanguage(language);
        } else {
            groupProfile.setLanguage(null);
        }
        String country = profile.getCountry();
        if (country != null && !country.equals("-1")) {
            groupProfile.setCountry(country);
        } else {
            groupProfile.setCountry(null);
        }
        String name = profile.getName();
        if (name == null || name.equals("")) {
            profile.setName("default.psml");
        } else if (!name.endsWith(".psml")) {
            profile.setName(name + ".psml");
        }
        groupProfile.setPage(profile.getName());
        groupProfile.setProfile(DBUtils.portletsToBytes(profile.getDocument().getPortlets(), service.getMapping()));
        if (operation == 1) {
            BaseJetspeedGroupProfilePeer.doInsert(groupProfile, connection);
        } else if (operation == 2) {
            Criteria values = JetspeedGroupProfilePeer.buildCriteria(groupProfile);
            Criteria select = JetspeedGroupProfilePeer.buildCriteria(groupProfile);
            select.remove(PROFILE);
            BasePeer.doUpdate((Criteria)select, (Criteria)values, (Connection)connection);
        }
    }

    public void delete(ProfileLocator locator, Connection connection) throws Exception {
        BaseJetspeedGroupProfilePeer.doDelete(this.buildCriteria(locator), connection);
    }

    public List select(ProfileLocator locator, Connection connection) throws Exception {
        return BaseJetspeedGroupProfilePeer.doSelect(this.buildCriteria(locator), connection);
    }

    public List selectOrdered(ProfileLocator locator, Connection connection) throws Exception {
        Criteria criteria = this.buildCriteria(locator);
        criteria.addAscendingOrderByColumn(GROUP_NAME);
        criteria.addAscendingOrderByColumn(MEDIA_TYPE);
        criteria.addAscendingOrderByColumn(LANGUAGE);
        criteria.addAscendingOrderByColumn(COUNTRY);
        criteria.addAscendingOrderByColumn(PAGE);
        return BaseJetspeedGroupProfilePeer.doSelect(criteria, connection);
    }

    public void delete(Group group, Connection connection) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(GROUP_NAME, (Object)group.getName());
        BaseJetspeedGroupProfilePeer.doDelete(criteria, connection);
    }

    protected Criteria buildCriteria(ProfileLocator locator) {
        Criteria criteria = new Criteria();
        String mediaType = locator.getMediaType();
        String language = locator.getLanguage();
        String country = locator.getCountry();
        String pageName = locator.getName();
        String groupName = null;
        Group group = locator.getGroup();
        if (group != null) {
            groupName = group.getName();
        }
        if (groupName != null && groupName.length() > 0) {
            criteria.add(GROUP_NAME, (Object)groupName);
        }
        if (pageName != null && pageName.length() > 0) {
            criteria.add(PAGE, (Object)pageName);
        }
        if (mediaType != null && mediaType.length() > 0) {
            criteria.add(MEDIA_TYPE, (Object)locator.getMediaType());
        }
        if (language != null && language.length() > 0 && !language.equals("-1")) {
            criteria.add(LANGUAGE, (Object)language);
        } else if (language != null && language.equals("-1")) {
            criteria.add(LANGUAGE, null);
        }
        if (country != null && country.length() > 0 && !country.equals("-1")) {
            criteria.add(COUNTRY, (Object)country);
        } else if (country != null && country.equals("-1")) {
            criteria.add(COUNTRY, null);
        }
        return criteria;
    }
}

