/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.profile.psml;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.jetspeed.om.profile.ConfigElement;
import org.apache.jetspeed.om.profile.Parameter;

public class PsmlConfigElement
implements ConfigElement,
Serializable {
    private String name = null;
    private Vector parameters = new Vector();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Vector getParameters() {
        return this.parameters;
    }

    public void setParameters(Vector parameters) {
        this.parameters = parameters;
    }

    public String getParameterValue(String name) {
        if (this.parameters == null) {
            return null;
        }
        for (int ix = 0; ix < this.parameters.size(); ++ix) {
            Parameter param = (Parameter)this.parameters.elementAt(ix);
            if (!param.getName().equals(name)) continue;
            return param.getValue();
        }
        return null;
    }

    public Parameter getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        for (int ix = 0; ix < this.parameters.size(); ++ix) {
            Parameter param = (Parameter)this.parameters.elementAt(ix);
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public Iterator getParameterIterator() {
        return this.parameters.iterator();
    }

    public Parameter getParameter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.parameters.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Parameter)this.parameters.elementAt(index);
    }

    public int getParameterCount() {
        return this.parameters.size();
    }

    public void removeAllParameter() {
        this.parameters.removeAllElements();
    }

    public Parameter removeParameter(int index) {
        Object obj = this.parameters.elementAt(index);
        this.parameters.removeElementAt(index);
        return (Parameter)obj;
    }

    public void setParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.parameters.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.parameters.setElementAt(vParameter, index);
    }

    public Parameter[] getParameter() {
        int size = this.parameters.size();
        Parameter[] mArray = new Parameter[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Parameter)this.parameters.elementAt(index);
        }
        return mArray;
    }

    public void addParameter(Parameter vParameter) throws IndexOutOfBoundsException {
        this.parameters.addElement(vParameter);
    }

    public Object clone() throws CloneNotSupportedException {
        Object cloned = super.clone();
        if (this.parameters != null) {
            ((PsmlConfigElement)cloned).parameters = new Vector(this.parameters.size());
            Iterator it = this.parameters.iterator();
            while (it.hasNext()) {
                ((PsmlConfigElement)cloned).parameters.add((Parameter)((Parameter)it.next()).clone());
            }
        }
        return cloned;
    }
}

