/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.base;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import org.apache.jetspeed.om.registry.PortletEntry;

public class CategoryIterator
implements Iterator {
    protected SortedMap map = null;
    protected String key;
    protected Iterator mapIterator = null;
    protected Iterator bucketIterator = null;
    protected boolean iteratingMaps = true;
    protected HashMap bucket = null;
    protected PortletEntry portlet = null;
    protected boolean findall = false;
    protected String category = "";
    protected String group = "";

    public String getCategory() {
        return this.category;
    }

    public String getGroup() {
        return this.group;
    }

    public CategoryIterator(SortedMap map, String key) {
        this.map = map;
        this.key = key;
        this.findall = this.key == null || this.key.equals("");
        this.map = this.findall ? map : map.tailMap(key);
        this.mapIterator = this.map.entrySet().iterator();
        this.bucketIterator = null;
        this.bucket = null;
    }

    private CategoryIterator() {
    }

    public boolean hasNext() {
        if (this.iteratingMaps) {
            if (!this.mapIterator.hasNext()) {
                return false;
            }
            return this.filter();
        }
        if (this.bucketIterator.hasNext()) {
            return this.getPortletEntry();
        }
        if (this.mapIterator.hasNext()) {
            return this.filter();
        }
        return false;
    }

    protected boolean filter() {
        Map.Entry entry = (Map.Entry)this.mapIterator.next();
        String entryKey = (String)entry.getKey();
        int pos = entryKey.indexOf(46);
        this.category = "";
        if (-1 == pos) {
            this.group = entryKey;
        } else {
            this.group = entryKey.substring(0, pos);
            int length = entryKey.length();
            if (length > pos + 1) {
                this.category = entryKey.substring(pos + 1, length);
            }
        }
        if (!this.findall && !entryKey.startsWith(this.key)) {
            return false;
        }
        this.bucket = (HashMap)entry.getValue();
        this.bucketIterator = this.bucket.entrySet().iterator();
        this.iteratingMaps = false;
        if (!this.bucketIterator.hasNext()) {
            return false;
        }
        return this.getPortletEntry();
    }

    protected boolean getPortletEntry() {
        Map.Entry entry = (Map.Entry)this.bucketIterator.next();
        if (null == entry) {
            return false;
        }
        this.portlet = (PortletEntry)entry.getValue();
        return true;
    }

    public void remove() throws IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException("The remove() method is not supported");
    }

    public Object next() throws NoSuchElementException {
        return this.portlet;
    }
}

