/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.database;

import com.workingdogs.village.DataSetException;
import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.om.BaseSecurityReference;
import org.apache.jetspeed.om.registry.DBRegistry;
import org.apache.jetspeed.om.registry.Parameter;
import org.apache.jetspeed.om.registry.base.BaseCategory;
import org.apache.jetspeed.om.registry.base.BaseContentURL;
import org.apache.jetspeed.om.registry.base.BaseMediaType;
import org.apache.jetspeed.om.registry.base.BaseMetaInfo;
import org.apache.jetspeed.om.registry.base.BasePortletEntry;
import org.apache.jetspeed.om.registry.base.BaseSecurity;
import org.apache.jetspeed.om.registry.database.BaseJetspeedPortletCategoryPeer;
import org.apache.jetspeed.om.registry.database.BaseJetspeedPortletMediaTypePeer;
import org.apache.jetspeed.om.registry.database.BaseJetspeedPortletParameterPeer;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public class BaseJetspeedPortletPeer
extends BasePeer
implements DBRegistry {
    protected static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(BaseJetspeedPortletPeer.class.getName());
    public static final String TABLE_NAME = "PORTLET";
    public static final String PORTAL_ID = "PORTLET.ID";
    public static final String NAME = "PORTLET.NAME";
    public static final String HIDDEN = "PORTLET.HIDDEN";
    public static final String CLASSNAME = "PORTLET.CLASSNAME";
    public static final String TYPE = "PORTLET.TYPE";
    public static final String APPLICATION = "PORTLET.APPLICATION";
    public static final String PARENT = "PORTLET.PARENT";
    public static final String URL = "PORTLET.URL";
    public static final String CACHEDONURL = "PORTLET.CACHEDONURL";
    public static final String ROLE = "PORTLET.ROLE";
    public static final String TITLE = "PORTLET.TITLE";
    public static final String DESCRIPTION = "PORTLET.DESCRIPTION";
    public static final String IMAGE = "PORTLET.IMAGE";
    public static final String SECURITY = "PORTLET.SECURITY";
    public static final String LASTUPDATE = "PORTLET.LASTUPDATE";
    public static final int numColumns = 14;
    protected static final String CLASSNAME_DEFAULT = "org.apache.jetspeed.om.registry.base.BasePortletEntry";
    protected static final Class CLASS_DEFAULT = BaseJetspeedPortletPeer.initClass("org.apache.jetspeed.om.registry.base.BasePortletEntry");

    private static Class initClass(String className) {
        Class<?> c;
        block2: {
            c = null;
            try {
                c = Class.forName(className);
            }
            catch (Throwable t) {
                logger.error("A FATAL ERROR has occurred which should not have happened under any circumstance.  Please notify the Turbine developers <turbine-dev@jakarta.apache.org> and give as many details as possible (including the error stack trace).", t);
                if (!(t instanceof Error)) break block2;
                throw (Error)t.fillInStackTrace();
            }
        }
        return c;
    }

    public static List resultSet2Objects(ResultSet results) throws TorqueException {
        try {
            QueryDataSet qds = null;
            List rows = null;
            try {
                qds = new QueryDataSet(results);
                rows = BaseJetspeedPortletPeer.getSelectResults((QueryDataSet)qds);
            }
            finally {
                if (qds != null) {
                    qds.close();
                }
            }
            return BaseJetspeedPortletPeer.populateObjects(rows);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
        catch (DataSetException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public static void addSelectColumns(Criteria criteria) throws TorqueException {
        criteria.addSelectColumn(PORTAL_ID);
        criteria.addSelectColumn(NAME);
        criteria.addSelectColumn(HIDDEN);
        criteria.addSelectColumn(CLASSNAME);
        criteria.addSelectColumn(TYPE);
        criteria.addSelectColumn(APPLICATION);
        criteria.addSelectColumn(PARENT);
        criteria.addSelectColumn(URL);
        criteria.addSelectColumn(CACHEDONURL);
        criteria.addSelectColumn(ROLE);
        criteria.addSelectColumn(TITLE);
        criteria.addSelectColumn(DESCRIPTION);
        criteria.addSelectColumn(IMAGE);
        criteria.addSelectColumn(SECURITY);
    }

    public static BasePortletEntry row2Object(Record row, int offset, Class cls) throws TorqueException {
        try {
            BasePortletEntry obj = (BasePortletEntry)cls.newInstance();
            BaseJetspeedPortletPeer.populateObject(row, offset, obj);
            return obj;
        }
        catch (InstantiationException e) {
            throw new TorqueException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public static void populateObject(Record row, int offset, BasePortletEntry obj) throws TorqueException {
        try {
            int id = row.getValue(offset + 0).asInt();
            obj.setName(row.getValue(offset + 1).asString());
            obj.setHidden(row.getValue(offset + 2).asBoolean());
            obj.setClassname(row.getValue(offset + 3).asString());
            obj.setType(row.getValue(offset + 4).asString());
            obj.setApplication(row.getValue(offset + 5).asBoolean());
            obj.setParent(row.getValue(offset + 6).asString());
            obj.setURL(row.getValue(offset + 7).asString());
            obj.setCachedOnURL(row.getValue(offset + 8).asBoolean());
            BaseSecurity security = new BaseSecurity(row.getValue(offset + 9).asString());
            obj.setSecurity(security);
            obj.setBaseSecurity(security);
            BaseContentURL baseContentURL = new BaseContentURL();
            baseContentURL.setCachedOnURL(row.getValue(offset + 8).asBoolean());
            baseContentURL.setURL(row.getValue(offset + 7).asString());
            obj.setContentURL(baseContentURL);
            BaseMetaInfo baseMetaInfo = new BaseMetaInfo(row.getValue(offset + 10).asString(), row.getValue(offset + 11).asString(), row.getValue(offset + 12).asString());
            obj.setMetaInfo(baseMetaInfo);
            String securityRef = row.getValue(offset + 13).asString();
            if (securityRef != null || "".equals(securityRef)) {
                BaseSecurityReference paramSecurityRef = new BaseSecurityReference();
                paramSecurityRef.setParent(securityRef);
                obj.setSecurityRef(paramSecurityRef);
            }
            BaseJetspeedPortletPeer.buildPortletCategory(id, obj);
            BaseJetspeedPortletPeer.buildPortletMedia(id, obj);
            BaseJetspeedPortletPeer.buildPortletParameters(id, obj);
        }
        catch (DataSetException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public List getXREGDataFromDb() throws TorqueException {
        Criteria criteria = BaseJetspeedPortletPeer.buildCriteria();
        return BaseJetspeedPortletPeer.doSelect(criteria);
    }

    public boolean isModified(String lastUpdateDate) {
        return true;
    }

    public static List doSelect(Criteria criteria) throws TorqueException {
        return BaseJetspeedPortletPeer.populateObjects(BaseJetspeedPortletPeer.doSelectVillageRecords(criteria));
    }

    public static List doSelect(Criteria criteria, Connection con) throws TorqueException {
        return BaseJetspeedPortletPeer.populateObjects(BaseJetspeedPortletPeer.doSelectVillageRecords(criteria, con));
    }

    public static List doSelectVillageRecords(Criteria criteria) throws TorqueException {
        return BaseJetspeedPortletPeer.doSelectVillageRecords(criteria, null);
    }

    public static List doSelectVillageRecords(Criteria criteria, Connection con) throws TorqueException {
        if (criteria.getSelectColumns().size() == 0) {
            BaseJetspeedPortletPeer.addSelectColumns(criteria);
        }
        if (criteria.getDbName() == Torque.getDefaultDB()) {
            criteria.setDbName("default");
        }
        if (con == null) {
            return BasePeer.doSelect((Criteria)criteria);
        }
        return BasePeer.doSelect((Criteria)criteria, (Connection)con);
    }

    public static List populateObjects(List records) throws TorqueException {
        ArrayList<BasePortletEntry> results = new ArrayList<BasePortletEntry>(records.size());
        for (int i = 0; i < records.size(); ++i) {
            Record row = (Record)records.get(i);
            results.add(BaseJetspeedPortletPeer.row2Object(row, 1, BaseJetspeedPortletPeer.getOMClass()));
        }
        return results;
    }

    public static Criteria buildCriteria(ObjectKey pk) {
        Criteria criteria = new Criteria();
        criteria.add(PORTAL_ID, (Object)pk);
        return criteria;
    }

    public static Criteria buildCriteria() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public static Class getOMClass() throws TorqueException {
        return CLASS_DEFAULT;
    }

    public static void buildPortletParameters(int id, BasePortletEntry obj) throws TorqueException {
        try {
            List list = BaseJetspeedPortletParameterPeer.retrieveById((ObjectKey)SimpleKey.keyFor((int)id));
            for (int i = 0; i < list.size(); ++i) {
                Parameter p = (Parameter)list.get(i);
                obj.addParameter(p);
            }
        }
        catch (Exception e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public static void buildPortletMedia(int id, BasePortletEntry obj) throws TorqueException {
        try {
            List list = BaseJetspeedPortletMediaTypePeer.retrieveById((ObjectKey)SimpleKey.keyFor((int)id));
            for (int i = 0; i < list.size(); ++i) {
                BaseMediaType p = (BaseMediaType)list.get(i);
                String mediaName = p.getRef();
                if (obj.hasMediaType(mediaName)) continue;
                obj.addMediaType(mediaName);
            }
        }
        catch (Exception e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public static void buildPortletCategory(int id, BasePortletEntry obj) throws TorqueException {
        try {
            List list = BaseJetspeedPortletCategoryPeer.retrieveById((ObjectKey)SimpleKey.keyFor((int)id));
            for (int i = 0; i < list.size(); ++i) {
                BaseCategory p = (BaseCategory)list.get(i);
                String name = p.getName();
                String group = p.getGroup();
                if (group == null) {
                    if (obj.hasCategory(name)) continue;
                    obj.addCategory(name);
                    continue;
                }
                if (obj.hasCategory(name, group)) continue;
                obj.addCategory(name, group);
            }
        }
        catch (Exception e) {
            throw new TorqueException((Throwable)e);
        }
    }
}

