/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal;

import java.util.Hashtable;
import java.util.Map;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.PortletSkin;
import org.apache.jetspeed.util.BaseConfig;
import org.apache.jetspeed.util.MetaData;
import org.apache.turbine.services.servlet.TurbineServlet;

public class BasePortletConfig
extends BaseConfig
implements PortletConfig {
    private String url;
    private MetaData metainfo;
    private PortletSet.Constraints layoutConstraints = null;
    private int layoutPosition = -1;
    private PortletSkin skin;
    private transient PortletSet currentSet;
    private CapabilityMap cm = null;
    private boolean cachedOnURL = true;
    private String pageId;
    private String portletId;
    private SecurityReference securityRef = null;

    public void init(String url, Map init_params) {
        if (init_params == null) {
            this.setInitParameters(new Hashtable());
        } else {
            this.setInitParameters(init_params);
        }
        this.setURL(url);
    }

    public PortletSet getPortletSet() {
        return this.currentSet;
    }

    public void setPortletSet(PortletSet set) {
        this.currentSet = set;
    }

    public Map getLayout() {
        return this.layoutConstraints;
    }

    public void setLayout(Map constraints) {
    }

    public Map getSkin() {
        return this.skin;
    }

    public void setSkin(Map skin) {
    }

    public int getPosition() {
        return this.layoutPosition;
    }

    public void setPosition(int position) {
        this.layoutPosition = position;
    }

    public MetaData getMetainfo() {
        return this.metainfo;
    }

    public void setMetainfo(MetaData metainfo) {
        this.metainfo = metainfo;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        if (url == null) {
            return;
        }
        this.url = url.indexOf("://") < 0 ? TurbineServlet.getResource((String)url).toString() : url;
    }

    public boolean isCachedOnURL() {
        return this.cachedOnURL;
    }

    public void setCachedOnURL(boolean cached) {
        this.cachedOnURL = cached;
    }

    public String getLayout(String name, String defaultValue) {
        String value = null;
        if (name != null && this.layoutConstraints != null) {
            value = (String)this.layoutConstraints.get(name.toLowerCase());
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getSkin(String name, String defaultValue) {
        String value = null;
        try {
            value = (String)this.skin.get(name.toLowerCase());
            if (value == null) {
                value = this.currentSet.getPortletConfig().getSkin(name, defaultValue);
            }
            if (value == null) {
                value = defaultValue;
            }
        }
        catch (RuntimeException e) {
            value = defaultValue;
        }
        return value;
    }

    public void setSkin(String name, String value) {
        if (name != null) {
            if (this.getSkin() == null) {
                this.setPortletSkin(this.getPortletSkin());
            }
            if (value == null) {
                this.getSkin().remove(name);
            } else {
                this.getSkin().put(name, value);
            }
        }
    }

    public PortletSkin getPortletSkin() {
        if (this.skin == null && this.getPortletSet() != null) {
            return this.getPortletSet().getPortletConfig().getPortletSkin();
        }
        return this.skin;
    }

    public void setPortletSkin(PortletSkin skin) {
        this.skin = skin;
    }

    public PortletSet.Constraints getConstraints() {
        return this.layoutConstraints;
    }

    public void setConstraints(PortletSet.Constraints constraints) {
        this.layoutConstraints = constraints;
    }

    public CapabilityMap getCapabilityMap() {
        return this.cm;
    }

    public void setCapabilityMap(CapabilityMap cm) {
        this.cm = cm;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPortletId(String portletId) {
        this.portletId = portletId;
    }

    public String getPortletId() {
        return this.portletId;
    }

    public SecurityReference getSecurityRef() {
        return this.securityRef;
    }

    public void setSecurityRef(SecurityReference securityRef) {
        this.securityRef = securityRef;
    }
}

