/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.controllers;

import java.util.Iterator;
import java.util.Map;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.ElementContainer;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.om.registry.PortletControllerEntry;
import org.apache.jetspeed.portal.BasePortletSetConstraints;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.portal.PortletControllerConfig;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.MimeType;
import org.apache.turbine.util.RunData;

public abstract class AbstractPortletController
implements PortletController {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(AbstractPortletController.class.getName());
    public int DEFAULT_PADDING = 3;
    private String width = "100%";
    private PortletSet portlets = null;
    private PortletControllerConfig conf = null;

    public final void setConfig(PortletControllerConfig conf) {
        this.conf = conf;
    }

    public final PortletControllerConfig getConfig() {
        return this.conf;
    }

    public final void setPortlets(PortletSet portlets) {
        this.portlets = portlets;
    }

    public final PortletSet getPortlets() {
        return this.portlets;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public int getPadding() {
        int padding = 0;
        try {
            PortletConfig conf = this.getPortlets().getPortletConfig();
            padding = Integer.parseInt(conf.getSkin("padding", String.valueOf(this.DEFAULT_PADDING)));
        }
        catch (RuntimeException e) {
            logger.error("Exception getting padding value", e);
            padding = this.DEFAULT_PADDING;
        }
        return padding;
    }

    public void setPadding(int padding) {
        try {
            PortletConfig conf = this.getPortlets().getPortletConfig();
            conf.setSkin("padding", String.valueOf(padding));
        }
        catch (RuntimeException e) {
            logger.error("Exception setting padding value", e);
        }
    }

    public void setPadding(String padding) {
        try {
            PortletConfig conf = this.getPortlets().getPortletConfig();
            conf.setSkin("padding", padding);
        }
        catch (RuntimeException e) {
            logger.error("Exception setting padding value", e);
        }
    }

    public void init() {
    }

    public boolean supportsType(MimeType mimeType) {
        PortletControllerEntry entry = (PortletControllerEntry)Registry.getEntry(Registry.PORTLET_CONTROLLER, this.getConfig().getName());
        String baseType = mimeType.toString();
        if (entry != null) {
            Iterator i = entry.listMediaTypes();
            while (i.hasNext()) {
                String name = (String)i.next();
                MediaTypeEntry media = (MediaTypeEntry)Registry.getEntry(Registry.MEDIA_TYPE, name);
                if (media == null || !baseType.equals(media.getMimeType())) continue;
                return true;
            }
        }
        return false;
    }

    public ConcreteElement getContent(RunData rundata) {
        CapabilityMap map = ((JetspeedRunData)rundata).getCapability();
        ConcreteElement content = null;
        content = MimeType.WML.equals(map.getPreferredType()) ? this.getWMLContent(this.portlets, rundata) : (MimeType.HTML.equals(map.getPreferredType()) ? this.getHTMLContent(this.portlets, rundata) : this.getContent(this.portlets, rundata));
        return content;
    }

    protected ConcreteElement getContent(PortletSet set, RunData data) {
        return new ElementContainer();
    }

    protected ConcreteElement getWMLContent(PortletSet set, RunData data) {
        return new ElementContainer();
    }

    protected ConcreteElement getHTMLContent(PortletSet set, RunData data) {
        return new ElementContainer();
    }

    public PortletSet.Constraints getConstraints(Map original) {
        BasePortletSetConstraints constraints = new BasePortletSetConstraints();
        if (original != null) {
            constraints.putAll(original);
        }
        return constraints;
    }
}

