/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.controllers;

import org.apache.jetspeed.portal.PanedPortletController;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.controllers.VelocityPortletController;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;

public class VelocityPanedPortletController
extends VelocityPortletController
implements PanedPortletController {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(VelocityPanedPortletController.class.getName());
    public static final String DEFAULT_PARAMETER = "pane";

    public String getPaneParameter() {
        return "js_pane";
    }

    public boolean isSelected(Portlet p, RunData rundata) {
        String peid = rundata.getParameters().getString(this.getPaneParameter());
        String pname = rundata.getParameters().getString("js_panename");
        String last = this.retrievePaneIDFromSession(rundata);
        if (pname != null && pname.equals(p.getName())) {
            return true;
        }
        if (peid == null) {
            if (last == null) {
                return this.getPortlets().getPortletAt(0) == p;
            }
            if (pname == null) {
                return p.getID().equals(last);
            }
            return this.getPortlets().getPortletByName(pname) == null && p.getID().equals(last);
        }
        String subPane = null;
        int index = peid.indexOf(",");
        if (index > -1) {
            subPane = peid.substring(index + 1);
            peid = peid.substring(0, index);
        }
        if (p.getID().equals(peid)) {
            return true;
        }
        if (subPane != null && p.getID().equals(subPane)) {
            if (!p.getAttribute("_menustate", "open", rundata).equals("closed")) {
                SessionState state = ((JetspeedRunData)rundata).getPortletSessionState(this.getPortlets().getID());
                state.setAttribute("js_pane", subPane);
            }
            return true;
        }
        if (this.getPortlets().getPortletByID(peid) != null) {
            return false;
        }
        if (subPane == null) {
            if (last == null) {
                return this.getPortlets().getPortletAt(0) == p;
            }
            return p.getID().equals(last);
        }
        if (p.getID().equals(subPane)) {
            if (!p.getAttribute("_menustate", "open", rundata).equals("closed")) {
                SessionState state = ((JetspeedRunData)rundata).getPortletSessionState(this.getPortlets().getID());
                state.setAttribute("js_pane", subPane);
            }
            return true;
        }
        return false;
    }

    public DynamicURI getPortletURI(Portlet portlet, RunData rundata) {
        JetspeedLink jsLink = null;
        try {
            jsLink = JetspeedLinkFactory.getInstance(rundata);
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
        DynamicURI uri = jsLink.getPaneById(portlet.getID());
        JetspeedLinkFactory.putInstance(jsLink);
        return uri;
    }

    public String retrievePaneID(RunData rundata, boolean byParameter) {
        int index;
        if (!byParameter) {
            return this.retrievePaneIDFromSession(rundata);
        }
        String pane = rundata.getParameters().getString(this.getPaneParameter());
        if (pane == null) {
            String id = this.getPortlets().getID();
            pane = this.retrievePaneIDFromSession(rundata);
        }
        if (pane != null && (index = pane.indexOf(",")) > -1) {
            return pane.substring(0, index);
        }
        return pane;
    }

    protected String retrievePaneIDFromSession(RunData rundata) {
        SessionState state = ((JetspeedRunData)rundata).getPortletSessionState(this.getPortlets().getID());
        String pane = (String)state.getAttribute("js_pane");
        if (pane == null && this.getPortlets().size() > 0) {
            pane = this.getPortlets().getPortletAt(0).getID();
        }
        return pane;
    }

    public void savePaneID(RunData data, String id) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(this.getPortlets().getID());
        state.setAttribute("js_pane", id);
    }

    public void setParameterName(String name) {
        this.getConfig().setInitParameter("parameter", name);
    }

    public String getParameterName() {
        return this.getConfig().getInitParameter("parameter", DEFAULT_PARAMETER) + this.getPortlets().getName();
    }

    public String retrievePaneName(RunData rundata) {
        String pane = rundata.getParameters().getString(this.getParameterName());
        if (pane == null && (pane = (String)rundata.getUser().getTemp("pane-" + this.getParameterName())) == null) {
            pane = this.getConfig().getInitParameter("defaultpane", "0");
        }
        return pane;
    }

    public void savePaneName(RunData data, String name) {
        data.getUser().setTemp("pane-" + this.getParameterName(), (Object)name);
    }
}

