/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.controls;

import java.io.Writer;
import java.util.List;
import java.util.Vector;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletState;
import org.apache.jetspeed.portal.controls.AbstractPortletControl;
import org.apache.jetspeed.portal.security.portlets.PortletWrapper;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.jetspeed.util.template.JetspeedTool;
import org.apache.turbine.services.pull.TurbinePull;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class VelocityPortletControl
extends AbstractPortletControl {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(VelocityPortletControl.class.getName());

    public boolean isCacheable() {
        return false;
    }

    public ConcreteElement getContent(RunData rundata) {
        PortletWrapper wrapper;
        Portlet portlet = this.getPortlet();
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        if (portlet instanceof PortletWrapper && !(wrapper = (PortletWrapper)portlet).getAllowView(rundata) && JetspeedResources.getBoolean("defaultportletcontrol.hide.decorator", true)) {
            return new StringElement("");
        }
        Context context = TurbineVelocity.getContext();
        context.put("data", (Object)rundata);
        context.put("actions", (Object)this.buildActionList(rundata, portlet));
        context.put("conf", (Object)this.getConfig());
        context.put("skin", (Object)portlet.getPortletConfig().getPortletSkin());
        TurbinePull.populateContext((Context)context, (RunData)rundata);
        if (portlet.getName().equals(jdata.getCustomized()) && !portlet.providesCustomization()) {
            context.put("portlet", (Object)JetspeedTool.getCustomizer(portlet));
            context.put("portlet_instance", (Object)JetspeedTool.getCustomizer(portlet));
        } else {
            context.put("portlet", (Object)portlet);
            if (PersistenceManager.getInstance(portlet, (RunData)jdata) == null) {
                context.put("portlet_instance", (Object)portlet);
            } else {
                context.put("portlet_instance", (Object)PersistenceManager.getInstance(portlet, (RunData)jdata));
            }
        }
        this.buildContext(rundata, context);
        String theme = this.getConfig().getInitParameter("theme", "default.vm");
        String s = "";
        try {
            String template = TemplateLocator.locateControlTemplate(rundata, theme);
            TurbineVelocity.handleRequest((Context)context, (String)template, (Writer)rundata.getOut());
        }
        catch (Exception e) {
            logger.error("Exception while creating content ", e);
            s = e.toString();
        }
        TurbineVelocity.requestFinished((Context)context);
        return new StringElement(s);
    }

    public void buildContext(RunData rundata, Context context) {
    }

    protected List buildActionList(RunData rundata, Portlet portlet) {
        Vector<PortletAction> actions = new Vector<PortletAction>();
        JetspeedLink jsLink = null;
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        if (JetspeedSecurity.areActionsDisabledForAllUsers()) {
            return actions;
        }
        JetspeedUser user = jdata.getJetspeedUser();
        if (JetspeedSecurity.areActionsDisabledForAnon() && !user.hasLoggedIn()) {
            return actions;
        }
        if (portlet instanceof PortletState) {
            PortletState state = (PortletState)((Object)portlet);
            boolean customized = jdata.getMode() == 1;
            boolean maximized = customized || jdata.getMode() == 2;
            boolean infoAdded = false;
            if (state.allowCustomize(rundata)) {
                if (!customized) {
                    actions.add(new PortletAction("customize", "Customize"));
                }
            } else if (state.allowInfo(rundata)) {
                actions.add(new PortletAction("info", "Information"));
                infoAdded = true;
            }
            if (!customized && state.allowPrintFriendly(rundata)) {
                actions.add(new PortletAction("print", "Print Friendly Format"));
            }
            if (!customized && state.allowInfo(rundata) && !infoAdded) {
                actions.add(new PortletAction("info", "Information"));
            }
            if (!customized && !maximized && state.allowClose(rundata)) {
                actions.add(new PortletAction("close", "Close"));
            }
            if (state.isMinimized(rundata) || maximized) {
                actions.add(new PortletAction("restore", "Restore"));
            } else {
                if (state.allowMinimize(rundata)) {
                    actions.add(new PortletAction("minimize", "Minimize"));
                }
                if (state.allowMaximize(rundata)) {
                    actions.add(new PortletAction("maximize", "Maximize"));
                }
            }
        } else {
            if (portlet.getAllowEdit(rundata)) {
                actions.add(new PortletAction("info", "Information"));
            }
            if (portlet.getAllowMaximize(rundata)) {
                actions.add(new PortletAction("maximize", "Maximize"));
            }
        }
        for (PortletAction action : actions) {
            try {
                jsLink = JetspeedLinkFactory.getInstance(rundata);
            }
            catch (Exception e) {
                logger.error("Exception in buildActionList", e);
            }
            action.setLink(jsLink.setAction(VelocityPortletControl.getAction(action.getName()), portlet).toString());
            JetspeedLinkFactory.putInstance(jsLink);
            jsLink = null;
        }
        return actions;
    }

    protected static String getAction(String name) {
        StringBuffer buffer = new StringBuffer("controls.");
        buffer.append(name.substring(0, 1).toUpperCase());
        buffer.append(name.substring(1, name.length()));
        return buffer.toString();
    }

    public class PortletAction {
        String name = null;
        String link = null;
        String alt = null;

        protected PortletAction(String name, String alt) {
            this.name = name;
            this.alt = alt;
        }

        public String getName() {
            return this.name;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public String getAlt() {
            return this.alt;
        }
    }
}

