/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import java.util.Hashtable;
import java.util.Iterator;
import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.portal.BasePortletConfig;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.portal.PortletState;
import org.apache.jetspeed.portal.expire.Expire;
import org.apache.jetspeed.portal.expire.ExpireFactory;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.jetspeed.services.persistence.PortalPersistenceException;
import org.apache.jetspeed.services.portletcache.Cacheable;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.jetspeed.util.JetspeedException;
import org.apache.jetspeed.util.MetaData;
import org.apache.jetspeed.util.MimeType;
import org.apache.turbine.services.cache.CachedObject;
import org.apache.turbine.services.cache.Refreshable;
import org.apache.turbine.util.RunData;

public abstract class AbstractPortlet
implements Portlet,
PortletState,
Cacheable,
Refreshable {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(AbstractPortlet.class.getName());
    private boolean cacheable = true;
    private PortletConfig pc = null;
    private String name = null;
    private String id = null;
    private String handle = "";
    private Long expirationMillis = null;
    protected Hashtable content = new Hashtable();
    private long creationTime;
    private CachedObject cachedObject = null;

    protected void clearContent() {
        this.content.clear();
    }

    protected void setContent(ConcreteElement content) {
        this.setContent(content, CapabilityMapFactory.getDefaultCapabilityMap());
    }

    protected void setContent(String content) {
        this.setContent((ConcreteElement)new JetspeedClearElement(content), CapabilityMapFactory.getDefaultCapabilityMap());
    }

    protected void setContent(ConcreteElement content, CapabilityMap map) throws IllegalArgumentException {
        CapabilityMap mymap = map;
        if (mymap == null) {
            mymap = CapabilityMapFactory.getDefaultCapabilityMap();
        }
        JetspeedClearElement buffer = new JetspeedClearElement(content.toString());
        this.content.put(mymap.toString(), buffer);
    }

    public void refresh() {
        logger.debug("AbstractPortlet - Refreshing " + this.getName());
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public Expire getExpire() {
        try {
            return ExpireFactory.getExpire(this, "org.apache.jetspeed.portal.expire.NoExpire");
        }
        catch (JetspeedException e) {
            logger.error("Exception", e);
            return null;
        }
    }

    public final String getHandle() {
        return this.handle;
    }

    public final void setHandle(String handle) {
        this.handle = handle;
    }

    public Long getExpirationMillis() {
        return this.expirationMillis;
    }

    public void setExpirationMillis(long expirationMillis) {
        this.expirationMillis = new Long(expirationMillis);
        if (this.cachedObject != null) {
            long expirationInterval = this.expirationMillis - this.cachedObject.getCreated();
            if (expirationInterval > 0L) {
                this.cachedObject.setExpires(expirationInterval);
            } else {
                this.cachedObject.setStale(true);
            }
        }
    }

    public static Object getHandle(Object config) {
        PortletConfig pc = null;
        if (!(config instanceof PortletConfig)) {
            return null;
        }
        pc = (PortletConfig)config;
        StringBuffer handle = new StringBuffer(256);
        if (pc.getURL() != null && pc.isCachedOnURL()) {
            handle.append(String.valueOf(pc.getURL().hashCode()));
        }
        Iterator i = pc.getInitParameterNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            String value = pc.getInitParameter(name);
            if (value == null) continue;
            handle.append("|").append(name).append("-").append(value);
        }
        return handle.toString();
    }

    public void setCachedObject(CachedObject cachedObject) {
        this.cachedObject = cachedObject;
    }

    public String getName() {
        if (this.name == null && this.getPortletConfig() != null) {
            if (this.getPortletConfig().getName() != null) {
                return this.getPortletConfig().getName();
            }
            return this.getClass().getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PortletConfig getPortletConfig() {
        return this.pc;
    }

    public void setPortletConfig(PortletConfig pc) {
        this.pc = pc;
    }

    public ConcreteElement getContent(RunData rundata) {
        return this.getContent(rundata, null, true);
    }

    public ConcreteElement getContent(RunData rundata, CapabilityMap map) {
        CapabilityMap mymap = map;
        if (mymap == null) {
            mymap = CapabilityMapFactory.getCapabilityMap(rundata);
        }
        return (ConcreteElement)this.content.get(mymap.toString());
    }

    public ConcreteElement getContent(RunData rundata, CapabilityMap map, boolean allowRecurse) {
        Object element;
        block8: {
            CapabilityMap mymap = map;
            if (mymap == null) {
                mymap = CapabilityMapFactory.getCapabilityMap(rundata);
            }
            if ((element = (ConcreteElement)this.content.get(mymap.toString())) == null) {
                if (allowRecurse) {
                    try {
                        this.init();
                        element = this.getContent(rundata, mymap, false);
                        if (element != null) {
                            this.setContent((ConcreteElement)element, mymap);
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        element = new JetspeedClearElement("Error when retrieving Portlet contents");
                        if (logger.isDebugEnabled()) {
                            logger.debug("Error when retrieving Portlet contents", e);
                        }
                        break block8;
                    }
                }
                if (element == null && (element = (ConcreteElement)this.content.get((mymap = CapabilityMapFactory.getDefaultCapabilityMap()).toString())) == null) {
                    element = new JetspeedClearElement("Unknown Problem getting Contents");
                }
            }
        }
        return element;
    }

    public String getDescription() {
        if (this.getPortletConfig() != null && this.getPortletConfig().getMetainfo() != null) {
            return this.getPortletConfig().getMetainfo().getDescription();
        }
        return null;
    }

    public String getDescription(String instanceDescription) {
        if (instanceDescription != null) {
            return instanceDescription;
        }
        return this.getDescription();
    }

    public void setDescription(String description) {
        MetaData meta;
        PortletConfig pc = this.getPortletConfig();
        if (pc == null) {
            pc = new BasePortletConfig();
            this.setPortletConfig(pc);
        }
        if ((meta = pc.getMetainfo()) == null) {
            meta = new MetaData();
            pc.setMetainfo(meta);
        }
        meta.setDescription(description);
    }

    public String getTitle() {
        if (this.getPortletConfig() != null && this.getPortletConfig().getMetainfo() != null) {
            return this.getPortletConfig().getMetainfo().getTitle();
        }
        return null;
    }

    public String getTitle(String instanceTitle) {
        if (instanceTitle != null) {
            return instanceTitle;
        }
        return this.getTitle();
    }

    public void setTitle(String title) {
        MetaData meta;
        PortletConfig pc = this.getPortletConfig();
        if (pc == null) {
            pc = new BasePortletConfig();
            this.setPortletConfig(pc);
        }
        if ((meta = pc.getMetainfo()) == null) {
            meta = new MetaData();
            pc.setMetainfo(meta);
        }
        meta.setTitle(title);
    }

    public String getImage() {
        if (this.getPortletConfig() != null && this.getPortletConfig().getMetainfo() != null) {
            return this.getPortletConfig().getMetainfo().getImage();
        }
        return null;
    }

    public String getImage(String instanceImage) {
        if (instanceImage != null) {
            return instanceImage;
        }
        return this.getImage();
    }

    public void setImage(String image) {
        MetaData meta;
        PortletConfig pc = this.getPortletConfig();
        if (pc == null) {
            pc = new BasePortletConfig();
            this.setPortletConfig(pc);
        }
        if ((meta = pc.getMetainfo()) == null) {
            meta = new MetaData();
            pc.setMetainfo(meta);
        }
        meta.setImage(image);
    }

    public boolean getAllowEdit(RunData rundata) {
        return this.allowCustomize(rundata);
    }

    public boolean getAllowView(RunData rundata) {
        return this.allowView(rundata);
    }

    public boolean getAllowMaximize(RunData rundata) {
        return this.allowMaximize(rundata);
    }

    public void init() throws PortletException {
        this.clearContent();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public boolean supportsType(MimeType mimeType) {
        PortletEntry entry = (PortletEntry)Registry.getEntry(Registry.PORTLET, this.getName());
        String baseType = mimeType.toString();
        if (entry != null) {
            Iterator i = entry.listMediaTypes();
            while (i.hasNext()) {
                String name = (String)i.next();
                MediaTypeEntry media = (MediaTypeEntry)Registry.getEntry(Registry.MEDIA_TYPE, name);
                if (media == null || !baseType.equals(media.getMimeType())) continue;
                return true;
            }
        }
        return MimeType.HTML.equals(mimeType);
    }

    public boolean allowClose(RunData rundata) {
        return !this.isClosed(rundata);
    }

    public boolean isClosed(RunData rundata) {
        return this.getAttribute("_display", "normal", rundata).equals("closed");
    }

    public void setClosed(boolean close, RunData rundata) {
        if (this.allowClose(rundata)) {
            this.setAttribute("_display", close ? "closed" : "normal", rundata);
        }
    }

    public boolean allowInfo(RunData rundata) {
        return true;
    }

    public boolean allowCustomize(RunData rundata) {
        return true;
    }

    public boolean allowMaximize(RunData rundata) {
        return true;
    }

    public boolean allowMinimize(RunData rundata) {
        return true;
    }

    public boolean allowView(RunData rundata) {
        return true;
    }

    public boolean allowPrintFriendly(RunData rundata) {
        return true;
    }

    public boolean isMinimized(RunData rundata) {
        return this.getAttribute("_display", "normal", rundata).equals("minimized");
    }

    public void setMinimized(boolean minimize, RunData rundata) {
        if (this.allowMinimize(rundata)) {
            this.setAttribute("_display", minimize ? "minimized" : "normal", rundata);
        }
    }

    public boolean isShowTitleBar(RunData rundata) {
        if (this.getPortletConfig() != null) {
            return Boolean.valueOf(this.getPortletConfig().getInitParameter("_showtitlebar", "true"));
        }
        return this.getAttribute("_showtitlebar", "true", rundata).equals("true");
    }

    public String getAttribute(String attrName, String attrDefValue, RunData rundata) {
        String attrValue = null;
        PortletInstance instance = PersistenceManager.getInstance((Portlet)this, rundata);
        attrValue = instance.getAttribute(attrName, attrDefValue);
        return attrValue;
    }

    public void setAttribute(String attrName, String attrValue, RunData rundata) {
        try {
            PortletInstance instance = PersistenceManager.getInstance((Portlet)this, rundata);
            instance.setAttribute(attrName, attrValue);
            PersistenceManager.store(instance);
        }
        catch (PortalPersistenceException e) {
            logger.error("Exception while setting attribute " + attrName + " for portlet " + this.getName(), e);
        }
    }

    public PortletInstance getInstance(RunData rundata) {
        return PersistenceManager.getInstance((Portlet)this, rundata);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public boolean providesCustomization() {
        return false;
    }
}

