/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.FileWatchPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.jetspeed.util.MimeType;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.jetspeed.util.SimpleTransform;
import org.apache.jetspeed.xml.JetspeedXMLEntityResolver;
import org.apache.turbine.util.RunData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NewRSSPortlet
extends FileWatchPortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(NewRSSPortlet.class.getName());
    public static final String ERROR_NOT_VALID = "This does not appear to be an RSS document";
    public static final String INVALID_TYPE = "Unable to display for this browser";
    private Document document = null;
    private Hashtable stylesheets = null;
    private Hashtable params = null;

    public void init() throws PortletException {
        super.init();
        DocumentBuilder parser = null;
        String url = null;
        this.stylesheets = new Hashtable();
        this.params = new Hashtable();
        Iterator i = this.getPortletConfig().getInitParameterNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            String base = MimeType.HTML.toString();
            if (name.startsWith("stylesheet")) {
                int idx = -1;
                idx = name.indexOf(".");
                if (idx > -1) {
                    base = name.substring(idx + 1, name.length());
                }
                this.stylesheets.put(base, this.getPortletConfig().getInitParameter(name));
                continue;
            }
            this.params.put(name.toLowerCase(), this.getPortletConfig().getInitParameter(name));
        }
        try {
            DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
            docfactory.setValidating(false);
            parser = docfactory.newDocumentBuilder();
            parser.setEntityResolver(new JetspeedXMLEntityResolver());
            url = this.getPortletConfig().getURL();
            String content = JetspeedDiskCache.getInstance().getEntry(url).getData();
            CapabilityMap xmap = CapabilityMapFactory.getCapabilityMap("agentxml/1.0");
            this.setContent((ConcreteElement)new JetspeedClearElement(content), xmap);
            InputSource isrc = new InputSource(this.cleanse(content));
            isrc.setSystemId(url);
            isrc.setEncoding("UTF-8");
            this.document = parser.parse(isrc);
            this.setMetainfo(this.document);
        }
        catch (Throwable t) {
            String message = "RSSPortlet:  Couldn't parse out XML document -> " + url;
            logger.error(message, t);
            throw new PortletException(t.getMessage());
        }
    }

    private void setMetainfo(Document document) throws PortletException {
        Node fc;
        Node dn;
        String title = null;
        String description = null;
        Node channel = null;
        NodeList list = document.getElementsByTagName("channel");
        if (list.getLength() != 1) {
            throw new PortletException(ERROR_NOT_VALID);
        }
        channel = list.item(0);
        Node tn = this.getNode(channel, "title");
        if (tn == null) {
            throw new PortletException(ERROR_NOT_VALID);
        }
        Node fc2 = tn.getFirstChild();
        if (fc2 != null) {
            title = fc2.getNodeValue();
        }
        if ((dn = this.getNode(channel, "description")) != null && (fc = dn.getFirstChild()) != null) {
            description = fc.getNodeValue();
        }
        this.setTitle(title);
        this.setDescription(description);
    }

    public ConcreteElement getContent(RunData data) {
        if (PortletSessionState.getPortletConfigChanged(this, data)) {
            try {
                this.init();
            }
            catch (PortletException pe) {
                logger.error("Exception", pe);
            }
        }
        CapabilityMap map = ((JetspeedRunData)data).getCapability();
        String type = map.getPreferredType().toString();
        JetspeedClearElement content = new JetspeedClearElement(INVALID_TYPE);
        String stylesheet = (String)this.stylesheets.get(type);
        if (stylesheet != null) {
            content = this.getContent(data, map);
            if (content == null) {
                try {
                    content = new JetspeedClearElement(SimpleTransform.transform(this.document, stylesheet, (Map)this.params));
                    this.setContent((ConcreteElement)content, map);
                }
                catch (SAXException e) {
                    logger.error("Exception", e);
                    content = new JetspeedClearElement(e.getMessage());
                }
            }
        } else if (map.getPreferredType().equals(MimeType.XML)) {
            return this.getContent(data, map);
        }
        return content;
    }

    public boolean supportsType(MimeType mimeType) {
        Enumeration en = this.stylesheets.keys();
        while (en.hasMoreElements()) {
            String type = (String)en.nextElement();
            if (!type.equals(mimeType.toString())) continue;
            return true;
        }
        return false;
    }

    private final Node getNode(Node start, String name) {
        NodeList list = start.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!node.getNodeName().equals(name)) continue;
            return node;
        }
        return null;
    }

    private Reader cleanse(String content) throws IOException {
        String filtered = null;
        String XMLDECL = "<?xml version=";
        int start = content.indexOf(XMLDECL);
        filtered = start <= 0 ? content : content.substring(start, content.length());
        return new StringReader(filtered);
    }
}

