/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.FileWatchPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.jetspeed.util.MimeType;
import org.apache.turbine.util.RunData;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.ParserFactory;

public class WMLFilePortlet
extends FileWatchPortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(WMLFilePortlet.class.getName());
    private ConcreteElement content = new StringElement("Not available");

    public boolean supportsType(MimeType type) {
        return type.equals(MimeType.WML);
    }

    public void init() throws PortletException {
        PortletConfig config = this.getPortletConfig();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.content = new JetspeedClearElement(JetspeedDiskCache.getInstance().getEntry(config.getURL()).getData());
        }
        catch (Exception e) {
            throw new PortletException(e.getMessage());
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {}
        }
    }

    public ConcreteElement getContent(RunData data) {
        return this.content;
    }

    class WMLFilter
    extends HandlerBase {
        private static final String DEFAULT_PARSER_NAME = "javax.xml.parsers.SAXParser";
        protected PrintWriter out = new PrintWriter(System.out);

        public WMLFilter(PrintWriter outPW) throws UnsupportedEncodingException {
            this.out = outPW;
        }

        public void filter(String uri) {
            try {
                WMLFilter handler = this;
                Parser parser = ParserFactory.makeParser(DEFAULT_PARSER_NAME);
                parser.setDocumentHandler(handler);
                parser.setErrorHandler(handler);
                parser.parse(uri);
            }
            catch (Exception e) {
                logger.error("Exception", e);
            }
        }

        public void processingInstruction(String target, String data) {
        }

        public void startElement(String name, AttributeList attrs) {
            if (name.equals("wml")) {
                return;
            }
            this.out.print('<');
            this.out.print(name);
            if (attrs != null) {
                int len = attrs.getLength();
                for (int i = 0; i < len; ++i) {
                    this.out.print(' ');
                    this.out.print(attrs.getName(i));
                    this.out.print("=\"");
                    this.out.print(this.normalize(attrs.getValue(i)));
                    this.out.print('\"');
                }
            }
            this.out.print('>');
        }

        public void characters(char[] ch, int start, int length) {
            this.out.print(this.normalize(new String(ch, start, length)));
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
            this.characters(ch, start, length);
        }

        public void endElement(String name) {
            if (name.equals("wml")) {
                return;
            }
            this.out.print("</");
            this.out.print(name);
            this.out.print('>');
        }

        public void endDocument() {
            this.out.flush();
        }

        public void warning(SAXParseException ex) {
            logger.info(this.getLocationString(ex) + ": " + ex.getMessage());
        }

        public void error(SAXParseException ex) {
            logger.error(this.getLocationString(ex) + ": " + ex, ex);
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            logger.error(this.getLocationString(ex) + ": " + ex, ex);
            throw ex;
        }

        private String getLocationString(SAXParseException ex) {
            StringBuffer str = new StringBuffer();
            String systemId = ex.getSystemId();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                str.append(systemId);
            }
            str.append(':');
            str.append(ex.getLineNumber());
            str.append(':');
            str.append(ex.getColumnNumber());
            return str.toString();
        }

        protected String normalize(String s) {
            StringBuffer str = new StringBuffer();
            int len = s != null ? s.length() : 0;
            block6: for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '<': {
                        str.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        str.append("&gt;");
                        continue block6;
                    }
                    case '&': {
                        str.append("&amp;");
                        continue block6;
                    }
                    case '\"': {
                        str.append("&quot;");
                        continue block6;
                    }
                    default: {
                        str.append(ch);
                    }
                }
            }
            return str.toString();
        }
    }
}

