/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets.admin;

import java.util.Enumeration;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.StringElement;
import org.apache.ecs.html.B;
import org.apache.ecs.html.Form;
import org.apache.ecs.html.Input;
import org.apache.ecs.html.P;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TH;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.jetspeed.daemon.DaemonEntry;
import org.apache.jetspeed.daemon.DaemonNotFoundException;
import org.apache.jetspeed.daemon.impl.FeedDaemon;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.services.daemonfactory.DaemonFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;

public class DaemonAdminPortlet
extends AbstractPortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(DaemonAdminPortlet.class.getName());
    public static final String REFRESH = "Start";
    private static final String DAEMON = "daemon";

    public ConcreteElement getContent(RunData rundata) {
        try {
            if (rundata.getParameters().getString(REFRESH) != null) {
                String daemon = rundata.getParameters().getString(DAEMON);
                try {
                    rundata.getParameters().remove(REFRESH);
                    rundata.getParameters().remove(DAEMON);
                    DaemonEntry entry = DaemonFactory.getDaemonEntry(daemon);
                    logger.info("Admin -> asking " + daemon + " to run...");
                    DaemonFactory.process(entry);
                }
                catch (DaemonNotFoundException e) {
                    logger.error("Could not process daemon...", e);
                }
            }
            Table table = new Table().setWidth("100%");
            table.addElement((Element)new TR().addElement((Element)new TH()).addElement((Element)new TH("Name")).addElement((Element)new TH("Status")).addElement((Element)new TH("Result")).addElement((Element)new TH("On Startup")).addElement((Element)new TH("Interval")).addElement((Element)new TH("Classname")));
            DaemonEntry[] entries = DaemonFactory.getDaemonEntries();
            for (int i = 0; i < entries.length; ++i) {
                table.addElement((Element)new TR().addElement((Element)new TD((Element)this.getForm(entries[i].getName(), rundata))).addElement((Element)new TD(entries[i].getName())).addElement((Element)new TD(this.getStatus(DaemonFactory.getStatus(entries[i])))).addElement((Element)new TD(this.getResult(DaemonFactory.getResult(entries[i])))).addElement((Element)new TD(new Boolean(entries[i].onStartup()).toString())).addElement((Element)new TD(Long.toString(entries[i].getInterval()))).addElement((Element)new TD(entries[i].getClassname())));
                String message = DaemonFactory.getMessage(entries[i]);
                if (message == null) continue;
                message = entries[i].getName() + ":  " + message;
                table.addElement((Element)new TR().addElement((Element)new TD().setColSpan(7).addElement(message)));
            }
            ElementContainer content = new ElementContainer();
            content.addElement((Element)table);
            return content;
        }
        catch (Throwable t) {
            logger.error("Throwable", t);
            return new StringElement(t.getMessage());
        }
    }

    private String getStatus(int status) {
        String message = "Unknown";
        switch (status) {
            case 1: {
                message = "Not processed";
                break;
            }
            case 3: {
                message = "Processing...";
                break;
            }
            case 2: {
                message = "Processed";
            }
        }
        return message;
    }

    private String getResult(int result) {
        String message = "Unknown";
        switch (result) {
            case 1: {
                message = "Success";
                break;
            }
            case 2: {
                message = "Failed";
                break;
            }
            case 3: {
                message = "Processing...";
            }
        }
        return message;
    }

    private ConcreteElement getFeedCount() {
        return new P().addElement((Element)new B("Current number of feeds:  ")).addElement(Integer.toString(FeedDaemon.getCount()));
    }

    private Form getForm(String daemon, RunData rundata) {
        Form form = new Form();
        ParameterParser params = rundata.getParameters();
        Enumeration keys = params.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = params.getString(key, "");
            form.addElement((Element)new Input().setName(key).setType("hidden").setValue(value));
        }
        form.addElement((Element)new Input().setType("submit").setName(REFRESH).setValue(REFRESH));
        form.addElement((Element)new Input().setType("hidden").setName(DAEMON).setValue(daemon));
        return form;
    }

    public void init() throws PortletException {
        this.setTitle("Daemons");
        this.setDescription("Configure your daemon...");
    }

    public boolean getAllowEdit(RunData rundata) {
        return false;
    }

    public boolean getAllowMaximize(RunData rundata) {
        return false;
    }
}

