/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets.viewprocessor;

import java.io.Writer;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.portal.portlets.GenericMVCContext;
import org.apache.jetspeed.portal.portlets.viewprocessor.ViewProcessor;
import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class VelocityViewProcessor
implements ViewProcessor {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(VelocityViewProcessor.class.getName());

    public void init(Portlet portlet) throws PortletException {
    }

    public Object processView(GenericMVCContext context) {
        JetspeedClearElement element = null;
        String template = (String)context.get("template");
        logger.info("VelocityViewProcessor - processing " + template);
        try {
            if (-1 == template.indexOf(".vm")) {
                template = template + ".vm";
            }
            logger.info("VelocityViewProcessor - locating template - " + ((RunData)context.get("data")).toString() + template);
            String templatePath = TemplateLocator.locatePortletTemplate((RunData)context.get("data"), template);
            Portlet portlet = (Portlet)context.get("portlet");
            RunData rundata = (RunData)context.get("data");
            long cachePeriod = -1L;
            AbstractPortlet abstractPortlet = null;
            if (portlet instanceof AbstractPortlet && (abstractPortlet = (AbstractPortlet)portlet).getExpirationMillis() != null) {
                cachePeriod = abstractPortlet.getExpirationMillis();
            }
            if (cachePeriod > 0L && abstractPortlet != null) {
                String s = TurbineVelocity.handleRequest((Context)context, (String)templatePath);
                abstractPortlet.setExpirationMillis(cachePeriod + System.currentTimeMillis());
                element = new JetspeedClearElement(s);
            } else {
                TurbineVelocity.handleRequest((Context)context, (String)templatePath, (Writer)rundata.getOut());
            }
        }
        catch (Exception e) {
            element = new JetspeedClearElement(e.toString());
            logger.error("VelocityViewProcessor - had problems handling request - " + e);
            e.printStackTrace();
        }
        TurbineVelocity.requestFinished((Context)context);
        if (element == null) {
            element = new JetspeedClearElement("");
        }
        return element;
    }
}

