/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.jsp.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;

public class JetspeedPortletTag
extends TagSupport {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedPortletTag.class.getName());
    private String name = null;
    private String psml = null;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPsml(String psml) {
        this.psml = psml;
    }

    public String getPsml() {
        return this.psml;
    }

    public int doStartTag() throws JspException {
        JetspeedRunData data = (JetspeedRunData)this.pageContext.getAttribute("rundata", 2);
        if (this.name == null) {
            this.name = data.getPortlet();
        }
        try {
            this.pageContext.getOut().flush();
            ConcreteElement result = new ConcreteElement();
            Entry entry = null;
            if (this.psml != null) {
                ProfileLocator baseLocator = Profiler.createLocator();
                baseLocator.createFromPath(this.psml);
                Profile baseProfile = Profiler.getProfile(baseLocator);
                if (baseProfile != null) {
                    entry = baseProfile.getDocument().getEntry(this.name);
                    if (logger.isDebugEnabled()) {
                        logger.debug("JetspeedPortletTag: retrieved [" + entry + "] from psml [" + this.psml);
                    }
                }
            } else {
                entry = data.getProfile().getDocument().getEntry(this.name);
                if (logger.isDebugEnabled()) {
                    logger.debug("JetspeedPortletTag: retrieved [" + entry + "] from current psml");
                }
            }
            if (entry != null) {
                result = PortletFactory.getPortlet(entry).getContent((RunData)data);
            }
            if (result != null) {
                result.setCodeSet(data.getResponse().getCharacterEncoding());
                result.output(data.getResponse().getWriter());
            }
        }
        catch (Exception e) {
            String message = "Error processing name '" + this.name + "'.";
            logger.error(message, e);
            try {
                data.getOut().print("Error processing portlet '" + this.name + "'. See log for more information.");
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return 0;
    }
}

