/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.logging;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.jetspeed.services.logging.BaseLogger;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.logging.Logger;
import org.apache.turbine.services.logging.LoggingService;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.RunData;

public class JetspeedLoggingService
extends TurbineBaseService
implements LoggingService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedLoggingService.class.getName());
    private HashMap loggers = new HashMap();
    private Logger defaultLogger = null;
    private Logger simpleLogger;
    private ServletContext context = null;
    private ResourceService resources = null;

    public void init() throws InitializationException {
        ServletConfig conf = Turbine.getTurbineServletConfig();
        this.init(conf);
    }

    public void init(ServletConfig config) throws InitializationException {
        this.context = config.getServletContext();
        this.simpleLogger = this.defaultLogger = new BaseLogger(logger);
        this.internalInit();
        this.setInit(true);
    }

    public ResourceService getResources() {
        if (this.resources == null) {
            this.resources = TurbineResources.getResources((String)"services.LoggingService");
            String webappRoot = this.context.getRealPath("/");
            this.resources.setProperty("webappRoot", webappRoot);
        }
        return this.resources;
    }

    private void internalInit() throws InitializationException {
        ResourceService props = this.getResources();
        if (props == null) {
            throw new InitializationException("LoggingService failed to get access to the properties for this service.");
        }
        String defaultLoggerName = props.getString("default");
        if (defaultLoggerName == null) {
            throw new InitializationException("LoggingService can't find default logger name in the configuration file.");
        }
        this.loggers.put(defaultLoggerName, this.defaultLogger);
        if (this.defaultLogger == null) {
            throw new InitializationException("LoggingService can't find default logger in working loggers.");
        }
    }

    public void shutdown() {
        if (!this.getInit()) {
            return;
        }
        for (Map.Entry entry : this.loggers.entrySet()) {
            ((Logger)entry.getValue()).shutdown();
        }
        this.defaultLogger = this.simpleLogger;
    }

    public final Logger getLogger() {
        return this.defaultLogger;
    }

    public Logger getLogger(String logName) {
        Logger logger = (Logger)this.loggers.get(logName);
        if (logger == null) {
            logger = new BaseLogger(JetspeedLogFactoryService.getLogger(logName));
            if (logger == null) {
                return this.defaultLogger;
            }
            this.loggers.put(logName, logger);
        }
        return logger;
    }

    public void setLogLevel(int level) {
        this.defaultLogger.setLogLevel(level);
    }

    public void setLogLevel(String logName, int level) {
        Logger logger = (Logger)this.loggers.get(logName);
        if (logger != null) {
            logger.setLogLevel(level);
        }
    }

    public void setFormat(String format) {
        this.defaultLogger.setFormat(format);
    }

    public void setFormat(String logName, String format) {
        Logger logger = (Logger)this.loggers.get(logName);
        if (logger != null) {
            logger.setFormat(format);
        }
    }

    public void debug(String message) {
        this.defaultLogger.debug(message);
    }

    public void debug(String message, Throwable t) {
        this.defaultLogger.debug(message, t);
    }

    public void debug(String logName, String message, Throwable t) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.debug(message, t);
        } else {
            this.defaultLogger.debug("FROM logger:" + logName + ": " + message);
        }
    }

    public void debug(String logName, String message) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.debug(message);
        } else {
            this.defaultLogger.debug("FROM logger:" + logName + ": " + message);
        }
    }

    public void debug(String message, RunData data) {
        this.defaultLogger.debug(message);
    }

    public void debug(String message, RunData data, Throwable t) {
        this.defaultLogger.debug(message, t);
    }

    public void debug(String logName, String message, RunData data, Throwable t) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.debug(message, data, t);
        } else {
            this.defaultLogger.debug("FROM logger:" + logName + ": " + message);
        }
    }

    public void debug(String logName, String message, RunData data) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.debug(message, data);
        } else {
            this.defaultLogger.debug("FROM logger:" + logName + ": " + message);
        }
    }

    public void info(String message) {
        this.defaultLogger.info(message);
    }

    public void info(String message, Throwable t) {
        this.defaultLogger.info(message, t);
    }

    public void info(String logName, String message) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.info(message);
        } else {
            this.defaultLogger.info("FROM logger:" + logName + ": " + message);
        }
    }

    public void info(String logName, String message, Throwable t) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.info(message, t);
        } else {
            this.defaultLogger.info("FROM logger:" + logName + ": " + message);
        }
    }

    public void info(String message, RunData data) {
        this.defaultLogger.info(message);
    }

    public void info(String message, RunData data, Throwable t) {
        this.defaultLogger.info(message, t);
    }

    public void info(String logName, String message, RunData data) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.info(message, data);
        } else {
            this.defaultLogger.info("FROM logger:" + logName + ": " + message);
        }
    }

    public void info(String logName, String message, RunData data, Throwable t) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.info(message, data, t);
        } else {
            this.defaultLogger.info("FROM logger:" + logName + ": " + message);
        }
    }

    public void warn(String message) {
        this.defaultLogger.warn(message);
    }

    public void warn(String message, Throwable t) {
        this.defaultLogger.warn(message, t);
    }

    public void warn(String logName, String message) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.warn(message);
        } else {
            this.defaultLogger.warn("FROM logger:" + logName + ": " + message);
        }
    }

    public void warn(String logName, String message, Throwable t) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.warn(message, t);
        } else {
            this.defaultLogger.warn("FROM logger:" + logName + ": " + message);
        }
    }

    public void warn(String message, RunData data) {
        this.defaultLogger.warn(message);
    }

    public void warn(String message, RunData data, Throwable t) {
        this.defaultLogger.warn(message, t);
    }

    public void warn(String logName, String message, RunData data) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.warn(message, data);
        } else {
            this.defaultLogger.warn("FROM logger:" + logName + ": " + message);
        }
    }

    public void warn(String logName, String message, RunData data, Throwable t) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.warn(message, data, t);
        } else {
            this.defaultLogger.warn("FROM logger:" + logName + ": " + message);
        }
    }

    public void error(String message) {
        this.defaultLogger.error(message);
    }

    public void error(String message, Throwable t) {
        this.defaultLogger.error(message, t);
    }

    public void error(String logName, String message) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.error(message);
        } else {
            this.defaultLogger.error("FROM logger:" + logName + ": " + message);
        }
    }

    public void error(String logName, String message, Throwable t) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.error(message, t);
        } else {
            this.defaultLogger.error("FROM logger:" + logName + ": " + message);
        }
    }

    public void error(String message, RunData data) {
        this.defaultLogger.error(message);
    }

    public void error(String message, RunData data, Throwable t) {
        this.defaultLogger.error(message, t);
    }

    public void error(String logName, String message, RunData data) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.error(message, data);
        } else {
            this.defaultLogger.error("FROM logger:" + logName + ": " + message);
        }
    }

    public void error(String logName, String message, RunData data, Throwable t) {
        Logger logger = this.getLogger(logName);
        if (logger != null) {
            logger.error(message, data, t);
        } else {
            this.defaultLogger.error("FROM logger:" + logName + ": " + message);
        }
    }
}

